//
//  CLManagedGraphic.m
//  Periodical Engine
//
//  Created by Alex Clarke on 22/04/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLManagedGraphic.h"


@implementation CLManagedGraphic

@dynamic colorData;
@dynamic textColorData;
@dynamic todayTextColorData;
@dynamic todayMarkColorData;
@dynamic dayMarkColorData;

+ (void)initialize
{
    // if any of these properties changes, the bounds have changed
    NSArray *boundsChangingKeys = [NSArray arrayWithObjects: @"xLoc", @"yLoc", @"height", @"width", @"color", @"textColor", @"dayMarkColor", @"todayMarkColor", @"todayTextColor", nil];
    [self setKeys:boundsChangingKeys triggerChangeNotificationsForDependentKey:@"drawingBounds"];
}

+ (NSArray *)keysForNonBoundsProperties
{
    static NSArray *keys = nil;
    if (!keys)
    {
		keys = [[NSArray alloc] initWithObjects:@"xLoc", @"yLoc", @"shadowOffset", @"shadowAngle", nil];
    }
    return keys;
}



//-------------- Graphic drawing methods --------------//

- (NSRect)drawingBounds
{    
	//Draw from the centre
	NSRect drawingBounds = NSMakeRect(xLoc-(width/2), yLoc-(height/2), width, height);
	return drawingBounds;
}


- (BOOL)hitTest:(NSPoint)point isSelected:(BOOL)isSelected
{
	//For subclasses to implement
	return NO;
}

- (void)drawInView:(NSView *)aView
{
	//For subclasses to implement
}

//-------------- Accessors - scalar values -------------//

- (float)xLoc 
{ 
	[self willAccessValueForKey:@"xLoc"];
	float x = xLoc;
	[self didAccessValueForKey:@"xLoc"];
	return x; 
}
- (void)setXLoc:(float)aXLoc
{
	[self willChangeValueForKey:@"xLoc"];
	xLoc = aXLoc;
	[self didChangeValueForKey:@"xLoc"];
}

- (float)yLoc 
{ 
	[self willAccessValueForKey:@"yLoc"];
	float y = yLoc;
	[self didAccessValueForKey:@"yLoc"];
	return y; 
}
- (void)setYLoc:(float)aYLoc
{
	[self willChangeValueForKey:@"yLoc"];
    yLoc = aYLoc;
    [self didChangeValueForKey:@"yLoc"];
}

- (float)width 
{ 
	[self willAccessValueForKey:@"width"];
	float w = width;
	[self didAccessValueForKey:@"width"];
	return w;
}
- (void)setWidth:(float)aWidth
{
	[self willChangeValueForKey:@"width"];
    width = aWidth;
    [self didChangeValueForKey:@"width"];
}

- (float)height 
{ 
	[self willAccessValueForKey:@"height"];
	float h = height;
	[self didAccessValueForKey:@"height"];
	return h; 
}
- (void)setHeight:(float)aHeight
{
	[self willChangeValueForKey:@"height"];
    height = aHeight;
    [self didChangeValueForKey:@"height"];
}

- (NSColor *)color
{
    [self willAccessValueForKey:@"color"];
    NSColor *col = [self primitiveValueForKey:@"color"];
    [self didAccessValueForKey:@"color"];
    if (col == nil)
    {
        NSData *colData = [self colorData];
        if (colData != nil)
        {
            col = [NSUnarchiver unarchiveObjectWithData:colData];
            [self setPrimitiveValue:col forKey:@"color"];
        }
    }
    return col;
}

- (void)setColor:(NSColor *)value
{
    [self willChangeValueForKey:@"color"];
    [self setPrimitiveValue:value forKey:@"color"];
    [self didChangeValueForKey:@"color"];
    [self setValue:[NSArchiver archivedDataWithRootObject:value]
			forKey:@"colorData"];
}


- (NSColor *)textColor
{
    [self willAccessValueForKey:@"textColor"];
    NSColor *col = [self primitiveValueForKey:@"textColor"];
    [self didAccessValueForKey:@"textColor"];
    if (col == nil)
    {
        NSData *colData = [self textColorData];
        if (colData != nil)
        {
            col = [NSUnarchiver unarchiveObjectWithData:colData];
            [self setPrimitiveValue:col forKey:@"textColor" ];
        }
    }
    return col;
}

- (void)setTextColor:(NSColor *)value
{
    [self willChangeValueForKey:@"textColor"];
    [self setPrimitiveValue:value forKey:@"textColor"];
    [self didChangeValueForKey:@"textColor"];
    [self setValue:[NSArchiver archivedDataWithRootObject:value]
			forKey:@"textColorData"];
}

- (NSColor *)todayTextColor {
	
    [self willAccessValueForKey:@"todayTextColor"];
    NSColor *col = [self primitiveValueForKey:@"todayTextColor"];
    [self didAccessValueForKey:@"todayTextColor"];
//	NSLog(@"col: %@", col);
    if (col == nil)
    {
        NSData *colData = [self todayTextColorData];
        if (colData != nil)
        {
            col = [NSUnarchiver unarchiveObjectWithData:colData];
            [self setPrimitiveValue:col forKey:@"todayTextColor" ];
        }
    }
    return col;
}

- (void)setTodayTextColor:(NSColor *)value {

    [self willChangeValueForKey:@"todayTextColor"];
    [self setPrimitiveValue:value forKey:@"todayTextColor"];
    [self didChangeValueForKey:@"todayTextColor"];
    [self setValue:[NSArchiver archivedDataWithRootObject:value]
			forKey:@"todayTextColorData"];
}

- (NSColor *)todayMarkColor {

    [self willAccessValueForKey:@"todayMarkColor"];
    NSColor *col = [self primitiveValueForKey:@"todayMarkColor"];
    [self didAccessValueForKey:@"todayMarkColor"];
    if (col == nil)
    {
        NSData *colData = [self todayMarkColorData];
        if (colData != nil)
        {
            col = [NSUnarchiver unarchiveObjectWithData:colData];
            [self setPrimitiveValue:col forKey:@"todayMarkColor" ];
        }
    }
    return col;
}

- (void)setTodayMarkColor:(NSColor *)value {
	
    [self willChangeValueForKey:@"todayMarkColor"];
    [self setPrimitiveValue:value forKey:@"todayMarkColor"];
    [self didChangeValueForKey:@"todayMarkColor"];
    [self setValue:[NSArchiver archivedDataWithRootObject:value]
			forKey:@"todayMarkColorData"];
}

- (NSColor *)dayMarkColor {

    [self willAccessValueForKey:@"dayMarkColor"];
    NSColor *col = [self primitiveValueForKey:@"dayMarkColor"];
    [self didAccessValueForKey:@"dayMarkColor"];
    if (col == nil)
    {
        NSData *colData = [self dayMarkColorData];
        if (colData != nil)
        {
            col = [NSUnarchiver unarchiveObjectWithData:colData];
            [self setPrimitiveValue:col forKey:@"dayMarkColor" ];
        }
    }
    return col;
}

- (void)setDayMarkColor:(NSColor *)value {
	
    [self willChangeValueForKey:@"dayMarkColor"];
    [self setPrimitiveValue:value forKey:@"dayMarkColor"];
    [self didChangeValueForKey:@"dayMarkColor"];
    [self setValue:[NSArchiver archivedDataWithRootObject:value]
			forKey:@"dayMarkColorData"];
}


- (float)shadowOffset 
{ 
	[self willAccessValueForKey:@"shadowOffset"];
	float w = shadowOffset;
	[self didAccessValueForKey:@"shadowOffset"];
	return w; 
}
- (void)setShadowOffset:(float)aShadowOffset
{
	[self willChangeValueForKey:@"shadowOffset"];
	shadowOffset = aShadowOffset;
	[self didChangeValueForKey:@"shadowOffset"];
}

- (float)shadowAngle 
{ 
	[self willAccessValueForKey:@"shadowAngle"];
	float w = shadowAngle;
	[self didAccessValueForKey:@"shadowAngle"];
	return w; 
}
- (void)setShadowAngle:(float)aShadowAngle
{
	[self willChangeValueForKey:@"shadowAngle"];
	shadowAngle = aShadowAngle;
	[self didChangeValueForKey:@"shadowAngle"];
}

@end
