/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.HsBitVector;
import prpobjects.Transmatrix;
import prpobjects.Uruobjectref;
import prpobjects.plODEPhysical;
import prpobjects.plSynchedObject;
import prpobjects.prpfile;
import prpobjects.uruobj;
import shared.Flt;
import shared.ICompilable;
import shared.Quat;
import shared.ShortTriplet;
import shared.State.AllStates;
import shared.Vertex;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import shared.readwarningexception;
import uru.Bytedeque;
import uru.context;

public class plHKPhysical
extends uruobj {
    public int _version;
    public HKPhysical havok;
    public PXPhysical physx;
    public plODEPhysical ode;

    public static potsflags convertMoulFlagsToPotsFlags(moulflags moul13, String objname, String filename) {
        if (filename == null) {
            filename = "";
        }
        potsflags pots2 = new potsflags();
        byte u14 = moul13.u14;
        int u15 = moul13.u15;
        short LOSDB = moul13.LOSDB;
        int group0 = moul13.group0;
        if (u14 == 4) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)256;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0x3800000;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 0;
            pots2.zzzgroup0 = group0;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 69 && group0 == 0 || u14 == 0 && u15 == 0 && LOSDB == 64 && group0 == 0 || u14 == 0 && u15 == 0 && LOSDB == 68 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 0;
        } else if (u14 == 5 && u15 == 8 && LOSDB == 0 && group0 == 0 || u14 == 5 && u15 == 8 && LOSDB == 0 && group0 == 4 || u14 == 5 && u15 == 8 && LOSDB == 2 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0x8000000;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 4;
            pots2.givemass = true;
        } else if (u14 == 6 && u15 == 0 && LOSDB == 2 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 131072;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 2;
            pots2.zzzgroup0 = 4;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 69 && group0 == 288) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 69;
            pots2.zzzgroup0 = 260;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 2 && group0 == 0 || u14 == 0 && u15 == 0 && LOSDB == 2 && group0 == 32) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 131072;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 2;
            pots2.zzzgroup0 = 4;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 0 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 131072;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 0;
            pots2.zzzgroup0 = 4;
            pots2.givemass = true;
        } else if (u14 == 6 && u15 == 0 && LOSDB == 4 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = 0;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 4;
            pots2.zzzgroup0 = 0;
        } else if (u14 == 6 && u15 == 0 && LOSDB == 2 && group0 == 32) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 2;
            pots2.zzzgroup0 = 4;
        } else if (u14 == 5 && u15 == 8 && LOSDB == 0 && group0 == 288) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0x8000000;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 0;
            pots2.zzzgroup0 = 260;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 5 && group0 == 292) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 5;
            pots2.zzzgroup0 = 260;
        } else if (u14 == 5 && u15 == 24 && LOSDB == 0 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0x1020000;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 0;
            pots2.zzzgroup0 = 4;
            pots2.givemass = true;
        } else if (u14 == 5 && u15 == 8 && LOSDB == 0 && group0 == 32 || u14 == 5 && u15 == 8 && LOSDB == 0 && group0 == 36) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0x8000000;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 0;
            pots2.zzzgroup0 = 36;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 1 && group0 == 4 || u14 == 0 && u15 == 0 && LOSDB == 5 && group0 == 4) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0x1020000;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 4;
        } else if (u14 == 6 && u15 == 0 && LOSDB == 4 && group0 == 288) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = 0;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 4;
            pots2.zzzgroup0 = 260;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 68 && group0 == 32 || u14 == 0 && u15 == 0 && LOSDB == 64 && group0 == 32) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 68;
            pots2.zzzgroup0 = 292;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 68 && group0 == 288 || u14 == 0 && u15 == 0 && LOSDB == 64 && group0 == 288) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 260;
        } else if (u14 == 2 && u15 == 0 && LOSDB == 0 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = 0;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0x1000000;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 64;
            pots2.zzzgroup0 = 0;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 128 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = 0;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = 128;
            pots2.zzzgroup0 = 0;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 8 && group0 == 0) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 131072;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 4;
        } else if (u14 == 1 && u15 == 0 && LOSDB == 0 && group0 == 288) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 256;
        } else if (u14 == 5 && u15 == 8 && LOSDB == 0 && group0 == 292) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)1024;
            pots2.zzzflagsdetect = 131072;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = 260;
        } else if (u14 == 0 && u15 == 0 && LOSDB == 0 && group0 == 544) {
            pots2.zzzu1 = 0;
            pots2.zzzcoltype = (short)512;
            pots2.zzzflagsdetect = 0;
            pots2.zzzflagsrespond = 0;
            pots2.zzzu2 = 0;
            pots2.zzzu3 = 0;
            pots2.zzzLOSDB = LOSDB;
            pots2.zzzgroup0 = group0 & 0xFFFFFFDF | 4;
        } else {
            m.err("plHKPhysical: Unhandled flag combination.: u14=0x", Integer.toHexString(u14), ";u15=0x", Integer.toHexString(u15), ";losdb=0x", Integer.toHexString(LOSDB), ";group0=0x", Integer.toHexString(group0), ";name=", objname);
            return null;
        }
        return pots2;
    }

    public void convertPXtoHK() {
        if (this.havok == null) {
            this.havok = this.physx.convertToHavok();
            this.physx = null;
            this._version = 3;
        } else if (this.physx != null) {
            m.throwUncaughtException("unexpected");
        }
    }

    public void convertODEtoHK(prpfile prp) {
        if (this.havok == null) {
            this.havok = this.ode.convertToHKPhysical(prp);
            this.ode = null;
            this._version = 3;
        } else if (this.ode != null) {
            m.throwUncaughtException("unexpected");
        }
    }

    public plHKPhysical() {
    }

    public plHKPhysical(context c) throws readexception {
        String filenameStart = "";
        String filenameEnd = "";
        String objt = "bahrodoorproxy";
        if (c.curFile.toLowerCase().startsWith(filenameStart.toLowerCase()) && c.curFile.toLowerCase().endsWith(filenameEnd.toLowerCase()) && c.curRootObject.objectname.toString().toLowerCase().startsWith(objt.toLowerCase())) {
            boolean dummy = false;
        }
        if (c.readversion == 6) {
            this._version = 6;
            this.physx = new PXPhysical(c);
        } else if (c.readversion == 4 || c.readversion == 7) {
            this._version = 4;
            this.ode = new plODEPhysical(c);
        } else if (c.readversion == 3) {
            this._version = 3;
            this.havok = new HKPhysical(c);
        }
    }

    public static plHKPhysical createStaticTriangleMeshFromVerticesAndFaces(Vertex[] vertices, ShortTriplet[] faces, Uruobjectref scenenode, Uruobjectref sceneobject) {
        plHKPhysical r = new plHKPhysical();
        r._version = 3;
        r.havok = new HKPhysical();
        r.havok.parent = plSynchedObject.createDefault();
        r.havok.position = Vertex.zero();
        r.havok.orientation = Quat.identityW();
        r.havok.mass = Flt.zero();
        r.havok.RC = Flt.createFromJavaFloat(0.5f);
        r.havok.EL = Flt.createFromJavaFloat(0.0f);
        r.havok.format = 4;
        r.havok.u1 = 0;
        r.havok.coltype = (short)512;
        r.havok.flagsdetect = 0;
        r.havok.flagsrespond = 0;
        r.havok.u2 = 0;
        r.havok.u3 = 0;
        r.havok.LOSDB = 68;
        r.havok.group = HsBitVector.createWithValues(0);
        r.havok.xproxybounds = new HKProxyBounds();
        r.havok.xproxybounds.facecount = faces.length;
        r.havok.xproxybounds.faces = faces;
        r.havok.xproxybounds.parent = new HKHullBounds();
        r.havok.xproxybounds.parent.vertexcount = vertices.length;
        r.havok.xproxybounds.parent.vertices = vertices;
        r.havok.soundgroup = Uruobjectref.none();
        r.havok.subworld = Uruobjectref.none();
        r.havok.scenenode = scenenode;
        r.havok.sceneobject = sceneobject;
        return r;
    }

    public void compile(Bytedeque c) {
        if (this._version == 6) {
            this.physx.compileSpecial(c);
        } else if (this._version == 4) {
            this.ode.compileSpecial(c);
        } else if (this._version == 3) {
            this.havok.compile(c);
        } else {
            m.err("plhkphysical: unknown version in compile.");
        }
    }

    public static class PXMeshBounds {
        byte[] header;
        int u28;
        int u29;
        Flt u30;
        int u31;
        int u32;
        int vertexcount;
        int surfacecount;
        Vertex[] vertices;
        byte[] xu36a;
        short[] xu36b;
        int u37;
        byte[] xu38a;
        short[] xu38b;

        public PXMeshBounds(context c) throws readexception {
            this.header = c.readBytes(8);
            if (!b.BytesToString(this.header).equals("NXS\u0001MESH")) {
                boolean bl = false;
            }
            this.u28 = c.readInt();
            this.u29 = c.readInt();
            this.u30 = new Flt(c);
            this.u31 = c.readInt();
            this.u32 = c.readInt();
            this.vertexcount = c.readInt();
            this.surfacecount = c.readInt();
            this.vertices = (Vertex[])c.readArray(Vertex.class, this.vertexcount);
            if (this.vertexcount <= 256) {
                this.xu36a = c.readBytes(3 * this.surfacecount);
            } else {
                this.xu36b = c.readShorts(3 * this.surfacecount);
            }
            this.u37 = c.readInt();
            if (this.surfacecount <= 256) {
                this.xu38a = c.readBytes(this.surfacecount);
            } else {
                this.xu38b = c.readShorts(this.surfacecount);
            }
        }

        public void compileSpecial(Bytedeque c) {
            c.writeInt(this.vertexcount);
            e.ensure(this.vertices.length == this.vertexcount);
            c.writeArray(this.vertices);
            c.writeInt(this.surfacecount);
            if (this.vertexcount <= 256) {
                e.ensure(this.xu36a.length == this.surfacecount * 3);
                for (int i = 0; i < this.surfacecount * 3; ++i) {
                    short s1 = b.ByteToInt16(this.xu36a[i]);
                    c.writeShort(s1);
                }
            } else {
                e.ensure(this.xu36b.length == this.surfacecount * 3);
                c.writeShorts(this.xu36b);
            }
        }

        public HKProxyBounds convertToHKProxyBounds() {
            HKProxyBounds result = new HKProxyBounds();
            result.parent.vertexcount = this.vertexcount;
            e.ensure(this.vertices.length == this.vertexcount);
            result.parent.vertices = this.vertices;
            result.facecount = this.surfacecount;
            result.faces = new ShortTriplet[this.surfacecount];
            if (this.vertexcount <= 256) {
                e.ensure(this.xu36a.length == this.surfacecount * 3);
                for (int i = 0; i < this.surfacecount; ++i) {
                    short s1 = b.ByteToInt16(this.xu36a[i * 3 + 0]);
                    short s2 = b.ByteToInt16(this.xu36a[i * 3 + 1]);
                    short s3 = b.ByteToInt16(this.xu36a[i * 3 + 2]);
                    result.faces[i] = new ShortTriplet(s1, s2, s3);
                }
            } else {
                e.ensure(this.xu36b.length == this.surfacecount * 3);
                for (int i = 0; i < this.surfacecount; ++i) {
                    short s1 = this.xu36b[i * 3 + 0];
                    short s2 = this.xu36b[i * 3 + 1];
                    short s3 = this.xu36b[i * 3 + 2];
                    result.faces[i] = new ShortTriplet(s1, s2, s3);
                }
            }
            return result;
        }

        public HKExplicitBounds convertToHKExplicitBounds() {
            HKExplicitBounds result = new HKExplicitBounds();
            result.parent = this.convertToHKProxyBounds();
            return result;
        }
    }

    public static class PXConeBounds {
        byte[] yheader1;
        int y1;
        int y2;
        byte[] yheader2;
        int y3;
        byte[] yheader3;
        int y4;
        int vertexcount;
        int surfacecount;
        int y7;
        int y8;
        int y9;
        int y10;
        Vertex[] vertices;
        int y11;
        byte[] xy12a;
        short[] xy12b;

        public PXConeBounds(context c) throws readexception {
            boolean dummy;
            this.yheader1 = c.readBytes(8);
            if (!b.BytesToString(this.yheader1).equals("NXS\u0001CVXM")) {
                dummy = false;
            }
            this.y1 = c.readInt();
            this.y2 = c.readInt();
            this.yheader2 = c.readBytes(8);
            if (!b.BytesToString(this.yheader2).equals("ICE\u0001CLHL")) {
                dummy = false;
            }
            this.y3 = c.readInt();
            this.yheader3 = c.readBytes(8);
            if (!b.BytesToString(this.yheader3).equals("ICE\u0001CVHL")) {
                boolean bl = false;
            }
            this.y4 = c.readInt();
            this.vertexcount = c.readInt();
            this.surfacecount = c.readInt();
            this.y7 = c.readInt();
            this.y8 = c.readInt();
            this.y9 = c.readInt();
            this.y10 = c.readInt();
            this.vertices = (Vertex[])c.readArray(Vertex.class, this.vertexcount);
            this.y11 = c.readInt();
            if (this.vertexcount <= 256) {
                this.xy12a = c.readBytes(3 * this.surfacecount);
            } else {
                this.xy12b = c.readShorts(3 * this.surfacecount);
            }
        }

        public void compileSpecial(Bytedeque c) {
            c.writeInt(this.vertexcount);
            e.ensure(this.vertices.length == this.vertexcount);
            c.writeArray(this.vertices);
        }

        public HKHullBounds convertToHKHullBounds() {
            HKHullBounds result = new HKHullBounds();
            result.vertexcount = this.vertexcount;
            e.ensure(this.vertices.length == this.vertexcount);
            result.vertices = this.vertices;
            return result;
        }
    }

    public static class PXBoxBounds {
        Vertex cornervector;
        Vertex center;

        public PXBoxBounds(context c) throws readexception {
            this.cornervector = new Vertex(c);
            this.center = new Vertex(c);
        }

        public void compileSpecial(Bytedeque c) {
            int vertexcount = 8;
            int facecount = 12;
            ICompilable[] vertices = new Vertex[]{new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.add(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.add(this.cornervector.z)), new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.add(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.add(this.cornervector.z))};
            short[] faces = new short[]{0, 2, 1, 1, 2, 3, 0, 1, 4, 1, 5, 4, 0, 4, 2, 2, 4, 6, 1, 3, 7, 7, 5, 1, 3, 2, 7, 2, 6, 7, 4, 7, 6, 4, 5, 7};
            e.ensure(vertices.length == vertexcount);
            e.ensure(faces.length == facecount * 3);
            c.writeInt(vertexcount);
            c.writeArray(vertices);
            c.writeInt(facecount);
            c.writeShorts(faces);
        }

        public HKBoxBounds convertToHKBoxBounds() {
            HKBoxBounds result = new HKBoxBounds();
            int vertexcount = 8;
            int facecount = 12;
            Vertex[] vertices = new Vertex[]{new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.sub(this.cornervector.z)), new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.add(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.sub(this.cornervector.y), this.center.z.add(this.cornervector.z)), new Vertex(this.center.x.sub(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.add(this.cornervector.z)), new Vertex(this.center.x.add(this.cornervector.x), this.center.y.add(this.cornervector.y), this.center.z.add(this.cornervector.z))};
            ShortTriplet[] faces = new ShortTriplet[]{new ShortTriplet(0, 2, 1), new ShortTriplet(1, 2, 3), new ShortTriplet(0, 1, 4), new ShortTriplet(1, 5, 4), new ShortTriplet(0, 4, 2), new ShortTriplet(2, 4, 6), new ShortTriplet(1, 3, 7), new ShortTriplet(7, 5, 1), new ShortTriplet(3, 2, 7), new ShortTriplet(2, 6, 7), new ShortTriplet(4, 7, 6), new ShortTriplet(4, 5, 7)};
            e.ensure(vertices.length == vertexcount);
            e.ensure(faces.length == facecount * 3);
            result.parent.parent.vertexcount = vertexcount;
            result.parent.parent.vertices = vertices;
            result.parent.facecount = facecount;
            result.parent.faces = faces;
            return result;
        }
    }

    public static class PXSphereBounds {
        Flt radius;
        Vertex offset;

        public PXSphereBounds(context c) throws readexception {
            this.radius = new Flt(c);
            this.offset = new Vertex(c);
        }

        public void compileSpecial(Bytedeque c) {
            this.offset.compile(c);
            this.radius.compile(c);
        }

        public HKSphereBounds convertToHKSphereBounds() {
            HKSphereBounds result = new HKSphereBounds();
            result.offset = this.offset;
            result.radius = this.radius;
            return result;
        }
    }

    public static class HKExplicitBounds
    extends uruobj {
        HKProxyBounds parent;

        public HKExplicitBounds() {
            this.parent = new HKProxyBounds();
        }

        public HKExplicitBounds(context c) throws readexception {
            this.parent = new HKProxyBounds(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
        }

        public void transformVertices(Transmatrix m2) {
            this.parent.transformVertices(m2);
        }
    }

    public static class HKProxyBounds
    extends uruobj {
        HKHullBounds parent;
        int facecount;
        ShortTriplet[] faces;

        public HKProxyBounds() {
            this.parent = new HKHullBounds();
        }

        public HKProxyBounds(context c) throws readexception {
            this.parent = new HKHullBounds(c);
            this.facecount = c.readInt();
            this.faces = (ShortTriplet[])c.readArray(ShortTriplet.class, this.facecount);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.facecount);
            c.writeArray2(this.faces);
        }

        public void transformVertices(Transmatrix m2) {
            this.parent.transformVertices(m2);
        }
    }

    public static class HKHullBounds
    extends uruobj {
        int vertexcount;
        Vertex[] vertices;

        public HKHullBounds() {
        }

        public HKHullBounds(context c) throws readexception {
            this.vertexcount = c.readInt();
            this.vertices = (Vertex[])c.readArray(Vertex.class, this.vertexcount);
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.vertexcount);
            c.writeArray(this.vertices);
        }

        public void transformVertices(Transmatrix m2) {
            for (int i = 0; i < this.vertexcount; ++i) {
                this.vertices[i] = m2.mult(this.vertices[i]);
            }
        }
    }

    public static class HKSphereBounds
    extends uruobj {
        Vertex offset;
        Flt radius;

        public HKSphereBounds() {
        }

        public HKSphereBounds(context c) throws readexception {
            this.offset = new Vertex(c);
            this.radius = new Flt(c);
        }

        public void compile(Bytedeque c) {
            this.offset.compile(c);
            this.radius.compile(c);
        }

        public void transformVertices(Transmatrix m2) {
            this.offset = m2.mult(this.offset);
        }
    }

    public static class HKBoxBounds
    extends uruobj {
        public HKProxyBounds parent;

        public HKBoxBounds() {
            this.parent = new HKProxyBounds();
        }

        public HKBoxBounds(context c) throws readexception {
            this.parent = new HKProxyBounds(c);
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
        }

        public void transformVertices(Transmatrix m2) {
            this.parent.transformVertices(m2);
        }
    }

    public static class HKPhysical
    extends uruobj {
        plSynchedObject parent;
        public Vertex position;
        public Quat orientation;
        public Flt mass;
        public Flt RC;
        public Flt EL;
        public int format;
        public short u1;
        public short coltype;
        public int flagsdetect;
        public int flagsrespond;
        public byte u2;
        public byte u3;
        HKBoxBounds xboxbounds;
        HKSphereBounds xspherebounds;
        HKHullBounds xhullbounds;
        HKProxyBounds xproxybounds;
        HKExplicitBounds xexplicitbounds;
        Uruobjectref sceneobject;
        public HsBitVector group;
        Uruobjectref scenenode;
        public int LOSDB;
        Uruobjectref subworld;
        Uruobjectref soundgroup;

        private HKPhysical() {
        }

        public static HKPhysical createBlank() {
            return new HKPhysical();
        }

        public HKPhysical(context c) throws readexception {
            boolean dummy;
            if (c.curRootObject.objectname.toString().toLowerCase().startsWith("kirelorange")) {
                dummy = false;
            }
            this.parent = new plSynchedObject(c);
            this.position = new Vertex(c);
            this.orientation = new Quat(c);
            this.mass = new Flt(c);
            this.RC = new Flt(c);
            this.EL = new Flt(c);
            this.format = c.readInt();
            this.u1 = c.readShort();
            this.coltype = c.readShort();
            this.flagsdetect = c.readInt();
            this.flagsrespond = c.readInt();
            this.u2 = c.readByte();
            this.u3 = c.readByte();
            switch (this.format) {
                case 1: {
                    this.xboxbounds = new HKBoxBounds(c);
                    break;
                }
                case 2: {
                    this.xspherebounds = new HKSphereBounds(c);
                    break;
                }
                case 3: {
                    this.xhullbounds = new HKHullBounds(c);
                    break;
                }
                case 4: {
                    this.xproxybounds = new HKProxyBounds(c);
                    break;
                }
                case 5: {
                    this.xexplicitbounds = new HKExplicitBounds(c);
                    break;
                }
                default: {
                    m.err("Unknown hkphysical flag");
                }
            }
            this.sceneobject = new Uruobjectref(c);
            this.group = new HsBitVector(c);
            this.scenenode = new Uruobjectref(c);
            this.LOSDB = c.readInt();
            this.subworld = new Uruobjectref(c);
            if (this.subworld.hasref()) {
                dummy = false;
            }
            this.soundgroup = new Uruobjectref(c);
            if (AllStates.getStateAsBoolean("reportPhysics")) {
                String text = "Physics:" + c.curFile + "," + c.curRootObject.objectname.toString() + "," + Integer.toHexString(this.format) + "," + Integer.toHexString(this.u1) + "," + Integer.toHexString(this.coltype) + "," + Integer.toHexString(this.flagsdetect) + "," + Integer.toHexString(this.flagsrespond) + "," + Integer.toHexString(this.u2) + "," + Integer.toHexString(this.u3) + "," + Integer.toHexString(this.LOSDB) + "," + Integer.toHexString(this.group.values[0]);
                m.msg(text);
            }
        }

        public void compile(Bytedeque c) {
            this.parent.compile(c);
            this.position.compile(c);
            this.orientation.compile(c);
            this.mass.compile(c);
            this.RC.compile(c);
            this.EL.compile(c);
            c.writeInt(this.format);
            c.writeShort(this.u1);
            c.writeShort(this.coltype);
            c.writeInt(this.flagsdetect);
            c.writeInt(this.flagsrespond);
            c.writeByte(this.u2);
            c.writeByte(this.u3);
            switch (this.format) {
                case 1: {
                    this.xboxbounds.compile(c);
                    break;
                }
                case 2: {
                    this.xspherebounds.compile(c);
                    break;
                }
                case 3: {
                    this.xhullbounds.compile(c);
                    break;
                }
                case 4: {
                    this.xproxybounds.compile(c);
                    break;
                }
                case 5: {
                    this.xexplicitbounds.compile(c);
                    break;
                }
                default: {
                    m.err("Unknown hkphysical flag");
                }
            }
            this.sceneobject.compile(c);
            this.group.compile(c);
            this.scenenode.compile(c);
            c.writeInt(this.LOSDB);
            this.subworld.compile(c);
            this.soundgroup.compile(c);
        }

        public void transformVertices(Transmatrix mat) {
            switch (this.format) {
                case 1: {
                    this.xboxbounds.transformVertices(mat);
                    break;
                }
                case 2: {
                    this.xspherebounds.transformVertices(mat);
                    break;
                }
                case 3: {
                    this.xhullbounds.transformVertices(mat);
                    break;
                }
                case 4: {
                    this.xproxybounds.transformVertices(mat);
                    break;
                }
                case 5: {
                    this.xexplicitbounds.transformVertices(mat);
                    break;
                }
                default: {
                    m.err("Unknown hkphysical flag");
                }
            }
        }
    }

    public static class PXPhysical
    extends uruobj {
        plSynchedObject parent;
        public Flt mass;
        Flt RC;
        Flt EL;
        byte format;
        byte u14;
        int u15;
        short LOSDB;
        Uruobjectref sceneobject;
        Uruobjectref scenenode;
        public Uruobjectref subworld;
        Uruobjectref soundgroup;
        public Vertex position;
        public Quat orientation;
        HsBitVector group;
        PXSphereBounds xu24a;
        PXBoxBounds xu24b;
        PXConeBounds xu24c;
        PXMeshBounds xu24d;

        public PXPhysical(context c) throws readexception {
            if (c.curRootObject.objectname.toString().toLowerCase().startsWith("kirelorange")) {
                boolean dummy = false;
            }
            this.parent = new plSynchedObject(c);
            this.mass = new Flt(c);
            this.RC = new Flt(c);
            this.EL = new Flt(c);
            this.format = c.readByte();
            this.u14 = c.readByte();
            this.u15 = c.readInt();
            this.LOSDB = c.readShort();
            this.sceneobject = new Uruobjectref(c);
            this.scenenode = new Uruobjectref(c);
            this.subworld = new Uruobjectref(c);
            boolean nullifysubworlds = false;
            if (nullifysubworlds && this.subworld.hasRef != 0) {
                m.warn("Subworld in PhysX physical not supported, object: " + c.curRootObject.toString());
                this.subworld = Uruobjectref.none();
            }
            this.soundgroup = new Uruobjectref(c);
            this.position = new Vertex(c);
            boolean plpxphysicalQuatChange = false;
            if (plpxphysicalQuatChange) {
                this.orientation = Quat.readXYZW(c.in);
                m.warn("Using new Quat form in PlPXPhysical, if you have problems with physics, try reverting it.");
            } else {
                this.orientation = new Quat(c);
            }
            this.group = new HsBitVector(c);
            if (this.format == 2) {
                this.xu24a = new PXSphereBounds(c);
            } else if (this.format == 1) {
                this.xu24b = new PXBoxBounds(c);
            } else if (this.format == 3) {
                this.xu24c = new PXConeBounds(c);
            } else {
                this.xu24d = new PXMeshBounds(c);
            }
            if (AllStates.getStateAsBoolean("reportPhysics")) {
                String text = "Physics:" + Integer.toHexString(this.format) + "," + Integer.toHexString(this.u14) + "," + Integer.toHexString(this.u15) + "," + Integer.toHexString(this.LOSDB) + "," + Integer.toHexString(this.group.values[0]) + "," + c.curFile + "," + c.curRootObject.objectname.toString();
                m.msg(text);
            }
            moulflags moul13 = new moulflags();
            moul13.u14 = this.u14;
            moul13.u15 = this.u15;
            moul13.LOSDB = this.LOSDB;
            moul13.group0 = this.group.values[0];
            potsflags pots2 = plHKPhysical.convertMoulFlagsToPotsFlags(moul13, c.curRootObject.toString(), c.curFile);
            if (pots2 == null) {
                String msg = "plHKPhysical: Can read okay, but failing in order to ignore. (u14=" + Integer.toString(moul13.u14) + ", u15=" + Integer.toString(moul13.u15) + ", losdb=0x" + Integer.toHexString(moul13.LOSDB) + ", group0=0x" + Integer.toHexString(moul13.group0) + " ) (" + c.curRootObject.toString() + ")";
                throw new readwarningexception(msg);
            }
        }

        public void compileSpecial(Bytedeque c) {
            moulflags moul13 = new moulflags();
            moul13.u14 = this.u14;
            moul13.u15 = this.u15;
            moul13.LOSDB = this.LOSDB;
            moul13.group0 = this.group.values[0];
            potsflags pots2 = plHKPhysical.convertMoulFlagsToPotsFlags(moul13, "", "");
            if (pots2 == null) {
                m.err("plHKPhysical: Unexpected combination.");
            }
            short zzzu1 = pots2.zzzu1;
            short zzzcoltype = pots2.zzzcoltype;
            int zzzflagsdetect = pots2.zzzflagsdetect;
            int zzzflagsrespond = pots2.zzzflagsrespond;
            byte zzzu2 = pots2.zzzu2;
            byte zzzu3 = pots2.zzzu3;
            int zzzLOSDB = pots2.zzzLOSDB;
            HsBitVector zzzgroup = new HsBitVector(pots2.zzzgroup0);
            if (pots2.givemass) {
                this.mass = Flt.one();
            }
            this.parent.compile(c);
            this.position.compile(c);
            this.orientation.compile(c);
            this.mass.compile(c);
            this.RC.compile(c);
            this.EL.compile(c);
            c.writeInt(b.ByteToInt32(this.format));
            c.writeShort(zzzu1);
            c.writeShort(zzzcoltype);
            c.writeInt(zzzflagsdetect);
            c.writeInt(zzzflagsrespond);
            c.writeByte(zzzu2);
            c.writeByte(zzzu3);
            switch (this.format) {
                case 1: {
                    this.xu24b.compileSpecial(c);
                    break;
                }
                case 2: {
                    this.xu24a.compileSpecial(c);
                    break;
                }
                case 3: {
                    this.xu24c.compileSpecial(c);
                    break;
                }
                case 4: 
                case 5: {
                    this.xu24d.compileSpecial(c);
                    break;
                }
                default: {
                    m.err("Unknown hkphysical flag");
                }
            }
            this.sceneobject.compile(c);
            zzzgroup.compile(c);
            this.scenenode.compile(c);
            c.writeInt(zzzLOSDB);
            this.subworld.compile(c);
            this.soundgroup.compile(c);
        }

        public HKPhysical convertToHavok() {
            moulflags moul13 = new moulflags();
            moul13.u14 = this.u14;
            moul13.u15 = this.u15;
            moul13.LOSDB = this.LOSDB;
            moul13.group0 = this.group.values[0];
            potsflags pots2 = plHKPhysical.convertMoulFlagsToPotsFlags(moul13, "", "");
            if (pots2 == null) {
                m.err("plHKPhysical: Unexpected combination.");
            }
            short zzzu1 = pots2.zzzu1;
            short zzzcoltype = pots2.zzzcoltype;
            int zzzflagsdetect = pots2.zzzflagsdetect;
            int zzzflagsrespond = pots2.zzzflagsrespond;
            byte zzzu2 = pots2.zzzu2;
            byte zzzu3 = pots2.zzzu3;
            int zzzLOSDB = pots2.zzzLOSDB;
            HsBitVector zzzgroup = new HsBitVector(pots2.zzzgroup0);
            if (pots2.givemass) {
                this.mass = Flt.one();
            }
            HKPhysical r = new HKPhysical();
            r.parent = this.parent;
            r.position = this.position;
            r.orientation = this.orientation;
            r.mass = this.mass;
            r.RC = this.RC;
            r.EL = this.EL;
            r.format = b.ByteToInt32(this.format);
            r.u1 = zzzu1;
            r.coltype = zzzcoltype;
            r.flagsdetect = zzzflagsdetect;
            r.flagsrespond = zzzflagsrespond;
            r.u2 = zzzu2;
            r.u3 = zzzu3;
            switch (this.format) {
                case 1: {
                    r.xboxbounds = this.xu24b.convertToHKBoxBounds();
                    break;
                }
                case 2: {
                    r.xspherebounds = this.xu24a.convertToHKSphereBounds();
                    break;
                }
                case 3: {
                    r.xhullbounds = this.xu24c.convertToHKHullBounds();
                    break;
                }
                case 4: {
                    r.xproxybounds = this.xu24d.convertToHKProxyBounds();
                    break;
                }
                case 5: {
                    r.xexplicitbounds = this.xu24d.convertToHKExplicitBounds();
                    break;
                }
                default: {
                    m.err("Unknown hkphysical flag");
                }
            }
            r.sceneobject = this.sceneobject;
            r.group = zzzgroup;
            r.scenenode = this.scenenode;
            r.LOSDB = zzzLOSDB;
            r.subworld = this.subworld;
            r.soundgroup = this.soundgroup;
            return r;
        }

        public void compile(Bytedeque c) {
            m.err("hkphysical: compile not implemented.");
        }
    }

    public static class moulflags {
        byte u14;
        int u15;
        short LOSDB;
        int group0;
    }

    public static class potsflags {
        short zzzu1 = 0;
        short zzzcoltype = (short)512;
        int zzzflagsdetect = 0;
        int zzzflagsrespond = 0;
        byte zzzu2 = 0;
        byte zzzu3 = 0;
        int zzzLOSDB = 0;
        int zzzgroup0 = 0;
        boolean givemass = false;
    }
}

