/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZMA;

import SevenZip.Compression.LZ.OutWindow;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitTreeDecoder;
import SevenZip.ICompressCoder;
import SevenZip.ICompressGetInStreamProcessedSize;
import SevenZip.ICompressProgressInfo;
import SevenZip.ICompressSetDecoderProperties2;
import SevenZip.ICompressSetInStream;
import SevenZip.ICompressSetOutStreamSize;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder
extends InputStream
implements ICompressCoder,
ICompressSetDecoderProperties2,
ICompressGetInStreamProcessedSize,
ICompressSetInStream,
ICompressSetOutStreamSize {
    OutWindow m_OutWindow = new OutWindow();
    SevenZip.Compression.RangeCoder.Decoder m_RangeDecoder = new SevenZip.Compression.RangeCoder.Decoder();
    short[] m_IsMatchDecoders = new short[192];
    short[] m_IsRepDecoders = new short[12];
    short[] m_IsRepG0Decoders = new short[12];
    short[] m_IsRepG1Decoders = new short[12];
    short[] m_IsRepG2Decoders = new short[12];
    short[] m_IsRep0LongDecoders = new short[192];
    BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    short[] m_PosDecoders = new short[114];
    BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    LenDecoder m_LenDecoder = new LenDecoder();
    LenDecoder m_RepLenDecoder = new LenDecoder();
    LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
    int m_DictionarySize = -1;
    int m_DictionarySizeCheck = -1;
    int m_posStateMask;
    long _outSize = 0L;
    boolean _outSizeDefined = false;
    int _remainLen;
    static final int kLenIdFinished = -1;
    static final int kLenIdNeedInit = -2;
    int _rep0;
    int _rep1;
    int _rep2;
    int _rep3;
    int _state;

    public Decoder() {
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
        }
    }

    boolean SetDictionarySize(int dictionarySize) {
        if (dictionarySize < 0) {
            return false;
        }
        if (this.m_DictionarySize != dictionarySize) {
            this.m_DictionarySize = dictionarySize;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.Create(Math.max(this.m_DictionarySizeCheck, 4096));
            this.m_RangeDecoder.Create(0x100000);
        }
        return true;
    }

    boolean SetLcLpPb(int lc, int lp, int pb) {
        if (lc > 8 || lp > 4 || pb > 4) {
            return false;
        }
        this.m_LiteralDecoder.Create(lp, lc);
        int numPosStates = 1 << pb;
        this.m_LenDecoder.Create(numPosStates);
        this.m_RepLenDecoder.Create(numPosStates);
        this.m_posStateMask = numPosStates - 1;
        return true;
    }

    public long GetInStreamProcessedSize() {
        throw new UnknownError("GetInStreamProcessedSize");
    }

    public int ReleaseInStream() throws IOException {
        this.m_RangeDecoder.ReleaseStream();
        return 0;
    }

    public int SetInStream(InputStream inStream) {
        this.m_RangeDecoder.SetStream(inStream);
        return 0;
    }

    public int SetOutStreamSize(long outSize) {
        boolean bl = this._outSizeDefined = outSize != -1L;
        if (this._outSizeDefined) {
            this._outSize = outSize;
        }
        this._remainLen = -2;
        this.m_OutWindow.Init();
        return 0;
    }

    public int read() throws IOException {
        throw new IOException("LZMA Decoder - read() not implemented");
    }

    public int read(byte[] data, int off, int size) throws IOException {
        if (off != 0) {
            throw new IOException("LZMA Decoder - read(byte [] data, int off != 0, int size)) not implemented");
        }
        long startPos = this.m_OutWindow.GetProcessedSize();
        this.m_OutWindow.SetMemStream(data);
        int res = this.CodeSpec(size);
        if (res != 0) {
            throw new IOException("Read - CodeSpec = " + res);
        }
        res = this.Flush();
        if (res != 0) {
            throw new IOException("Read - Flush = " + res);
        }
        int ret = (int)(this.m_OutWindow.GetProcessedSize() - startPos);
        if (ret == 0) {
            ret = -1;
        }
        return ret;
    }

    void Init() throws IOException {
        this.m_OutWindow.Init(false);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsMatchDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRep0LongDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG0Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG1Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG2Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_PosDecoders);
        this._rep3 = 0;
        this._rep2 = 0;
        this._rep1 = 0;
        this._rep0 = 0;
        this._state = Base.StateInit();
        this.m_LiteralDecoder.Init();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i].Init();
        }
        this.m_LenDecoder.Init();
        this.m_RepLenDecoder.Init();
        this.m_PosAlignDecoder.Init();
    }

    public int Flush() throws IOException {
        this.m_OutWindow.Flush();
        return 0;
    }

    void ReleaseStreams() throws IOException {
        this.m_OutWindow.ReleaseStream();
        this.ReleaseInStream();
    }

    public int CodeReal(InputStream inStream, OutputStream outStream, long outSize, ICompressProgressInfo progress) throws IOException {
        this.SetInStream(inStream);
        this.m_OutWindow.SetStream(outStream);
        this.SetOutStreamSize(outSize);
        do {
            long nowPos64;
            long inSize;
            int curSize;
            int res;
            if ((res = this.CodeSpec(curSize = 262144)) != 0) {
                return res;
            }
            if (this._remainLen == -1) break;
            if (progress == null || (res = progress.SetRatioInfo(inSize = this.m_RangeDecoder.GetProcessedSize(), nowPos64 = this.m_OutWindow.GetProcessedSize())) == 0) continue;
            return res;
        } while (!this._outSizeDefined || this.m_OutWindow.GetProcessedSize() < this._outSize);
        return this.Flush();
    }

    public int Code(InputStream inStream, OutputStream outStream, long outSize, ICompressProgressInfo progress) throws IOException {
        int ret = 1;
        try {
            ret = this.CodeReal(inStream, outStream, outSize, progress);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw e2;
        }
        finally {
            this.Flush();
            this.ReleaseStreams();
        }
        return ret;
    }

    int CodeSpec(int curSize) throws IOException {
        byte prevByte;
        long rem;
        if (this._outSizeDefined && (long)curSize > (rem = this._outSize - this.m_OutWindow.GetProcessedSize())) {
            curSize = (int)rem;
        }
        if (this._remainLen == -1) {
            return 0;
        }
        if (this._remainLen == -2) {
            this.m_RangeDecoder.Init();
            this.Init();
            this._remainLen = 0;
        }
        if (curSize == 0) {
            return 0;
        }
        int rep0 = this._rep0;
        int rep1 = this._rep1;
        int rep2 = this._rep2;
        int rep3 = this._rep3;
        int state = this._state;
        while (this._remainLen > 0 && curSize > 0) {
            prevByte = this.m_OutWindow.GetByte(rep0);
            this.m_OutWindow.PutByte(prevByte);
            --this._remainLen;
            --curSize;
        }
        long nowPos64 = this.m_OutWindow.GetProcessedSize();
        prevByte = nowPos64 == 0L ? (byte)0 : this.m_OutWindow.GetByte(0);
        while (curSize > 0) {
            int len;
            if (this.m_RangeDecoder.bufferedStream.WasFinished()) {
                return 1;
            }
            int posState = (int)nowPos64 & this.m_posStateMask;
            if (this.m_RangeDecoder.DecodeBit(this.m_IsMatchDecoders, (state << 4) + posState) == 0) {
                LiteralDecoder.Decoder2 decoder2 = this.m_LiteralDecoder.GetDecoder((int)nowPos64, prevByte);
                prevByte = !Base.StateIsCharState(state) ? decoder2.DecodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.GetByte(rep0)) : decoder2.DecodeNormal(this.m_RangeDecoder);
                this.m_OutWindow.PutByte(prevByte);
                state = Base.StateUpdateChar(state);
                --curSize;
                ++nowPos64;
                continue;
            }
            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepDecoders, state) == 1) {
                len = 0;
                if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG0Decoders, state) == 0) {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRep0LongDecoders, (state << 4) + posState) == 0) {
                        state = Base.StateUpdateShortRep(state);
                        len = 1;
                    }
                } else {
                    int distance;
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG1Decoders, state) == 0) {
                        distance = rep1;
                    } else {
                        if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG2Decoders, state) == 0) {
                            distance = rep2;
                        } else {
                            distance = rep3;
                            rep3 = rep2;
                        }
                        rep2 = rep1;
                    }
                    rep1 = rep0;
                    rep0 = distance;
                }
                if (len == 0) {
                    len = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, posState) + 2;
                    state = Base.StateUpdateRep(state);
                }
            } else {
                rep3 = rep2;
                rep2 = rep1;
                rep1 = rep0;
                len = 2 + this.m_LenDecoder.Decode(this.m_RangeDecoder, posState);
                state = Base.StateUpdateMatch(state);
                int posSlot = this.m_PosSlotDecoder[Base.GetLenToPosState(len)].Decode(this.m_RangeDecoder);
                if (posSlot >= 4) {
                    int numDirectBits = (posSlot >> 1) - 1;
                    rep0 = (2 | posSlot & 1) << numDirectBits;
                    if (posSlot < 14) {
                        rep0 += BitTreeDecoder.ReverseDecode(this.m_PosDecoders, rep0 - posSlot - 1, this.m_RangeDecoder, numDirectBits);
                    } else {
                        rep0 += this.m_RangeDecoder.DecodeDirectBits(numDirectBits - 4) << 4;
                        if ((rep0 += this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder)) < 0) {
                            if (rep0 == -1) break;
                            return 1;
                        }
                    }
                } else {
                    rep0 = posSlot;
                }
            }
            if ((long)rep0 >= nowPos64 || rep0 >= this.m_DictionarySizeCheck) {
                this._remainLen = -1;
                return 1;
            }
            int locLen = len;
            if (len > curSize) {
                locLen = curSize;
            }
            this.m_OutWindow.CopyBlock(rep0, locLen);
            prevByte = this.m_OutWindow.GetByte(0);
            curSize -= locLen;
            nowPos64 += (long)locLen;
            if ((len -= locLen) == 0) continue;
            this._remainLen = len;
            break;
        }
        if (this.m_RangeDecoder.bufferedStream.WasFinished()) {
            return 1;
        }
        this._rep0 = rep0;
        this._rep1 = rep1;
        this._rep2 = rep2;
        this._rep3 = rep3;
        this._state = state;
        return 0;
    }

    public boolean SetDecoderProperties2(byte[] properties) {
        if (properties.length < 5) {
            return false;
        }
        int val = properties[0] & 0xFF;
        int lc = val % 9;
        int remainder = val / 9;
        int lp = remainder % 5;
        int pb = remainder / 5;
        int dictionarySize = 0;
        for (int i = 0; i < 4; ++i) {
            dictionarySize += (properties[1 + i] & 0xFF) << i * 8;
        }
        if (!this.SetLcLpPb(lc, lp, pb)) {
            return false;
        }
        return this.SetDictionarySize(dictionarySize);
    }

    class LiteralDecoder {
        Decoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralDecoder() {
        }

        public void Create(int numPosBits, int numPrevBits) {
            if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
                return;
            }
            this.m_NumPosBits = numPosBits;
            this.m_PosMask = (1 << numPosBits) - 1;
            this.m_NumPrevBits = numPrevBits;
            int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Decoder2[numStates];
            for (int i = 0; i < numStates; ++i) {
                this.m_Coders[i] = new Decoder2();
            }
        }

        public void Init() {
            int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < numStates; ++i) {
                this.m_Coders[i].Init();
            }
        }

        Decoder2 GetDecoder(int pos, byte prevByte) {
            return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + ((prevByte & 0xFF) >>> 8 - this.m_NumPrevBits)];
        }

        class Decoder2 {
            short[] m_Decoders = new short[768];

            Decoder2() {
            }

            public void Init() {
                SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_Decoders);
            }

            public byte DecodeNormal(SevenZip.Compression.RangeCoder.Decoder rangeDecoder) throws IOException {
                int symbol = 1;
                while ((symbol = symbol << 1 | rangeDecoder.DecodeBit(this.m_Decoders, symbol)) < 256) {
                }
                return (byte)symbol;
            }

            public byte DecodeWithMatchByte(SevenZip.Compression.RangeCoder.Decoder rangeDecoder, byte matchByte) throws IOException {
                int symbol = 1;
                do {
                    int matchBit = matchByte >> 7 & 1;
                    matchByte = (byte)(matchByte << 1);
                    int bit = rangeDecoder.DecodeBit(this.m_Decoders, (1 + matchBit << 8) + symbol);
                    symbol = symbol << 1 | bit;
                    if (matchBit == bit) continue;
                    while (symbol < 256) {
                        symbol = symbol << 1 | rangeDecoder.DecodeBit(this.m_Decoders, symbol);
                    }
                    break;
                } while (symbol < 256);
                return (byte)symbol;
            }
        }
    }

    class LenDecoder {
        short[] m_Choice = new short[2];
        BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
        BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
        BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
        int m_NumPosStates = 0;

        LenDecoder() {
        }

        public void Create(int numPosStates) {
            while (this.m_NumPosStates < numPosStates) {
                this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                ++this.m_NumPosStates;
            }
        }

        public void Init() {
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_Choice);
            for (int posState = 0; posState < this.m_NumPosStates; ++posState) {
                this.m_LowCoder[posState].Init();
                this.m_MidCoder[posState].Init();
            }
            this.m_HighCoder.Init();
        }

        public int Decode(SevenZip.Compression.RangeCoder.Decoder rangeDecoder, int posState) throws IOException {
            if (rangeDecoder.DecodeBit(this.m_Choice, 0) == 0) {
                return this.m_LowCoder[posState].Decode(rangeDecoder);
            }
            int symbol = 8;
            symbol = rangeDecoder.DecodeBit(this.m_Choice, 1) == 0 ? (symbol += this.m_MidCoder[posState].Decode(rangeDecoder)) : (symbol += 8 + this.m_HighCoder.Decode(rangeDecoder));
            return symbol;
        }
    }
}

