/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import auto.AllGames;
import java.io.File;
import java.util.HashMap;
import parsers.ageparser;
import parsers.sdlparser;
import shared.FileUtils;
import shared.m;
import uru.UruCrypt;

public class AgesInfo {
    AllSdlInfo sdl;
    AllAgeInfo age;

    public AgesInfo(String agefolder, String sdlfolder) {
        this.initialize(agefolder, sdlfolder);
    }

    public ageparser.Agefile getAge(String ageFilename) {
        ageparser.Agefile agefile = this.age.ages.get(ageFilename);
        return agefile;
    }

    public int getSequencePrefixForAge(String ageFilename) {
        ageparser.Agefile agefile = this.age.ages.get(ageFilename);
        return agefile.sequenceprefix;
    }

    public sdlparser.Statedesc getStatedesc(String name, int version) {
        sdlparser.Statedesc sd = this.sdl.sdls.get(name);
        if (sd == null) {
            m.throwUncaughtException("Statedesc name not found: " + name);
        }
        if (sd.version != version) {
            m.throwUncaughtException("Statedesc versions don't match. Server expects " + Integer.toString(sd.version) + " but gets " + Integer.toString(version));
        }
        return sd;
    }

    public sdlparser.Statedesc getNewestStatedesc(String name) {
        sdlparser.Statedesc sd = this.sdl.sdls.get(name);
        if (sd == null) {
            m.throwUncaughtException("Statedesc name not found: " + name);
        }
        return sd;
    }

    public void initialize(String agefolder, String sdlfolder) {
        this.sdl = new AllSdlInfo();
        File sdlpath = new File(sdlfolder);
        for (File child : sdlpath.listFiles()) {
            if (!child.isFile() || !child.getName().toLowerCase().endsWith(".sdl")) continue;
            byte[] data = FileUtils.ReadFile(child);
            sdlparser.Sdlfile sdlfile2 = sdlparser.parse(data);
            this.sdl.addSdlfile(sdlfile2);
        }
        this.age = new AllAgeInfo();
        File agepath = new File(agefolder);
        for (File child : agepath.listFiles()) {
            if (!child.isFile() || !child.getName().toLowerCase().endsWith(".age")) continue;
            byte[] data = FileUtils.ReadFile(child);
            data = UruCrypt.DecryptAny(data, AllGames.getMoul().g);
            String agename = child.getName();
            agename = agename.substring(0, agename.length() - ".age".length());
            ageparser.Agefile agefile = ageparser.parse(data, agename);
            this.age.addAgefile(agefile);
        }
    }

    public static class AllAgeInfo {
        HashMap<String, ageparser.Agefile> ages = new HashMap();

        public void addAgefile(ageparser.Agefile agefile) {
            this.ages.put(agefile.agename, agefile);
        }
    }

    public static class AllSdlInfo {
        HashMap<String, sdlparser.Statedesc> sdls = new HashMap();

        public void addSdlfile(sdlparser.Sdlfile sdlfile2) {
            for (sdlparser.Statedesc statedesc : sdlfile2.statedescs) {
                sdlparser.Statedesc curstatedesc = this.sdls.get(statedesc.name);
                if (curstatedesc != null && statedesc.version < curstatedesc.version) continue;
                if (curstatedesc != null && curstatedesc.version == statedesc.version) {
                    m.warn("Two statedescs have the same version: " + statedesc.name);
                }
                this.sdls.put(statedesc.name, statedesc);
            }
        }
    }
}

