/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int key_size = 16;
    private static final int delta = -1640531527;
    private static final int d_sum = -957401312;
    private int[] _S = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "XTEA";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + params.getClass().getName());
        }
        this._forEncryption = forEncryption;
        this._initialised = true;
        KeyParameter p = (KeyParameter)params;
        this.setKey(p.getKey());
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(in, inOff, out, outOff) : this.decryptBlock(in, inOff, out, outOff);
    }

    public void reset() {
    }

    private void setKey(byte[] key) {
        this._S[0] = this.bytesToInt(key, 0);
        this._S[1] = this.bytesToInt(key, 4);
        this._S[2] = this.bytesToInt(key, 8);
        this._S[3] = this.bytesToInt(key, 12);
    }

    private int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int v0 = this.bytesToInt(in, inOff);
        int v1 = this.bytesToInt(in, inOff + 4);
        int sum = 0;
        for (int i = 0; i != 32; ++i) {
            v1 += ((v0 += (v1 << 4 ^ v1 >>> 5) + v1 ^ sum + this._S[sum & 3]) << 4 ^ v0 >>> 5) + v0 ^ (sum -= 1640531527) + this._S[sum >>> 11 & 3];
        }
        this.unpackInt(v0, out, outOff);
        this.unpackInt(v1, out, outOff + 4);
        return 8;
    }

    private int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int v0 = this.bytesToInt(in, inOff);
        int v1 = this.bytesToInt(in, inOff + 4);
        int sum = -957401312;
        for (int i = 0; i != 32; ++i) {
            v0 -= ((v1 -= (v0 << 4 ^ v0 >>> 5) + v0 ^ sum + this._S[sum >>> 11 & 3]) << 4 ^ v1 >>> 5) + v1 ^ (sum += 1640531527) + this._S[sum & 3];
        }
        this.unpackInt(v0, out, outOff);
        this.unpackInt(v1, out, outOff + 4);
        return 8;
    }

    private int bytesToInt(byte[] in, int inOff) {
        return in[inOff++] << 24 | (in[inOff++] & 0xFF) << 16 | (in[inOff++] & 0xFF) << 8 | in[inOff] & 0xFF;
    }

    private void unpackInt(int v, byte[] out, int outOff) {
        out[outOff++] = (byte)(v >>> 24);
        out[outOff++] = (byte)(v >>> 16);
        out[outOff++] = (byte)(v >>> 8);
        out[outOff] = (byte)v;
    }
}

