/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.util.log.Log;

public class Scanner {
    private static int __scannerId = 0;
    private int _scanInterval;
    private final List _listeners = Collections.synchronizedList(new ArrayList());
    private final Map _prevScan = new HashMap();
    private final Map _currentScan = new HashMap();
    private FilenameFilter _filter;
    private List<File> _scanDirs;
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private boolean _reportDirs = true;
    private Timer _timer;
    private TimerTask _task;
    private boolean _recursive = true;

    public int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
        this.schedule();
    }

    @Deprecated
    public void setScanDir(File dir) {
        this._scanDirs = new ArrayList<File>();
        this._scanDirs.add(dir);
    }

    @Deprecated
    public File getScanDir() {
        return this._scanDirs == null ? null : this._scanDirs.get(0);
    }

    public void setScanDirs(List dirs) {
        this._scanDirs = dirs;
    }

    public List getScanDirs() {
        return this._scanDirs;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        this._reportExisting = reportExisting;
    }

    public boolean getReportExistingFilesOnStartup() {
        return this._reportExisting;
    }

    public void setReportDirs(boolean dirs) {
        this._reportDirs = dirs;
    }

    public boolean getReportDirs() {
        return this._reportDirs;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            public void run() {
                Scanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer("Scanner-" + __scannerId++, true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1000L * (long)this.getScanInterval(), 1000L * (long)this.getScanInterval());
            }
        }
    }

    public synchronized void stop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public synchronized void scan() {
        this.scanFiles();
        this.reportDifferences(this._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
    }

    public synchronized void scanFiles() {
        if (this._scanDirs == null) {
            return;
        }
        this._currentScan.clear();
        for (File dir : this._scanDirs) {
            if (dir == null || !dir.exists()) continue;
            this.scanFile(dir, this._currentScan, 0);
        }
    }

    public void reportDifferences(Map currentScan, Map oldScan) {
        ArrayList<Object> bulkChanges = new ArrayList<Object>();
        HashSet oldScanKeys = new HashSet(oldScan.keySet());
        for (Map.Entry entry : currentScan.entrySet()) {
            if (!oldScanKeys.contains(entry.getKey())) {
                Log.debug("File added: " + entry.getKey());
                this.reportAddition((String)entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            if (!oldScan.get(entry.getKey()).equals(entry.getValue())) {
                Log.debug("File changed: " + entry.getKey());
                this.reportChange((String)entry.getKey());
                oldScanKeys.remove(entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            oldScanKeys.remove(entry.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            for (String filename : oldScanKeys) {
                Log.debug("File removed: " + filename);
                this.reportRemoval(filename);
                bulkChanges.add(filename);
            }
        }
        if (!bulkChanges.isEmpty()) {
            this.reportBulkChanges(bulkChanges);
        }
    }

    private void scanFile(File f, Map scanInfoMap, int depth) {
        try {
            if (!f.exists()) {
                return;
            }
            if ((f.isFile() || depth > 0 && this._reportDirs && f.isDirectory()) && (this._filter == null || this._filter != null && this._filter.accept(f.getParentFile(), f.getName()))) {
                String name = f.getCanonicalPath();
                long lastModified = f.lastModified();
                scanInfoMap.put(name, new Long(lastModified));
            }
            if (f.isDirectory() && (this._recursive || this._scanDirs.contains(f))) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.scanFile(files[i], scanInfoMap, depth + 1);
                }
            }
        }
        catch (IOException e2) {
            Log.warn("Error scanning watched files", e2);
        }
    }

    private void warn(Object listener, String filename, Throwable th) {
        Log.warn(th);
        Log.warn(listener + " failed on '" + filename);
    }

    private void reportAddition(String filename) {
        for (Object l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Exception e2) {
                this.warn(l, filename, e2);
            }
            catch (Error e3) {
                this.warn(l, filename, e3);
            }
        }
    }

    private void reportRemoval(String filename) {
        for (Object l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Exception e2) {
                this.warn(l, filename, e2);
            }
            catch (Error e3) {
                this.warn(l, filename, e3);
            }
        }
    }

    private void reportChange(String filename) {
        for (Object l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Exception e2) {
                this.warn(l, filename, e2);
            }
            catch (Error e3) {
                this.warn(l, filename, e3);
            }
        }
    }

    private void reportBulkChanges(List filenames) {
        for (Object l : this._listeners) {
            try {
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Exception e2) {
                this.warn(l, filenames.toString(), e2);
            }
            catch (Error e3) {
                this.warn(l, filenames.toString(), e3);
            }
        }
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }
}

