/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenBrowserAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    protected AbstractInfoAction(boolean installAdapters) {
        super(installAdapters);
    }

    protected AbstractInfoAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId, boolean installAdapters) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, installAdapters);
    }

    @Deprecated
    public static boolean confirmLaunchMultiple(int numBrowsers) {
        return OpenBrowserAction.confirmLaunchMultiple(numBrowsers);
    }

    protected void launchInfoBrowsersForSelectedPrimitivesAndNote() {
        ArrayList<Object> primitivesToShow = new ArrayList<Object>();
        OsmData<?, ?, ?, ?> ds = this.getLayerManager().getActiveData();
        if (ds != null) {
            primitivesToShow.addAll(ds.getAllSelected());
        }
        Note noteToShow = MainApplication.isDisplayingMapView() ? MainApplication.getMap().noteDialog.getSelectedNote() : null;
        primitivesToShow.removeIf(PrimitiveId::isNew);
        if (primitivesToShow.isEmpty() && noteToShow == null) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        int max = Math.min(10, primitivesToShow.size());
        if (primitivesToShow.size() > max && !OpenBrowserAction.confirmLaunchMultiple(primitivesToShow.size())) {
            return;
        }
        for (int i = 0; i < max; ++i) {
            this.launchInfoBrowser(primitivesToShow.get(i));
        }
        if (noteToShow != null) {
            this.launchInfoBrowser(noteToShow);
        }
    }

    protected final void launchInfoBrowser(Object o) {
        String result;
        String url = this.createInfoUrl(o);
        if (url != null && (result = OpenBrowser.displayUrl(url)) != null) {
            Logging.warn(result);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.launchInfoBrowsersForSelectedPrimitivesAndNote();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        OsmData<?, ?, ?, ?> ds = this.getLayerManager().getActiveData();
        this.setEnabled(ds != null && !ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

