/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.time.Instant;
import java.time.format.FormatStyle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class AbstractCellRenderer
extends JLabel
implements TableCellRenderer {
    protected void reset(JComponent c, boolean tableFont) {
        c.setBackground(UIManager.getColor("Table.background"));
        c.setForeground(UIManager.getColor("Table.foreground"));
        if (tableFont) {
            c.setFont(UIManager.getFont("Table.font"));
        }
        c.setToolTipText(null);
        c.setOpaque(true);
    }

    protected void reset() {
        this.reset(this, true);
    }

    protected void renderColors(JComponent c, boolean isSelected) {
        if (isSelected) {
            c.setBackground(UIManager.getColor("Table.selectionBackground"));
            c.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            c.setBackground(UIManager.getColor("Table.background"));
            c.setForeground(UIManager.getColor("Table.foreground"));
        }
    }

    protected void renderColors(boolean isSelected) {
        this.renderColors(this, isSelected);
    }

    protected void renderId(long id) {
        this.setText(Long.toString(id));
        this.setToolTipText(null);
    }

    protected void renderUser(User user) {
        if (user == null || user.getName().trim().isEmpty()) {
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
            this.setText(I18n.tr("anonymous", new Object[0]));
        } else {
            this.setFont(UIManager.getFont("Table.font"));
            this.setText(user.getName());
            this.setToolTipText(user.getName());
        }
    }

    protected void renderInstant(Instant d) {
        if (d == null) {
            this.setText("");
        } else {
            this.setText(DateUtils.getDateTimeFormatter(FormatStyle.SHORT, FormatStyle.SHORT).format(d));
        }
        this.setToolTipText(null);
    }
}

