/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.Event;
import ch.poole.openinghoursparser.Util;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class VariableTime
extends Element {
    Event event = null;
    int offset = 0;

    public VariableTime() {
    }

    public VariableTime(@NotNull VariableTime vt) {
        this.event = vt.event;
        this.offset = vt.offset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.event != null) {
            if (this.offset != 0) {
                b.append("(");
                b.append((Object)this.event);
                if (this.offset > 0) {
                    b.append("+");
                }
                b.append(String.format(Locale.US, "%02d", this.offset / 60));
                b.append(":");
                b.append(String.format(Locale.US, "%02d", Math.abs(this.offset) % 60));
                b.append(")");
            } else {
                b.append((Object)this.event);
            }
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof VariableTime) {
            VariableTime o = (VariableTime)other;
            return Util.equals((Object)this.event, (Object)o.event) && this.offset == o.offset;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 37 * result + this.offset;
        return result;
    }

    public Event getEvent() {
        return this.event;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void setEvent(String event) {
        this.event = Event.getValue(event);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public VariableTime copy() {
        return new VariableTime(this);
    }
}

