/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DeleteCurrentRelationAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    public DeleteCurrentRelationAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, new IRelationEditorUpdateOn[0]);
        this.putValue("ShortDescription", I18n.tr("Delete the currently edited relation", new Object[0]));
        new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Delete", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation toDelete = this.getEditor().getRelation();
        if (toDelete == null) {
            return;
        }
        DeleteAction.deleteRelation(this.getLayer(), toDelete);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditor().getRelationSnapshot() != null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (GenericRelationEditor.RELATION_SNAPSHOT_PROP.equals(evt.getPropertyName())) {
            this.updateEnabledState();
        }
    }
}

