/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.importexport.AllFormatsImporter;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.Options;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class OpenFileAction
extends DiskAccessAction {
    public static final ExtensionFileFilter URL_FILE_FILTER = new ExtensionFileFilter("url", "url", I18n.tr("URL Files", new Object[0]) + " (*.url)");

    public OpenFileAction() {
        super(I18n.tr("Open...", new Object[0]), "open", I18n.tr("Open a file.", new Object[0]), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...", new Object[0])), 79, 5006), true, null, false);
        this.setHelpId(HelpUtil.ht("/Action/Open"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractFileChooser fc = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        OpenFileTask task = new OpenFileTask(Arrays.asList(files), fc.getFileFilter());
        task.setOptions(Options.RECORD_HISTORY);
        MainApplication.worker.submit(task);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(true);
    }

    public static Future<?> openFiles(List<File> fileList) {
        return OpenFileAction.openFiles(fileList, null);
    }

    public static Future<?> openFiles(List<File> fileList, Options ... options) {
        OpenFileTask task = new OpenFileTask(fileList, null);
        task.setOptions(options);
        return MainApplication.worker.submit(task);
    }

    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private final List<File> files;
        private final List<File> successfullyOpenedFiles = new ArrayList<File>();
        private final Set<String> fileHistory = new LinkedHashSet<String>();
        private final Set<String> failedAll = new HashSet<String>();
        private final FileFilter fileFilter;
        private boolean canceled;
        private final EnumSet<Options> options = EnumSet.noneOf(Options.class);

        public OpenFileTask(List<File> files, FileFilter fileFilter, String title) {
            super(title, false);
            this.fileFilter = fileFilter;
            this.files = new ArrayList<File>(files.size());
            for (File file : files) {
                if (file.exists()) {
                    this.files.add(PlatformManager.getPlatform().resolveFileLink(file));
                    continue;
                }
                if (file.getParentFile() != null) {
                    File[] matchingFiles = file.getParentFile().listFiles((dir, name) -> name.startsWith(file.getName()) && fileFilter != null && fileFilter.accept(new File(dir, name)));
                    if (matchingFiles != null && matchingFiles.length == 1) {
                        this.files.add(matchingFiles[0]);
                        continue;
                    }
                    this.files.add(file);
                    continue;
                }
                String message = I18n.tr("Unable to locate file  ''{0}''.", file.getPath());
                Logging.warn(message);
                new Notification(message).show();
            }
        }

        public OpenFileTask(List<File> files, FileFilter fileFilter) {
            this(files, fileFilter, I18n.tr("Opening files", new Object[0]));
        }

        public void setOptions(Options ... options) {
            this.options.clear();
            if (options != null) {
                Stream.of(options).filter(Objects::nonNull).forEach(this.options::add);
            }
        }

        public boolean isRecordHistory() {
            return this.options.contains((Object)Options.RECORD_HISTORY);
        }

        public Set<Options> getOptions() {
            return Collections.unmodifiableSet(this.options);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            MapFrame map = MainApplication.getMap();
            if (map != null) {
                map.repaint();
            }
        }

        protected void alertFilesNotMatchingWithImporter(Collection<File> files, FileImporter importer) {
            StringBuilder msg = new StringBuilder(128).append("<html>").append(I18n.trn("Cannot open {0} file with the file importer ''{1}''.", "Cannot open {0} files with the file importer ''{1}''.", files.size(), files.size(), Utils.escapeReservedCharactersHTML(importer.filter.getDescription()))).append("<br><ul>");
            for (File f : files) {
                msg.append("<li>").append(f.getAbsolutePath()).append("</li>");
            }
            msg.append("</ul></html>");
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), msg.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Open#ImporterCantImportFiles"));
        }

        protected void alertFilesWithUnknownImporter(Collection<File> files) {
            StringBuilder msg = new StringBuilder(128).append("<html>").append(I18n.trn("Cannot open {0} file because file does not exist or no suitable file importer is available.", "Cannot open {0} files because files do not exist or no suitable file importer is available.", files.size(), files.size())).append("<br><ul>");
            for (File f : files) {
                msg.append("<li>").append(f.getAbsolutePath()).append(" (<i>").append(f.exists() ? I18n.tr("no importer", new Object[0]) : I18n.tr("does not exist", new Object[0])).append("</i>)</li>");
            }
            msg.append("</ul></html>");
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), msg.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Open#MissingImporterForFiles"));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            FileImporter chosenImporter = null;
            if (this.fileFilter != null) {
                for (FileImporter importer : ExtensionFileFilter.getImporters()) {
                    if (!this.fileFilter.equals(importer.filter)) continue;
                    chosenImporter = importer;
                }
            }
            if (chosenImporter instanceof AllFormatsImporter) {
                chosenImporter = null;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            if (chosenImporter != null) {
                LinkedList<File> filesNotMatchingWithImporter = new LinkedList<File>();
                LinkedList<File> filesMatchingWithImporter = new LinkedList<File>();
                for (File f : this.files) {
                    if (!chosenImporter.acceptFile(f)) {
                        if (f.isDirectory()) {
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Cannot open directory ''{0}''.<br>Please select a file.</html>", f.getAbsolutePath()), I18n.tr("Open file", new Object[0]), 0));
                            return;
                        }
                        filesNotMatchingWithImporter.add(f);
                        continue;
                    }
                    filesMatchingWithImporter.add(f);
                }
                if (!filesNotMatchingWithImporter.isEmpty()) {
                    this.alertFilesNotMatchingWithImporter(filesNotMatchingWithImporter, chosenImporter);
                }
                if (!filesMatchingWithImporter.isEmpty()) {
                    this.importData(chosenImporter, filesMatchingWithImporter);
                }
            } else {
                MultiMap<FileImporter, File> importerMap = new MultiMap<FileImporter, File>();
                LinkedList<File> filesWithUnknownImporter = new LinkedList<File>();
                LinkedList<File> urlFiles = new LinkedList<File>();
                block9: for (File file : this.files) {
                    for (FileImporter importer : ExtensionFileFilter.getImporters()) {
                        if (!importer.acceptFile(file)) continue;
                        importerMap.put(importer, file);
                        continue block9;
                    }
                    if (URL_FILE_FILTER.accept(file)) {
                        urlFiles.add(file);
                        continue;
                    }
                    filesWithUnknownImporter.add(file);
                }
                if (!filesWithUnknownImporter.isEmpty()) {
                    this.alertFilesWithUnknownImporter(filesWithUnknownImporter);
                }
                ArrayList importers = new ArrayList(importerMap.keySet());
                Collections.sort(importers);
                Collections.reverse(importers);
                for (FileImporter importer : importers) {
                    this.importData(importer, new ArrayList<File>(importerMap.get(importer)));
                }
                Pattern pattern = Pattern.compile(".*(https?://.*)");
                for (File urlFile : urlFiles) {
                    try {
                        BufferedReader reader = Files.newBufferedReader(urlFile.toPath(), StandardCharsets.UTF_8);
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                Matcher m = pattern.matcher(line);
                                if (!m.matches()) continue;
                                String url = m.group(1);
                                MainApplication.getMenu().openLocation.openUrl(false, url);
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (IOException | LinkageError | RuntimeException e) {
                        Logging.error(e);
                        GuiHelper.runInEDT(() -> new Notification(Utils.getRootCause(e).getMessage()).setIcon(0).show());
                    }
                }
            }
            if (this.options.contains((Object)Options.RECORD_HISTORY)) {
                List<String> oldFileHistory = Config.getPref().getList("file-open.history");
                this.fileHistory.addAll(oldFileHistory);
                this.fileHistory.removeAll(this.failedAll);
                int maxsize = Math.max(0, Config.getPref().getInt("file-open.history.max-size", 15));
                PreferencesUtils.putListBounded(Config.getPref(), "file-open.history", maxsize, new ArrayList<String>(this.fileHistory));
            }
        }

        public void importData(FileImporter importer, List<File> files) {
            importer.setOptions(this.options.toArray(new Options[0]));
            if (importer.isBatchImporter()) {
                if (this.canceled) {
                    return;
                }
                String msg = I18n.trn("Opening {0} file...", "Opening {0} files...", files.size(), files.size());
                this.getProgressMonitor().setCustomText(msg);
                this.getProgressMonitor().indeterminateSubTask(msg);
                if (importer.importDataHandleExceptions(files, this.getProgressMonitor().createSubTaskMonitor(files.size(), false))) {
                    this.successfullyOpenedFiles.addAll(files);
                }
            } else {
                for (File f : files) {
                    if (this.canceled) {
                        return;
                    }
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Opening file ''{0}'' ...", f.getAbsolutePath()));
                    if (!importer.importDataHandleExceptions(f, this.getProgressMonitor().createSubTaskMonitor(1, false))) continue;
                    this.successfullyOpenedFiles.add(f);
                }
            }
            if (this.options.contains((Object)Options.RECORD_HISTORY) && !importer.isBatchImporter()) {
                for (File f : files) {
                    try {
                        if (this.successfullyOpenedFiles.contains(f)) {
                            this.fileHistory.add(f.getCanonicalPath());
                            continue;
                        }
                        this.failedAll.add(f.getCanonicalPath());
                    }
                    catch (IOException e) {
                        Logging.warn(e);
                    }
                }
            }
        }

        public List<File> getSuccessfullyOpenedFiles() {
            return this.successfullyOpenedFiles;
        }
    }
}

