/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSCapabilities;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.gui.layer.imagery.WMTSLayerSelection;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class AddWMTSLayerPanel
extends AddImageryPanel {
    private final transient JPanel layerPanel = new JPanel(new GridBagLayout());
    private transient WMTSLayerSelection layerTable;
    private final JCheckBox setDefaultLayer = new JCheckBox(I18n.tr("Set default layer?", new Object[0]));

    public AddWMTSLayerPanel() {
        this.add((Component)new JLabel(I18n.tr("{0} Make sure OSM has the permission to use this service", "1.")), GBC.eol());
        this.add((Component)new JLabel(I18n.tr("{0} Enter GetCapabilities URL", "2.")), GBC.eol());
        this.add((Component)this.rawUrl, GBC.eop().fill(2));
        this.rawUrl.setLineWrap(true);
        this.rawUrl.setAlignmentY(0.0f);
        JButton getLayers = new JButton(I18n.tr("{0} Get layers", "3."));
        getLayers.setEnabled(this.setDefaultLayer.isSelected());
        this.setDefaultLayer.addActionListener(e -> getLayers.setEnabled(this.setDefaultLayer.isSelected()));
        this.add((Component)this.setDefaultLayer, GBC.eop());
        this.add((Component)getLayers, GBC.eop().fill(2));
        this.add((Component)new JLabel(I18n.tr("Choose default layer", new Object[0])), GBC.eol());
        this.add((Component)this.layerPanel, GBC.eol().fill());
        this.addCommonSettings();
        this.add((Component)new JLabel(I18n.tr("{0} Enter name for this layer", "4.")), GBC.eol());
        this.add((Component)this.name, GBC.eol().fill(2));
        this.registerValidableComponent(this.rawUrl);
        this.registerValidableComponent(this.setDefaultLayer);
        getLayers.addActionListener(e -> {
            try {
                WMTSCapabilities capabilities = WMTSTileSource.getCapabilities(Utils.strip(this.rawUrl.getText()), this.getCommonHeaders());
                this.layerTable = new WMTSLayerSelection(WMTSTileSource.groupLayersByNameAndTileMatrixSet(capabilities.getLayers()));
                this.layerTable.getTable().getSelectionModel().addListSelectionListener(lsl -> {
                    if (this.layerTable.getSelectedLayer() != null) {
                        this.name.setText(capabilities.getBaseUrl() + ": " + this.layerTable.getSelectedLayer().getUserTitle());
                    } else {
                        this.name.setText(capabilities.getBaseUrl() + ": ");
                    }
                });
                this.layerPanel.removeAll();
                this.layerPanel.add((Component)this.layerTable, GBC.eol().fill());
                this.layerPanel.revalidate();
            }
            catch (IOException | RuntimeException | WMTSTileSource.WMTSGetCapabilitiesException ex) {
                Logging.trace(ex);
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Error getting layers: {0}", ex.getMessage()), I18n.tr("WMTS Error", new Object[0]), 0);
            }
        });
    }

    @Override
    protected ImageryInfo getImageryInfo() {
        ImageryInfo ret = new ImageryInfo(this.getImageryName(), "wmts:" + AddWMTSLayerPanel.sanitize(this.getImageryRawUrl(), ImageryInfo.ImageryType.WMTS));
        if (this.setDefaultLayer.isSelected()) {
            if (this.layerTable == null) {
                throw new IllegalArgumentException(I18n.tr("You need to get fetch layers", new Object[0]));
            }
            WMTSTileSource.Layer selectedLayer = this.layerTable.getSelectedLayer();
            ret.setDefaultLayers(Collections.singletonList(new DefaultLayer(ImageryInfo.ImageryType.WMTS, selectedLayer.getIdentifier(), selectedLayer.getStyle(), selectedLayer.getTileMatrixSet().getIdentifier())));
        }
        ret.setCustomHttpHeaders(this.getCommonHeaders());
        ret.setGeoreferenceValid(this.getCommonIsValidGeoreference());
        ret.setImageryType(ImageryInfo.ImageryType.WMTS);
        try {
            new WMTSTileSource(ret);
        }
        catch (IOException | WMTSTileSource.WMTSGetCapabilitiesException e) {
            Logging.warn(e);
            throw new IllegalArgumentException(e);
        }
        return ret;
    }

    @Override
    protected boolean isImageryValid() {
        return (this.setDefaultLayer.isSelected() && this.layerTable != null && this.layerTable.getSelectedLayer() != null || !this.setDefaultLayer.isSelected()) && !this.getImageryName().isEmpty() && !this.getImageryRawUrl().isEmpty();
    }
}

