/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxTimezone;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.io.importexport.ImageImporter;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

class SynchronizeTimeFromPhotoDialog
extends ExtendedDialog {
    private JCheckBox ckDst;
    private ImageDisplay imgDisp;
    private JLabel lbExifTime;
    private JosmTextField tfGpsTime;
    private JosmComboBox<TimeZoneItem> cbTimezones;
    private final SimpleDateFormat dateFormat = SynchronizeTimeFromPhotoDialog.getDateTimeFormat();

    SynchronizeTimeFromPhotoDialog(Component parent, List<ImageEntry> images) {
        super(parent, I18n.tr("Synchronize time from a photo of the GPS receiver", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("ok", "cancel");
        this.setContent(this.buildContent(images));
    }

    private Component buildContent(final List<ImageEntry> images) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(I18n.tr("<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>", new Object[0])), "North");
        this.imgDisp = new ImageDisplay();
        this.imgDisp.setPreferredSize(new Dimension(300, 225));
        panel.add((Component)this.imgDisp, "Center");
        JPanel panelTf = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 21;
        panelTf.add((Component)new JLabel(I18n.tr("Photo time (from exif):", new Object[0])), gc);
        this.lbExifTime = new JLabel();
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.gridwidth = 2;
        panelTf.add((Component)this.lbExifTime, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 21;
        panelTf.add((Component)new JLabel(I18n.tr("Gps time (read from the above photo): ", new Object[0])), gc);
        this.tfGpsTime = new JosmTextField(12);
        this.tfGpsTime.setEnabled(false);
        this.tfGpsTime.setMinimumSize(new Dimension(155, this.tfGpsTime.getMinimumSize().height));
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        panelTf.add((Component)this.tfGpsTime, gc);
        gc.gridx = 2;
        gc.weightx = 0.2;
        panelTf.add((Component)new JLabel(" [" + this.dateFormat.toLocalizedPattern() + ']'), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 21;
        panelTf.add((Component)new JLabel(I18n.tr("Photo taken in the timezone of: ", new Object[0])), gc);
        this.ckDst = new JCheckBox(I18n.tr("Use daylight saving time (where applicable)", new Object[0]), Config.getPref().getBoolean("geoimage.timezoneid.dst"));
        String[] tmp = TimeZone.getAvailableIDs();
        ArrayList<TimeZoneItem> vtTimezones = new ArrayList<TimeZoneItem>(tmp.length);
        String defTzStr = Config.getPref().get("geoimage.timezoneid", "");
        if (defTzStr.isEmpty()) {
            defTzStr = TimeZone.getDefault().getID();
        }
        TimeZoneItem defTzItem = null;
        for (String tzStr : tmp) {
            TimeZoneItem tz = new TimeZoneItem(TimeZone.getTimeZone(tzStr));
            vtTimezones.add(tz);
            if (!defTzStr.equals(tzStr)) continue;
            defTzItem = tz;
        }
        Collections.sort(vtTimezones);
        this.cbTimezones = new JosmComboBox<TimeZoneItem>(vtTimezones.toArray(new TimeZoneItem[0]));
        if (defTzItem != null) {
            this.cbTimezones.setSelectedItem(defTzItem);
        }
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        gc.fill = 2;
        panelTf.add(this.cbTimezones, gc);
        gc.gridy = 3;
        panelTf.add((Component)this.ckDst, gc);
        this.ckDst.addActionListener(x -> this.cbTimezones.repaint());
        panel.add((Component)panelTf, "South");
        JPanel panelLst = new JPanel(new BorderLayout());
        JList<String> imgList = new JList<String>(new AbstractListModel<String>(){

            @Override
            public String getElementAt(int i) {
                return ((ImageEntry)images.get(i)).getDisplayName();
            }

            @Override
            public int getSize() {
                return images.size();
            }
        });
        imgList.getSelectionModel().setSelectionMode(0);
        imgList.getSelectionModel().addListSelectionListener(evt -> this.updateExifComponents((ImageEntry)images.get(imgList.getSelectedIndex())));
        panelLst.add((Component)new JScrollPane(imgList), "Center");
        JButton openButton = new JButton(I18n.tr("Open another photo", new Object[0]));
        openButton.addActionListener(ae -> {
            AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, false, null, ImageImporter.FILE_FILTER_WITH_FOLDERS, 0, "geoimage.lastdirectory");
            if (fc == null) {
                return;
            }
            ImageEntry entry = new ImageEntry(fc.getSelectedFile());
            entry.extractExif();
            this.updateExifComponents(entry);
        });
        panelLst.add((Component)openButton, "Last");
        panel.add((Component)panelLst, "Before");
        return panel;
    }

    final long getDelta() throws ParseException {
        return this.dateFormat.parse(this.lbExifTime.getText()).getTime() - this.dateFormat.parse(this.tfGpsTime.getText()).getTime();
    }

    final TimeZoneItem getTimeZoneItem() {
        return (TimeZoneItem)this.cbTimezones.getSelectedItem();
    }

    final boolean isDstSelected() {
        return this.ckDst.isSelected();
    }

    protected void updateExifComponents(ImageEntry img) {
        this.imgDisp.setImage(img);
        Instant date = img.getExifInstant();
        if (date != null) {
            SimpleDateFormat df = SynchronizeTimeFromPhotoDialog.getDateTimeFormat();
            df.setTimeZone(DateUtils.UTC);
            this.lbExifTime.setText(df.format(Date.from(date)));
            this.tfGpsTime.setText(df.format(Date.from(date)));
            this.tfGpsTime.setCaretPosition(this.tfGpsTime.getText().length());
            this.tfGpsTime.setEnabled(true);
            this.tfGpsTime.requestFocus();
        } else {
            this.lbExifTime.setText(I18n.tr("No date", new Object[0]));
            this.tfGpsTime.setText("");
            this.tfGpsTime.setEnabled(false);
        }
    }

    private static SimpleDateFormat getDateTimeFormat() {
        return (SimpleDateFormat)DateUtils.getDateTimeFormat(3, 2);
    }

    class TimeZoneItem
    implements Comparable<TimeZoneItem> {
        private final TimeZone tz;
        private String rawString;
        private String dstString;

        TimeZoneItem(TimeZone tz) {
            this.tz = tz;
        }

        public String getFormattedString() {
            if (SynchronizeTimeFromPhotoDialog.this.ckDst.isSelected()) {
                return this.getDstString();
            }
            return this.getRawString();
        }

        public String getDstString() {
            if (this.dstString == null) {
                this.dstString = this.formatTimezone(this.tz.getRawOffset() + this.tz.getDSTSavings());
            }
            return this.dstString;
        }

        public String getRawString() {
            if (this.rawString == null) {
                this.rawString = this.formatTimezone(this.tz.getRawOffset());
            }
            return this.rawString;
        }

        public String getID() {
            return this.tz.getID();
        }

        public String toString() {
            return this.getID() + " (" + this.getFormattedString() + ')';
        }

        @Override
        public int compareTo(TimeZoneItem o) {
            return this.getID().compareTo(o.getID());
        }

        private String formatTimezone(int offset) {
            return new GpxTimezone((double)offset / (double)TimeUnit.HOURS.toMillis(1L)).formatTimezone();
        }
    }
}

