/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class UidInputFieldValidator
extends AbstractTextComponentValidator {
    public UidInputFieldValidator(JTextComponent tc) {
        super(tc);
    }

    public static UidInputFieldValidator decorate(JTextComponent tc) {
        return new UidInputFieldValidator(tc);
    }

    @Override
    public boolean isValid() {
        return this.getUid() > 0;
    }

    @Override
    public void validate() {
        String value = this.getComponent().getText();
        if (Utils.isBlank(value)) {
            this.feedbackInvalid("");
            return;
        }
        try {
            int uid = Integer.parseInt(value);
            if (uid <= 0) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
                return;
            }
        }
        catch (NumberFormatException e) {
            this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
            return;
        }
        this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
    }

    public int getUid() {
        String value = this.getComponent().getText();
        if (Utils.isBlank(value)) {
            return 0;
        }
        try {
            int uid = Integer.parseInt(value.trim());
            if (uid > 0) {
                return uid;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

