/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class PluginListParser {
    public static PluginInformation createInfo(String name, String url, Attributes manifest) throws PluginListParseException {
        try {
            return new PluginInformation(manifest, name.substring(0, name.length() - 4), url);
        }
        catch (PluginException e) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", name), e);
        }
    }

    public List<PluginInformation> parse(InputStream in) throws PluginListParseException {
        LinkedList<PluginInformation> linkedList;
        LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            String name = null;
            String url = null;
            Attributes manifest = new Attributes();
            String line = r.readLine();
            while (line != null) {
                if (line.startsWith("\t")) {
                    String[] keyValue = line.split("\\s*:\\s*", 2);
                    manifest.put(new Attributes.Name(keyValue[0].substring(1)), keyValue[1]);
                } else {
                    PluginListParser.addPluginInformation(ret, name, url, manifest);
                    String[] x = line.split(";", -1);
                    if (x.length != 2) {
                        throw new IOException(I18n.tr("Illegal entry in plugin list.", new Object[0]) + " " + line);
                    }
                    name = x[0];
                    url = x[1];
                    manifest = new Attributes();
                }
                line = r.readLine();
            }
            PluginListParser.addPluginInformation(ret, name, url, manifest);
            linkedList = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PluginListParseException(e);
            }
        }
        r.close();
        return linkedList;
    }

    private static void addPluginInformation(List<PluginInformation> ret, String name, String url, Attributes manifest) {
        try {
            if (name != null) {
                PluginInformation info = PluginListParser.createInfo(name, url, manifest);
                for (PluginProxy plugin : PluginHandler.pluginList) {
                    if (!plugin.getPluginInformation().name.equals(info.getName())) continue;
                    info.localversion = plugin.getPluginInformation().localversion;
                }
                ret.add(info);
            }
        }
        catch (PluginListParseException ex) {
            Logging.error(ex);
        }
    }
}

