/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.Line;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ColorScale;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.Interval;

public class GpxDrawHelper
implements SystemOfMeasurement.SoMChangeListener,
MapViewPaintable.LayerPainter,
MapViewPaintable.PaintableInvalidationListener,
GpxData.GpxDataChangeListener {
    public static final NamedColorProperty DEFAULT_COLOR_PROPERTY = new NamedColorProperty(I18n.marktr("gps point"), Color.magenta);
    private final GpxData data;
    private final GpxLayer layer;
    private boolean forceLines;
    private boolean alphaLines;
    private boolean arrows;
    private int lineWidth;
    private int maxLineLength;
    private boolean lines;
    private boolean large;
    private int largesize;
    private boolean hdopCircle;
    private boolean arrowsFast;
    private int arrowsDelta;
    private double minTrackDurationForTimeColoring;
    private int hdoprange;
    private static final double PHI = Utils.toRadians(15.0);
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private boolean computeCacheColorDynamic;
    private ColorMode computeCacheColored;
    private int computeCacheVelocityTune;
    private int computeCacheHeatMapDrawColorTableIdx;
    private boolean computeCacheHeatMapDrawPointMode;
    private int computeCacheHeatMapDrawGain;
    private int computeCacheHeatMapDrawLowerLimit;
    private Color colorCache;
    private Color colorCacheTransparent;
    private ColorMode colored;
    private int velocityTune;
    private boolean colorModeDynamic;
    private Color neutralColor;
    private int largePointAlpha;
    private ColorScale velocityScale;
    private ColorScale hdopScale;
    private ColorScale qualityScale;
    private ColorScale dateScale;
    private ColorScale directionScale;
    private int hdopAlpha;
    private static final int ll0 = 9;
    private static final int sl4 = 5;
    private static final int sl9 = 3;
    private static final int[][] dir = new int[][]{{5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}, {-5, -9, -9, -5}, {3, -9, -3, -9}, {9, -5, 5, -9}, {9, 3, 9, -3}};
    private boolean heatMapDrawExtraLine;
    private int heatMapDrawColorTableIdx;
    private boolean heatMapDrawPointMode;
    private int heatMapDrawGain;
    private int heatMapDrawLowerLimit;
    private BufferedImage heatMapImgGray;
    private Graphics2D heatMapGraph2d;
    Rectangle heatMapCacheScreenBounds = new Rectangle();
    MapViewState heatMapMapViewState;
    int heatMapCacheLineWith;
    private final List<Integer> heatMapPolyX = new ArrayList<Integer>();
    private final List<Integer> heatMapPolyY = new ArrayList<Integer>();
    private static final Color[] heatMapLutColorJosmInferno = GpxDrawHelper.createColorFromResource("inferno");
    private static final Color[] heatMapLutColorJosmViridis = GpxDrawHelper.createColorFromResource("viridis");
    private static final Color[] heatMapLutColorJosmBrown2Green = GpxDrawHelper.createColorFromResource("brown2green");
    private static final Color[] heatMapLutColorJosmRed2Blue = GpxDrawHelper.createColorFromResource("red2blue");
    private static final Color[] rtkLibQualityColors = new Color[]{Color.GREEN, Color.ORANGE, Color.PINK, Color.BLUE, Color.RED, Color.CYAN};
    private Color[] heatMapLutColor = GpxDrawHelper.createColorLut(0, Color.BLACK, Color.WHITE);
    private boolean gpxLayerInvalidated;

    private void setupColors() {
        this.hdopAlpha = Config.getPref().getInt("hdop.color.alpha", -1);
        this.velocityScale = ColorScale.createHSBScale(256);
        this.hdopScale = ColorScale.createHSBScale(256).makeReversed().addTitle(I18n.tr("HDOP", new Object[0]));
        this.qualityScale = ColorScale.createFixedScale(rtkLibQualityColors).addTitle(I18n.tr("Quality", new Object[0]));
        this.dateScale = ColorScale.createHSBScale(256).addTitle(I18n.tr("Time", new Object[0]));
        this.directionScale = ColorScale.createCyclicScale(256).setIntervalCount(4).addTitle(I18n.tr("Direction", new Object[0]));
        this.systemOfMeasurementChanged(null, null);
    }

    @Override
    public void systemOfMeasurementChanged(String oldSoM, String newSoM) {
        SystemOfMeasurement som = SystemOfMeasurement.getSystemOfMeasurement();
        this.velocityScale.addTitle(I18n.tr("Velocity, {0}", som.speedName));
        this.layer.invalidate();
    }

    public GpxDrawHelper(GpxLayer gpxLayer) {
        this.layer = gpxLayer;
        this.data = gpxLayer.data;
        this.data.addChangeListener(this);
        this.layer.addInvalidationListener(this);
        SystemOfMeasurement.addSoMChangeListener(this);
        this.setupColors();
    }

    public ColorMode getColorMode() {
        try {
            int i = this.optInt("colormode");
            if (i == -1) {
                i = 0;
            }
            return ColorMode.fromIndex(i);
        }
        catch (IndexOutOfBoundsException e) {
            Logging.warn(e);
            return ColorMode.NONE;
        }
    }

    private String opt(String key) {
        return GPXSettingsPanel.getLayerPref(this.layer, key);
    }

    private boolean optBool(String key) {
        return Boolean.parseBoolean(this.opt(key));
    }

    private int optInt(String key) {
        return GPXSettingsPanel.getLayerPrefInt(this.layer, key);
    }

    public void readPreferences() {
        this.forceLines = this.optBool("lines.force");
        this.arrows = this.optBool("lines.arrows");
        this.arrowsFast = this.optBool("lines.arrows.fast");
        this.arrowsDelta = this.optInt("lines.arrows.min-distance");
        this.lineWidth = this.optInt("lines.width");
        this.alphaLines = this.optBool("lines.alpha-blend");
        int l = this.optInt("lines");
        if (!this.data.fromServer) {
            this.maxLineLength = this.optInt("lines.max-length.local");
            this.lines = l != 0;
        } else {
            this.maxLineLength = this.optInt("lines.max-length");
            this.lines = l != 0 && l != 1;
        }
        this.large = this.optBool("points.large");
        this.largesize = this.optInt("points.large.size");
        this.hdopCircle = this.optBool("points.hdopcircle");
        this.colored = this.getColorMode();
        this.velocityTune = this.optInt("colormode.velocity.tune");
        this.colorModeDynamic = this.optBool("colormode.dynamic-range");
        this.hdoprange = Config.getPref().getInt("hdop.range", 7);
        this.minTrackDurationForTimeColoring = this.optInt("colormode.time.min-distance");
        this.largePointAlpha = this.optInt("points.large.alpha") & 0xFF;
        this.heatMapDrawExtraLine = this.optBool("colormode.heatmap.line-extra");
        this.heatMapDrawColorTableIdx = this.optInt("colormode.heatmap.colormap");
        this.heatMapDrawPointMode = this.optBool("colormode.heatmap.use-points");
        this.heatMapDrawGain = this.optInt("colormode.heatmap.gain");
        this.heatMapDrawLowerLimit = this.optInt("colormode.heatmap.lower-limit");
        this.heatMapDrawGain = Utils.clamp(this.heatMapDrawGain, -10, 10);
        this.neutralColor = DEFAULT_COLOR_PROPERTY.get();
        this.velocityScale.setNoDataColor(this.neutralColor);
        this.dateScale.setNoDataColor(this.neutralColor);
        this.hdopScale.setNoDataColor(this.neutralColor);
        this.qualityScale.setNoDataColor(this.neutralColor);
        this.directionScale.setNoDataColor(this.neutralColor);
        this.largesize += this.lineWidth;
    }

    @Override
    public void paint(MapViewGraphics graphics) {
        Bounds clipBounds = graphics.getClipBounds().getLatLonBoundsBox();
        List<WayPoint> visibleSegments = this.listVisibleSegments(clipBounds);
        if (!visibleSegments.isEmpty()) {
            this.readPreferences();
            this.drawAll(graphics.getDefaultGraphics(), graphics.getMapView(), visibleSegments, clipBounds);
            if (graphics.getMapView().getLayerManager().getActiveLayer() == this.layer) {
                this.drawColorBar(graphics.getDefaultGraphics(), graphics.getMapView());
            }
        }
    }

    private List<WayPoint> listVisibleSegments(Bounds box) {
        WayPoint last = null;
        LinkedList<WayPoint> visibleSegments = new LinkedList<WayPoint>();
        this.ensureTrackVisibilityLength();
        for (Line segment : this.getLinesIterable(this.layer.trackVisibility)) {
            for (WayPoint pt : segment) {
                Bounds b = new Bounds(pt.getCoor());
                if (pt.drawLine && last != null) {
                    b.extend(last.getCoor());
                }
                if (b.intersects(box)) {
                    if (last != null && (visibleSegments.isEmpty() || visibleSegments.getLast() != last)) {
                        if (last.drawLine) {
                            WayPoint l = new WayPoint(last);
                            l.drawLine = false;
                            visibleSegments.add(l);
                        } else {
                            visibleSegments.add(last);
                        }
                    }
                    visibleSegments.add(pt);
                }
                last = pt;
            }
        }
        return visibleSegments;
    }

    protected Iterable<Line> getLinesIterable(boolean[] trackVisibility) {
        return this.data.getLinesIterable(trackVisibility);
    }

    private void ensureTrackVisibilityLength() {
        int l = this.data.getTracks().size();
        if (l == this.layer.trackVisibility.length) {
            return;
        }
        int m = Math.min(l, this.layer.trackVisibility.length);
        this.layer.trackVisibility = Arrays.copyOf(this.layer.trackVisibility, l);
        for (int i = m; i < l; ++i) {
            this.layer.trackVisibility[i] = true;
        }
    }

    public void drawAll(Graphics2D g, MapView mv, List<WayPoint> visibleSegments, Bounds clipBounds) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.checkCache();
        if (!this.computeCacheInSync) {
            this.calculateColors();
            visibleSegments.clear();
            visibleSegments.addAll(this.listVisibleSegments(clipBounds));
        }
        this.fixColors(visibleSegments);
        Composite oldComposite = g.getComposite();
        Stroke oldStroke = g.getStroke();
        Paint oldPaint = g.getPaint();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Config.getPref().getBoolean("mappaint.gpx.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.lineWidth > 0) {
            g.setStroke(new BasicStroke(this.lineWidth, 1, 1));
        }
        boolean useHeatMap = ColorMode.HEATMAP == this.colored;
        float layerAlpha = 1.0f;
        if (oldComposite instanceof AlphaComposite) {
            layerAlpha = ((AlphaComposite)oldComposite).getAlpha();
        }
        if (useHeatMap) {
            this.drawHeatMap(g, mv, visibleSegments);
        } else if (!this.alphaLines) {
            this.drawLines(g, mv, visibleSegments);
        } else {
            this.drawLinesAlpha(g, mv, visibleSegments, layerAlpha);
        }
        if (this.alphaLines || useHeatMap) {
            g.setComposite(AlphaComposite.SrcOver.derive(0.25f * layerAlpha));
        }
        this.drawArrows(g, mv, visibleSegments);
        this.drawPoints(g, mv, visibleSegments);
        g.setPaint(oldPaint);
        g.setStroke(oldStroke);
        g.setComposite(oldComposite);
        if (Logging.isDebugEnabled() && !visibleSegments.isEmpty()) {
            Logging.debug(stopwatch.toString("gpxdraw::draw") + "(segments= " + visibleSegments.size() + ", per 10000 = " + Utils.getDurationString(10000L * stopwatch.elapsed() / (long)visibleSegments.size()) + ")");
        }
    }

    public void calculateColors() {
        double minval = 1.0E10;
        double maxval = -1.0E10;
        WayPoint oldWp = null;
        if (this.colorModeDynamic) {
            if (this.colored == ColorMode.VELOCITY) {
                ArrayList velocities = new ArrayList();
                for (Line line : this.getLinesIterable(null)) {
                    if (!this.forceLines) {
                        oldWp = null;
                    }
                    for (WayPoint trkPnt : line) {
                        if (!trkPnt.isLatLonKnown()) continue;
                        if (oldWp != null && trkPnt.getTimeInMillis() > oldWp.getTimeInMillis()) {
                            double vel = trkPnt.getCoor().greatCircleDistance(oldWp.getCoor()) / (trkPnt.getTime() - oldWp.getTime());
                            velocities.add(vel);
                        }
                        oldWp = trkPnt;
                    }
                }
                Collections.sort(velocities);
                if (velocities.isEmpty()) {
                    this.velocityScale.setRange(0.0, 33.333333333333336);
                } else {
                    minval = (Double)velocities.get(velocities.size() / 20);
                    maxval = (Double)velocities.get(velocities.size() * 19 / 20);
                    this.velocityScale.setRange(minval, maxval);
                }
            } else if (this.colored == ColorMode.HDOP) {
                for (Line segment : this.getLinesIterable(null)) {
                    for (WayPoint trkPnt : segment) {
                        Object val = trkPnt.get("hdop");
                        if (val == null) continue;
                        double hdop = ((Float)val).doubleValue();
                        if (hdop > maxval) {
                            maxval = hdop;
                        }
                        if (!(hdop < minval)) continue;
                        minval = hdop;
                    }
                }
                if (minval >= maxval) {
                    this.hdopScale.setRange(0.0, 100.0);
                } else {
                    this.hdopScale.setRange(minval, maxval);
                }
            }
            oldWp = null;
        } else {
            this.velocityScale.setRange(0.0, this.velocityTune);
            this.hdopScale.setRange(0.0, this.hdoprange);
            this.qualityScale.setRange(1.0, rtkLibQualityColors.length);
        }
        double now = (double)System.currentTimeMillis() / 1000.0;
        if (this.colored == ColorMode.TIME) {
            Interval interval = this.data.getMinMaxTimeForAllTracks().orElse(new Interval(Instant.EPOCH, Instant.now()));
            minval = interval.getStart().getEpochSecond();
            maxval = interval.getEnd().getEpochSecond();
            this.dateScale.setRange(minval, maxval);
        }
        for (Line segment : this.getLinesIterable(null)) {
            if (!this.forceLines) {
                oldWp = null;
            }
            for (WayPoint trkPnt : segment) {
                LatLon c = trkPnt.getCoor();
                trkPnt.customColoring = segment.getColor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                Color color = null;
                if (this.colored == ColorMode.HDOP) {
                    color = this.hdopScale.getColor((Float)trkPnt.get("hdop"));
                } else if (this.colored == ColorMode.QUALITY) {
                    color = this.qualityScale.getColor((Integer)trkPnt.get("Q"));
                }
                if (oldWp != null) {
                    double dist = c.greatCircleDistance(oldWp.getCoor());
                    boolean noDraw = false;
                    switch (this.colored) {
                        case VELOCITY: {
                            double dtime = trkPnt.getTime() - oldWp.getTime();
                            if (dtime > 0.0) {
                                color = this.velocityScale.getColor(dist / dtime);
                                break;
                            }
                            color = this.velocityScale.getNoDataColor();
                            break;
                        }
                        case DIRECTION: {
                            double dirColor = oldWp.getCoor().bearing(trkPnt.getCoor());
                            color = this.directionScale.getColor(dirColor);
                            break;
                        }
                        case TIME: {
                            double t = trkPnt.getTime();
                            if (t > 0.0 && t <= now && maxval - minval > this.minTrackDurationForTimeColoring) {
                                color = this.dateScale.getColor(t);
                                break;
                            }
                            color = this.dateScale.getNoDataColor();
                            break;
                        }
                    }
                    if (!(noDraw || segment.isUnordered() && this.data.fromServer || this.maxLineLength != -1 && !(dist <= (double)this.maxLineLength))) {
                        trkPnt.drawLine = true;
                        double bearing = oldWp.getCoor().bearing(trkPnt.getCoor());
                        trkPnt.dir = (int)(bearing / Math.PI * 4.0 + 1.5) % 8;
                    } else {
                        trkPnt.drawLine = false;
                    }
                } else {
                    trkPnt.drawLine = false;
                    color = segment.getColor();
                }
                if (color != null) {
                    trkPnt.customColoring = color;
                }
                oldWp = trkPnt;
            }
        }
        if (ColorMode.HEATMAP == this.colored) {
            this.heatMapLutColor = GpxDrawHelper.createColorLut(this.heatMapDrawLowerLimit, GpxDrawHelper.selectColorMap(this.neutralColor != null ? this.neutralColor : Color.WHITE, this.heatMapDrawColorTableIdx));
            this.heatMapMapViewState = null;
        }
        this.computeCacheInSync = true;
    }

    private void drawLines(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        if (this.lines) {
            Point old = null;
            for (WayPoint trkPnt : visibleSegments) {
                if (!trkPnt.isLatLonKnown()) {
                    old = null;
                    continue;
                }
                Point screen = mv.getPoint(trkPnt);
                if (trkPnt.drawLine && old != null && (old.x != screen.x || old.y != screen.y)) {
                    g.setColor(trkPnt.customColoring);
                    g.drawLine(old.x, old.y, screen.x, screen.y);
                }
                old = screen;
            }
        }
    }

    private void drawArrows(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        Point oldA;
        Point old;
        if (this.lines && this.arrows && !this.arrowsFast) {
            old = null;
            oldA = null;
            for (WayPoint trkPnt : visibleSegments) {
                if (!trkPnt.isLatLonKnown()) {
                    old = null;
                    continue;
                }
                if (!trkPnt.drawLine) continue;
                Point screen = mv.getPoint(trkPnt);
                if (old != null && (oldA == null || screen.x < oldA.x - this.arrowsDelta || screen.x > oldA.x + this.arrowsDelta || screen.y < oldA.y - this.arrowsDelta || screen.y > oldA.y + this.arrowsDelta)) {
                    g.setColor(trkPnt.customColoring);
                    double t = Math.atan2((double)screen.y - (double)old.y, (double)screen.x - (double)old.x) + Math.PI;
                    g.drawLine(screen.x, screen.y, (int)((double)screen.x + 10.0 * Math.cos(t - PHI)), (int)((double)screen.y + 10.0 * Math.sin(t - PHI)));
                    g.drawLine(screen.x, screen.y, (int)((double)screen.x + 10.0 * Math.cos(t + PHI)), (int)((double)screen.y + 10.0 * Math.sin(t + PHI)));
                    oldA = screen;
                }
                old = screen;
            }
        }
        if (this.lines && this.arrows && this.arrowsFast) {
            old = null;
            oldA = null;
            for (WayPoint trkPnt : visibleSegments) {
                LatLon c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || !trkPnt.drawLine) continue;
                Point screen = mv.getPoint(trkPnt);
                if (old != null && (oldA == null || screen.x < oldA.x - this.arrowsDelta || screen.x > oldA.x + this.arrowsDelta || screen.y < oldA.y - this.arrowsDelta || screen.y > oldA.y + this.arrowsDelta)) {
                    g.setColor(trkPnt.customColoring);
                    g.drawLine(screen.x, screen.y, screen.x + dir[trkPnt.dir][0], screen.y + dir[trkPnt.dir][1]);
                    g.drawLine(screen.x, screen.y, screen.x + dir[trkPnt.dir][2], screen.y + dir[trkPnt.dir][3]);
                    oldA = screen;
                }
                old = screen;
            }
        }
    }

    private void drawPoints(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        Point screen;
        LatLon c;
        if (this.large || this.hdopCircle) {
            int halfSize = this.largesize / 2;
            for (WayPoint trkPnt : visibleSegments) {
                LatLon c2 = trkPnt.getCoor();
                if (Double.isNaN(c2.lat()) || Double.isNaN(c2.lon())) continue;
                Point screen2 = mv.getPoint(trkPnt);
                if (this.hdopCircle && trkPnt.get("hdop") != null) {
                    float hdop = ((Float)trkPnt.get("hdop")).floatValue();
                    if (hdop < 0.0f) {
                        hdop = 0.0f;
                    }
                    Color customColoringTransparent = this.hdopAlpha < 0 ? trkPnt.customColoring : new Color(trkPnt.customColoring.getRGB() & 0xFFFFFF | this.hdopAlpha << 24, true);
                    g.setColor(customColoringTransparent);
                    int hdopp = mv.getPoint((LatLon)new LatLon((double)trkPnt.getCoor().lat(), (double)(trkPnt.getCoor().lon() + 12.0 * (double)hdop * 360.0 / 4.0E7))).x - screen2.x;
                    g.drawArc(screen2.x - hdopp / 2, screen2.y - hdopp / 2, hdopp, hdopp, 0, 360);
                }
                if (!this.large) continue;
                if (trkPnt.customColoring != null) {
                    if (trkPnt.customColoring.equals(this.colorCache) && this.colorCacheTransparent != null) {
                        g.setColor(this.colorCacheTransparent);
                    } else {
                        Color customColoringTransparent = this.largePointAlpha < 0 ? trkPnt.customColoring : new Color(trkPnt.customColoring.getRGB() & 0xFFFFFF | this.largePointAlpha << 24, true);
                        g.setColor(customColoringTransparent);
                        this.colorCache = trkPnt.customColoring;
                        this.colorCacheTransparent = customColoringTransparent;
                    }
                }
                g.fillRect(screen2.x - halfSize, screen2.y - halfSize, this.largesize, this.largesize);
            }
        }
        if (!this.large && this.lines) {
            g.setColor(this.neutralColor);
            for (WayPoint trkPnt : visibleSegments) {
                c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || trkPnt.drawLine) continue;
                g.setColor(trkPnt.customColoring);
                screen = mv.getPoint(trkPnt);
                g.drawRect(screen.x, screen.y, 0, 0);
            }
        }
        if (!this.large && !this.lines) {
            g.setColor(this.neutralColor);
            for (WayPoint trkPnt : visibleSegments) {
                c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                screen = mv.getPoint(trkPnt);
                g.setColor(trkPnt.customColoring);
                g.drawRect(screen.x, screen.y, 0, 0);
            }
        }
    }

    private void drawLinesAlpha(Graphics2D g, MapView mv, List<WayPoint> visibleSegments, float layerAlpha) {
        Composite oldComposite = g.getComposite();
        Stroke oldStroke = g.getStroke();
        Paint oldPaint = g.getPaint();
        int globalLineWidth = Utils.clamp(this.lineWidth, 1, 20);
        double zoomScale = mv.getDist100Pixel() / 50.0;
        float theLineAlpha = (float)Utils.clamp(0.5 / zoomScale / (double)(globalLineWidth + 1), 0.01, 0.5) * layerAlpha;
        int theLineWith = (int)((double)this.lineWidth / zoomScale) + 1;
        g.setStroke(new BasicStroke(theLineWith, 1, 1));
        g.setComposite(AlphaComposite.SrcOver.derive(theLineAlpha));
        Point lastPaintPnt = null;
        for (WayPoint trkPnt : visibleSegments) {
            Point paintPnt = mv.getPoint(trkPnt);
            if (lastPaintPnt != null && trkPnt.drawLine && !lastPaintPnt.equals(paintPnt)) {
                g.setColor(trkPnt.customColoring);
                g.drawLine(lastPaintPnt.x, lastPaintPnt.y, paintPnt.x, paintPnt.y);
            }
            lastPaintPnt = paintPnt;
        }
        g.setPaint(oldPaint);
        g.setStroke(oldStroke);
        g.setComposite(oldComposite);
    }

    protected static BufferedImage createImageGradientMap(int width, int height, Color ... colors) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g = img.createGraphics();
        float[] fract = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            fract[i] = (float)i * (1.0f / (float)colors.length);
        }
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, width, height, fract, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g.setPaint(gradient);
        g.fillRect(0, 0, width, height);
        g.dispose();
        return img;
    }

    protected static Color[] createColorLut(int lowerLimit, Color ... colors) {
        int tableSize = 256;
        Raster imgRaster = GpxDrawHelper.createImageGradientMap(256, 1, colors).getData();
        int[] pixel = new int[1];
        Color[] colorTable = new Color[256];
        double mapTo90Deg = 0.006159985595274104;
        for (int i = 0; i < 256; ++i) {
            imgRaster.getDataElements(i, 0, pixel);
            Color c = new Color(pixel[0]);
            int alpha = i > lowerLimit ? (int)(Math.sin((double)(i - lowerLimit) * 0.006159985595274104) * 255.0) : 0;
            int n = alpha = alpha > 0 ? 20 + alpha : 0;
            if (alpha > 255) {
                alpha = 255;
            }
            if (i > 240 && 255 == alpha) {
                alpha -= i - 240;
            }
            colorTable[i] = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return colorTable;
    }

    protected static Color darkerColor(Color in, float adjust) {
        float r = (float)in.getRed() / 255.0f;
        float g = (float)in.getGreen() / 255.0f;
        float b = (float)in.getBlue() / 255.0f;
        return new Color(r * adjust, g * adjust, b * adjust);
    }

    protected static Color[] createColorFromResource(String str) {
        String colorFile = "resource://data/gpx/" + str + ".txt";
        ArrayList<Color> colorList = new ArrayList<Color>();
        try (CachedFile cf = new CachedFile(colorFile);
             BufferedReader br = cf.getContentReader();){
            String line;
            while ((line = br.readLine()) != null) {
                String[] column = line.split(",", -1);
                if (column.length < 3 || column[0].startsWith("#")) continue;
                float r = Float.parseFloat(column[0]);
                float g = Float.parseFloat(column[1]);
                float b = Float.parseFloat(column[2]);
                float scale = r < 1.0f && g < 1.0f && b < 1.0f ? 1.0f : 255.0f;
                colorList.add(new Color(r / scale, g / scale, b / scale));
            }
        }
        catch (IOException e) {
            throw new JosmRuntimeException(e);
        }
        if (colorList.isEmpty()) {
            colorList.add(Color.BLACK);
            colorList.add(Color.WHITE);
        } else {
            Color lastColor = (Color)colorList.get(colorList.size() - 1);
            colorList.add(GpxDrawHelper.darkerColor(lastColor, 0.975f));
            colorList.add(GpxDrawHelper.darkerColor(lastColor, 0.95f));
        }
        return GpxDrawHelper.createColorLut(0, colorList.toArray(new Color[0]));
    }

    protected static Color[] selectColorMap(Color userColor, int tableIdx) {
        Color[] userColor1 = GpxDrawHelper.createColorLut(0, userColor.darker(), userColor, userColor.brighter(), Color.WHITE);
        Color[] userColor2 = GpxDrawHelper.createColorLut(0, Color.WHITE, Color.WHITE, userColor);
        Color[] colorTrafficLights = GpxDrawHelper.createColorLut(0, Color.WHITE, Color.GREEN.darker(), Color.YELLOW, Color.RED);
        Color[][] lut = new Color[][]{userColor1, userColor2, colorTrafficLights, heatMapLutColorJosmInferno, heatMapLutColorJosmViridis, heatMapLutColorJosmBrown2Green, heatMapLutColorJosmRed2Blue};
        Color[] nextUserColor = userColor1;
        if (tableIdx >= 0 && tableIdx < lut.length) {
            nextUserColor = lut[tableIdx];
        }
        return nextUserColor;
    }

    public static ImageIcon getColorMapImageIcon(Color userColor, int tableIdx, int size) {
        return new ImageIcon(GpxDrawHelper.createImageGradientMap(size, size, GpxDrawHelper.selectColorMap(userColor, tableIdx)));
    }

    private void drawHeatGrayLineMap(Graphics2D gB, MapView mv, List<WayPoint> listSegm, Composite foreComp, Stroke foreStroke, Composite backComp, Stroke backStroke) {
        boolean drawForeground = foreComp != null && foreStroke != null;
        gB.setStroke(backStroke);
        gB.setComposite(backComp);
        WayPoint lastPnt = !listSegm.isEmpty() ? listSegm.get(listSegm.size() - 1) : null;
        for (WayPoint trkPnt : listSegm) {
            Point paintPnt = mv.getPoint(trkPnt);
            if (!trkPnt.drawLine || lastPnt == trkPnt) {
                int[] polyXArr = this.heatMapPolyX.stream().mapToInt(Integer::intValue).toArray();
                int[] polyYArr = this.heatMapPolyY.stream().mapToInt(Integer::intValue).toArray();
                gB.drawPolyline(polyXArr, polyYArr, polyXArr.length);
                if (drawForeground && this.heatMapDrawExtraLine) {
                    gB.setStroke(foreStroke);
                    gB.setComposite(foreComp);
                    gB.drawPolyline(polyXArr, polyYArr, polyXArr.length);
                    gB.setStroke(backStroke);
                    gB.setComposite(backComp);
                }
                this.heatMapPolyX.clear();
                this.heatMapPolyY.clear();
            }
            this.heatMapPolyX.add((int)paintPnt.getX());
            this.heatMapPolyY.add((int)paintPnt.getY());
        }
    }

    private void drawHeatMapGrayMap(Graphics2D g, BufferedImage imgGray, int sampleRaster, int outlineWidth) {
        int[] imgPixels = ((DataBufferInt)imgGray.getRaster().getDataBuffer()).getData();
        int offX = Math.max(1, sampleRaster);
        int offY = Math.max(1, sampleRaster);
        int maxPixelX = imgGray.getWidth();
        int maxPixelY = imgGray.getHeight();
        boolean drawOutlines = outlineWidth > 0 && (0 == sampleRaster || sampleRaster > 10);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(outlineWidth));
        int lastPixelX = 0;
        int lastPixelColor = 0;
        for (int y = 0; y < maxPixelY; y += offY) {
            int lastLineOffset = maxPixelX * (y + 0);
            int nextLineOffset = maxPixelX * (y + 1);
            for (int x = 0; x < maxPixelX; x += offX) {
                boolean bDrawIt;
                int thePixelColor = 0;
                int thePixelCount = 0;
                int offset = lastLineOffset + x;
                for (int k = 0; k < offX && offset + k < nextLineOffset; ++k) {
                    thePixelColor += imgPixels[offset + k] & 0xFF;
                    ++thePixelCount;
                }
                int n = thePixelColor = thePixelCount > 0 ? thePixelColor / thePixelCount : 0;
                if (0 == x) {
                    lastPixelX = 0;
                    lastPixelColor = thePixelColor - 1;
                }
                bDrawIt = (bDrawIt = false) || lastPixelColor == 0 || thePixelColor == 0;
                bDrawIt = bDrawIt || Math.abs(lastPixelColor - thePixelColor) > 0;
                boolean bl = bDrawIt = bDrawIt || y >= maxPixelY - offY;
                if (!bDrawIt) continue;
                if (lastPixelColor > 0) {
                    g.setColor(this.heatMapLutColor[lastPixelColor]);
                    if (drawOutlines) {
                        g.drawRect(lastPixelX, y, offX + x - lastPixelX, offY);
                    } else {
                        g.fillRect(lastPixelX, y, offX + x - lastPixelX, offY);
                    }
                }
                lastPixelX = x;
                lastPixelColor = thePixelColor;
            }
        }
        g.setStroke(oldStroke);
    }

    private void drawHeatMap(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        boolean imageRecalc;
        int lineWidthB;
        boolean imageSetup;
        Rectangle screenBounds = new Rectangle(mv.getWidth(), mv.getHeight());
        MapViewState mapViewState = mv.getState();
        double zoomScale = mv.getDist100Pixel() / 50.0;
        int globalLineWidth = 0 == this.lineWidth ? 1 : Utils.clamp(this.lineWidth, 1, 20);
        boolean bl = imageSetup = null == this.heatMapImgGray || !this.heatMapCacheScreenBounds.equals(screenBounds);
        if (imageSetup) {
            this.heatMapImgGray = new BufferedImage(screenBounds.width, screenBounds.height, 2);
            this.heatMapGraph2d = this.heatMapImgGray.createGraphics();
            this.heatMapGraph2d.setBackground(new Color(0, 0, 0, 255));
            this.heatMapGraph2d.setColor(Color.WHITE);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.heatMapCacheScreenBounds = screenBounds;
        }
        int lineWidthF = (lineWidthB = (int)Math.max(1.5 * ((double)globalLineWidth / zoomScale) + 1.0, 2.0)) > 2 ? globalLineWidth - 1 : 0;
        float lineAlpha = (float)Utils.clamp(0.4 / zoomScale / (double)(globalLineWidth + 1), 0.01, 0.4);
        float scaleAlpha = 1.0f + (float)this.heatMapDrawGain / 10.0f * 0.85f;
        float lineAlphaBPoint = (float)Utils.clamp((double)lineAlpha * 0.65 * (double)scaleAlpha, 0.001, 0.9);
        float lineAlphaBLine = (float)Utils.clamp((double)lineAlpha * 1.0 * (double)scaleAlpha, 0.001, 0.9);
        float lineAlphaFLine = (float)Utils.clamp((double)lineAlpha / 1.5 * (double)scaleAlpha, 0.001, 0.9);
        boolean bl2 = imageRecalc = !mapViewState.equalsInWindow(this.heatMapMapViewState) || this.gpxLayerInvalidated || this.heatMapCacheLineWith != globalLineWidth;
        if (imageSetup || imageRecalc) {
            this.heatMapGraph2d.clearRect(0, 0, this.heatMapImgGray.getWidth(), this.heatMapImgGray.getHeight());
            if (this.heatMapDrawPointMode) {
                this.heatMapGraph2d.setComposite(AlphaComposite.SrcOver.derive(lineAlphaBPoint));
                GpxDrawHelper.drawHeatGrayDotMap(this.heatMapGraph2d, mv, visibleSegments, lineWidthB);
            } else {
                this.drawHeatGrayLineMap(this.heatMapGraph2d, mv, visibleSegments, lineWidthF > 1 ? AlphaComposite.SrcOver.derive(lineAlphaFLine) : null, new BasicStroke(lineWidthF, 1, 1), AlphaComposite.SrcOver.derive(lineAlphaBLine), new BasicStroke(lineWidthB, 1, 1));
            }
            this.heatMapMapViewState = mapViewState;
            this.heatMapCacheLineWith = globalLineWidth;
            this.gpxLayerInvalidated = false;
        }
        this.drawHeatMapGrayMap(g, this.heatMapImgGray, lineWidthB > 2 ? (int)((float)lineWidthB * 1.25f) : 1, this.lineWidth > 2 ? this.lineWidth - 2 : 1);
    }

    private static void drawHeatGrayDotMap(Graphics2D gB, MapView mv, List<WayPoint> listSegm, int drawSize) {
        double maxSegm = 25000.0;
        double nrSegms = listSegm.size();
        double randomDrop = Math.min(nrSegms > 25000.0 ? (nrSegms - 25000.0) / nrSegms : 0.0, (double)0.7f);
        double pixelRmsX = 100.0 / mv.getDist100Pixel() * 2.168;
        double pixelRmsY = 100.0 / mv.getDist100Pixel() * 4.218;
        Point lastPnt = null;
        for (WayPoint trkPnt : listSegm) {
            Point paintPnt = mv.getPoint(trkPnt);
            if (trkPnt.drawLine && null != lastPnt) {
                GpxDrawHelper.drawHeatSurfaceLine(gB, paintPnt, lastPnt, drawSize, pixelRmsX, pixelRmsY, randomDrop);
            }
            lastPnt = paintPnt;
        }
    }

    private static void drawHeatSurfaceLine(Graphics2D g, Point fromPnt, Point toPnt, int drawSize, double rmsSizeX, double rmsSizeY, double dropRate) {
        long fromX = (long)fromPnt.getX();
        long deltaX = (long)(toPnt.getX() - (double)fromX);
        long fromY = (long)fromPnt.getY();
        long deltaY = (long)(toPnt.getY() - (double)fromY);
        Random heatMapRandom = new Random(fromX + fromY + deltaX + deltaY);
        int dist = (int)Math.abs(fromPnt.distance(toPnt));
        double scaleStep = Math.max(1.0f / (float)dist, dist > 100 ? 0.1f : 0.2f);
        int rounds = Math.min(drawSize / 2, 1) + 1;
        rmsSizeX *= 1.0 - dropRate;
        rmsSizeY *= 1.0 - dropRate;
        for (double scaleVal = 0.0; scaleVal < 0.9999; scaleVal += scaleStep) {
            double pntX = (double)fromX + scaleVal * (double)deltaX;
            double pntY = (double)fromY + scaleVal * (double)deltaY;
            for (int k = 0; k < rounds; ++k) {
                int x = (int)(pntX + heatMapRandom.nextGaussian() * (k > 0 ? rmsSizeX : rmsSizeX / 4.0));
                int y = (int)(pntY + heatMapRandom.nextGaussian() * (k > 0 ? rmsSizeY : rmsSizeY / 4.0));
                if (!(heatMapRandom.nextDouble() >= dropRate)) continue;
                g.fillRect(x - drawSize, y - drawSize, drawSize, drawSize);
            }
        }
    }

    private void fixColors(List<WayPoint> visibleSegments) {
        for (WayPoint trkPnt : visibleSegments) {
            if (trkPnt.customColoring != null) continue;
            trkPnt.customColoring = this.neutralColor;
        }
    }

    private void checkCache() {
        if (this.computeCacheMaxLineLengthUsed != this.maxLineLength || this.computeCacheColored != this.colored || this.computeCacheVelocityTune != this.velocityTune || this.computeCacheColorDynamic != this.colorModeDynamic || this.computeCacheHeatMapDrawColorTableIdx != this.heatMapDrawColorTableIdx || !Objects.equals(this.neutralColor, this.computeCacheColorUsed) || this.computeCacheHeatMapDrawPointMode != this.heatMapDrawPointMode || this.computeCacheHeatMapDrawGain != this.heatMapDrawGain || this.computeCacheHeatMapDrawLowerLimit != this.heatMapDrawLowerLimit) {
            this.computeCacheMaxLineLengthUsed = this.maxLineLength;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = this.neutralColor;
            this.computeCacheColored = this.colored;
            this.computeCacheVelocityTune = this.velocityTune;
            this.computeCacheColorDynamic = this.colorModeDynamic;
            this.computeCacheHeatMapDrawColorTableIdx = this.heatMapDrawColorTableIdx;
            this.computeCacheHeatMapDrawPointMode = this.heatMapDrawPointMode;
            this.computeCacheHeatMapDrawGain = this.heatMapDrawGain;
            this.computeCacheHeatMapDrawLowerLimit = this.heatMapDrawLowerLimit;
        }
    }

    @Override
    public void gpxDataChanged(GpxData.GpxDataChangeEvent e) {
        this.computeCacheInSync = false;
    }

    public void drawColorBar(Graphics2D g, MapView mv) {
        int w = mv.getWidth();
        g.setComposite(AlphaComposite.SrcOver.derive(1.0f));
        if (this.colored == ColorMode.HDOP) {
            this.hdopScale.drawColorBar(g, w - 30, 50, 20, 100, 1.0);
        } else if (this.colored == ColorMode.QUALITY) {
            this.qualityScale.drawColorBar(g, w - 30, 50, 20, 100, 1.0);
        } else if (this.colored == ColorMode.VELOCITY) {
            SystemOfMeasurement som = SystemOfMeasurement.getSystemOfMeasurement();
            this.velocityScale.drawColorBar(g, w - 30, 50, 20, 100, som.speedValue);
        } else if (this.colored == ColorMode.DIRECTION) {
            this.directionScale.drawColorBar(g, w - 30, 50, 20, 100, 57.29577951308232);
        }
    }

    @Override
    public void paintableInvalidated(MapViewPaintable.PaintableInvalidationEvent event) {
        this.gpxLayerInvalidated = true;
    }

    @Override
    public void detachFromMapView(MapViewPaintable.MapViewEvent event) {
        SystemOfMeasurement.removeSoMChangeListener(this);
        this.layer.removeInvalidationListener(this);
        this.data.removeChangeListener(this);
    }

    public static enum ColorMode {
        NONE,
        VELOCITY,
        HDOP,
        DIRECTION,
        TIME,
        HEATMAP,
        QUALITY;


        static ColorMode fromIndex(int index) {
            return ColorMode.values()[index];
        }

        int toIndex() {
            return Arrays.asList(ColorMode.values()).indexOf((Object)this);
        }
    }
}

