/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.protobuf;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;

public class ProtobufPacked {
    private static final Number[] NO_NUMBERS = new Number[0];
    private final byte[] bytes;
    private final Number[] numbers;
    private int location = 0;

    public ProtobufPacked(ByteArrayOutputStream byteArrayOutputStream, byte[] bytes) {
        this.bytes = bytes;
        ArrayList<Number> numbersT = new ArrayList<Number>(bytes.length);
        while (this.location < bytes.length) {
            numbersT.add(ProtobufParser.convertByteArray(this.nextVarInt(byteArrayOutputStream), (byte)7));
        }
        this.numbers = numbersT.toArray(NO_NUMBERS);
    }

    public Number[] getArray() {
        return this.numbers;
    }

    private byte[] nextVarInt(ByteArrayOutputStream byteArrayOutputStream) {
        while ((this.bytes[this.location] & 0xFFFFFF80) == -128) {
            byteArrayOutputStream.write(this.bytes[this.location++] ^ 0xFFFFFF80);
        }
        byteArrayOutputStream.write(this.bytes[this.location++]);
        try {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            byteArrayOutputStream.reset();
        }
    }
}

