/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MemoryManager {
    private static final long JOSM_CORE_FOOTPRINT = 0x3200000L;
    private static final MemoryManager INSTANCE = new MemoryManager();
    private final ArrayList<MemoryHandle<?>> activeHandles = new ArrayList();

    protected MemoryManager() {
    }

    public synchronized <T> MemoryHandle<T> allocateMemory(String name, long maxBytes, Supplier<T> factory) throws NotEnoughMemoryException {
        if (this.isAvailable(maxBytes)) {
            T content = factory.get();
            if (content == null) {
                throw new IllegalArgumentException("Factory did not return a content element.");
            }
            Logging.info(MessageFormat.format("Allocate for {0}: {1} MB of memory. Available: {2} MB.", name, maxBytes / 1024L / 1024L, this.getAvailableMemory() / 1024L / 1024L));
            ManualFreeMemoryHandle<T> handle = new ManualFreeMemoryHandle<T>(name, content, maxBytes);
            this.activeHandles.add(handle);
            return handle;
        }
        throw new NotEnoughMemoryException(maxBytes);
    }

    public synchronized boolean isAvailable(long maxBytes) {
        if (maxBytes < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot allocate negative number of bytes: {0}", maxBytes));
        }
        return this.getAvailableMemory() >= maxBytes;
    }

    public synchronized long getMaxMemory() {
        return Runtime.getRuntime().maxMemory() - 0x3200000L;
    }

    public synchronized long getAvailableMemory() {
        return this.getMaxMemory() - this.activeHandles.stream().mapToLong(MemoryHandle::getSize).sum();
    }

    public static MemoryManager getInstance() {
        return INSTANCE;
    }

    protected synchronized List<MemoryHandle<?>> resetState() {
        ArrayList toFree = new ArrayList(this.activeHandles);
        toFree.forEach((Consumer<MemoryHandle<?>>)((Consumer<MemoryHandle>)MemoryHandle::free));
        return toFree;
    }

    private class ManualFreeMemoryHandle<T>
    implements MemoryHandle<T> {
        private final String name;
        private T content;
        private final long size;

        ManualFreeMemoryHandle(String name, T content, long size) {
            this.name = name;
            this.content = content;
            this.size = size;
        }

        @Override
        public T get() {
            if (this.content == null) {
                throw new IllegalStateException(MessageFormat.format("Memory area was accessed after free(): {0}", this.name));
            }
            return this.content;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            if (this.content == null) {
                throw new IllegalStateException(MessageFormat.format("Memory area was already marked as freed: {0}", this.name));
            }
            this.content = null;
            MemoryManager memoryManager = MemoryManager.this;
            synchronized (memoryManager) {
                MemoryManager.this.activeHandles.remove(this);
            }
        }

        public String toString() {
            return "MemoryHandle [name=" + this.name + ", size=" + this.size + ']';
        }
    }

    public static class NotEnoughMemoryException
    extends Exception {
        NotEnoughMemoryException(long memoryBytesRequired) {
            super(I18n.tr("To add another layer you need to allocate at least {0,number,#}MB memory to JOSM using -Xmx{0,number,#}M option (see http://forum.openstreetmap.org/viewtopic.php?id=25677).\nCurrently you have {1,number,#}MB memory allocated for JOSM", memoryBytesRequired / 1024L / 1024L, Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        }
    }

    public static interface MemoryHandle<T> {
        public T get();

        public long getSize();

        public void free();
    }
}

