/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.admin.JCSAdminBean;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICache;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IProvideScheduler;
import org.apache.commons.jcs3.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheConfigurator;
import org.apache.commons.jcs3.engine.control.event.ElementEventQueue;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs3.engine.stats.CacheStats;
import org.apache.commons.jcs3.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.OptionConverter;
import org.apache.commons.jcs3.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class CompositeCacheManager
implements IRemoteCacheConstants,
ICompositeCacheManager,
IProvideScheduler {
    private static final Log log = LogManager.getLog(CompositeCacheManager.class);
    public static final String JMX_OBJECT_NAME = "org.apache.commons.jcs3:type=JCSAdminBean";
    private static final String DEFAULT_CONFIG = "/cache.ccf";
    private static final String DEFAULT_REGION = "jcs.default";
    private static final boolean DEFAULT_USE_SYSTEM_PROPERTIES = true;
    private static final boolean DEFAULT_FORCE_RECONFIGURATION = false;
    private final ConcurrentMap<String, ICache<?, ?>> caches = new ConcurrentHashMap();
    private final AtomicInteger clients = new AtomicInteger(0);
    private ICompositeCacheAttributes defaultCacheAttr = new CompositeCacheAttributes();
    private IElementAttributes defaultElementAttr = new ElementAttributes();
    private final ConcurrentMap<String, AuxiliaryCacheFactory> auxiliaryFactoryRegistry = new ConcurrentHashMap<String, AuxiliaryCacheFactory>();
    private final ConcurrentMap<String, AuxiliaryCacheAttributes> auxiliaryAttributeRegistry = new ConcurrentHashMap<String, AuxiliaryCacheAttributes>();
    private final ConcurrentMap<String, AuxiliaryCache<?, ?>> auxiliaryCaches = new ConcurrentHashMap();
    private Properties configurationProperties;
    private String defaultAuxValues;
    private static CompositeCacheManager instance;
    private final LinkedBlockingDeque<IShutdownObserver> shutdownObservers = new LinkedBlockingDeque();
    private ScheduledExecutorService scheduledExecutor;
    private IElementEventQueue elementEventQueue;
    private Thread shutdownHook;
    private boolean isInitialized;
    private boolean isConfigured;
    private boolean isJMXRegistered;
    private String jmxName = "org.apache.commons.jcs3:type=JCSAdminBean";

    public static synchronized CompositeCacheManager getInstance() throws CacheException {
        return CompositeCacheManager.getInstance(DEFAULT_CONFIG);
    }

    public static synchronized CompositeCacheManager getInstance(String propsFilename) throws CacheException {
        if (instance == null) {
            log.info("Instance is null, creating with config [{0}]", propsFilename);
            instance = CompositeCacheManager.createInstance();
        }
        if (!instance.isInitialized()) {
            instance.initialize();
        }
        if (!instance.isConfigured()) {
            instance.configure(propsFilename);
        }
        CompositeCacheManager.instance.clients.incrementAndGet();
        return instance;
    }

    public static synchronized CompositeCacheManager getUnconfiguredInstance() {
        if (instance == null) {
            log.info("Instance is null, returning unconfigured instance");
            instance = CompositeCacheManager.createInstance();
        }
        if (!instance.isInitialized()) {
            instance.initialize();
        }
        CompositeCacheManager.instance.clients.incrementAndGet();
        return instance;
    }

    protected static CompositeCacheManager createInstance() {
        return new CompositeCacheManager();
    }

    protected CompositeCacheManager() {
    }

    protected synchronized void initialize() {
        if (!this.isInitialized) {
            this.shutdownHook = new Thread(() -> {
                if (this.isInitialized()) {
                    log.info("Shutdown hook activated. Shutdown was not called. Shutting down JCS.");
                    this.shutDown();
                }
            });
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (AccessControlException e) {
                log.error("Could not register shutdown hook.", e);
            }
            this.scheduledExecutor = Executors.newScheduledThreadPool(4, new DaemonThreadFactory("JCS-Scheduler-", 1));
            if (!this.isJMXRegistered && this.jmxName != null) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                JCSAdminBean adminBean = new JCSAdminBean(this);
                try {
                    ObjectName jmxObjectName = new ObjectName(this.jmxName);
                    mbs.registerMBean(adminBean, jmxObjectName);
                    this.isJMXRegistered = true;
                }
                catch (Exception e) {
                    log.warn("Could not register JMX bean.", e);
                }
            }
            this.isInitialized = true;
        }
    }

    public IElementEventQueue getElementEventQueue() {
        return this.elementEventQueue;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    public void configure() throws CacheException {
        this.configure(DEFAULT_CONFIG);
    }

    public void configure(String propFile) throws CacheException {
        log.info("Creating cache manager from config file: {0}", propFile);
        Properties props = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream(propFile);){
            props.load(is);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> propFile;
            supplierArray[1] = props::size;
            log.debug("File [{0}] contained {1} properties", supplierArray);
        }
        catch (IOException ex) {
            throw new CacheException("Failed to load properties for name [" + propFile + "]", ex);
        }
        this.configure(props);
    }

    public void configure(Properties props) {
        this.configure(props, true);
    }

    public void configure(Properties props, boolean useSystemProperties) {
        this.configure(props, useSystemProperties, false);
    }

    public synchronized void configure(Properties props, boolean useSystemProperties, boolean forceReconfiguration) {
        if (props == null) {
            log.error("No properties found. Please configure the cache correctly.");
            return;
        }
        if (this.isConfigured) {
            if (!forceReconfiguration) {
                log.debug("Configure called after the manager has been configured.  Force reconfiguration is false. Doing nothing");
                return;
            }
            log.info("Configure called after the manager has been configured.  Force reconfiguration is true. Reconfiguring as best we can.");
        }
        if (useSystemProperties) {
            CompositeCacheConfigurator.overrideWithSystemProperties(props);
        }
        this.doConfigure(props);
    }

    private synchronized void doConfigure(Properties properties) {
        this.configurationProperties = properties;
        ThreadPoolManager.setProps(properties);
        ThreadPoolManager poolMgr = ThreadPoolManager.getInstance();
        log.debug("ThreadPoolManager = {0}", poolMgr);
        this.elementEventQueue = new ElementEventQueue();
        CompositeCacheConfigurator configurator = this.newConfigurator();
        ElapsedTimer timer = new ElapsedTimer();
        this.defaultAuxValues = OptionConverter.findAndSubst(DEFAULT_REGION, properties);
        log.info("Setting default auxiliaries to \"{0}\"", this.defaultAuxValues);
        this.defaultCacheAttr = configurator.parseCompositeCacheAttributes(properties, "", new CompositeCacheAttributes(), DEFAULT_REGION);
        log.info("setting defaultCompositeCacheAttributes to {0}", this.defaultCacheAttr);
        this.defaultElementAttr = configurator.parseElementAttributes(properties, "", new ElementAttributes(), DEFAULT_REGION);
        log.info("setting defaultElementAttributes to {0}", this.defaultElementAttr);
        configurator.parseSystemRegions(properties, this);
        configurator.parseRegions(properties, this);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = timer::getElapsedTime;
        log.info("Finished configuration in {0} ms.", supplierArray);
        this.isConfigured = true;
    }

    public ICompositeCacheAttributes getDefaultCacheAttributes() {
        return this.defaultCacheAttr.clone();
    }

    public IElementAttributes getDefaultElementAttributes() {
        return this.defaultElementAttr.clone();
    }

    @Override
    public <K, V> CompositeCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.getDefaultCacheAttributes());
    }

    public <K, V> CompositeCache<K, V> getCache(String cacheName, ICompositeCacheAttributes cattr) {
        cattr.setCacheName(cacheName);
        return this.getCache(cattr, this.getDefaultElementAttributes());
    }

    public <K, V> CompositeCache<K, V> getCache(String cacheName, ICompositeCacheAttributes cattr, IElementAttributes attr) {
        cattr.setCacheName(cacheName);
        return this.getCache(cattr, attr);
    }

    public <K, V> CompositeCache<K, V> getCache(ICompositeCacheAttributes cattr) {
        return this.getCache(cattr, this.getDefaultElementAttributes());
    }

    public <K, V> CompositeCache<K, V> getCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        log.debug("attr = {0}", attr);
        return (CompositeCache)this.caches.computeIfAbsent(cattr.getCacheName(), cacheName -> {
            CompositeCacheConfigurator configurator = this.newConfigurator();
            return configurator.parseRegion(this.getConfigurationProperties(), this, (String)cacheName, this.defaultAuxValues, cattr);
        });
    }

    protected CompositeCacheConfigurator newConfigurator() {
        return new CompositeCacheConfigurator();
    }

    public void freeCache(String name) {
        this.freeCache(name, false);
    }

    public void freeCache(String name, boolean fromRemote) {
        CompositeCache cache = (CompositeCache)this.caches.remove(name);
        if (cache != null) {
            cache.dispose(fromRemote);
        }
    }

    public synchronized void shutDown() {
        if (this.elementEventQueue != null) {
            this.elementEventQueue.dispose();
        }
        IShutdownObserver observer = null;
        while ((observer = this.shutdownObservers.poll()) != null) {
            observer.shutdown();
        }
        if (this.isJMXRegistered) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName jmxObjectName = new ObjectName(this.jmxName);
                mbs.unregisterMBean(jmxObjectName);
            }
            catch (Exception e) {
                log.warn("Could not unregister JMX bean.", e);
            }
            this.isJMXRegistered = false;
        }
        this.getCacheNames().forEach(this::freeCache);
        for (String key : this.auxiliaryCaches.keySet()) {
            try {
                this.freeAuxiliaryCache(key);
            }
            catch (IOException e) {
                log.warn("Auxiliary cache {0} failed to shut down", key, e);
            }
        }
        this.auxiliaryFactoryRegistry.values().forEach(AuxiliaryCacheFactory::dispose);
        this.auxiliaryAttributeRegistry.clear();
        this.auxiliaryFactoryRegistry.clear();
        this.scheduledExecutor.shutdownNow();
        ThreadPoolManager.dispose();
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
        this.isConfigured = false;
        this.isInitialized = false;
    }

    public void release() {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean fromRemote) {
        Class<CompositeCacheManager> clazz = CompositeCacheManager.class;
        synchronized (CompositeCacheManager.class) {
            if (this.clients.decrementAndGet() > 0) {
                log.debug("Release called, but {0} remain", this.clients);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.caches::size;
            log.debug("Last client called release. There are {0} caches which will be disposed", supplierArray);
            this.caches.values().stream().filter(Objects::nonNull).forEach(cache -> ((CompositeCache)cache).dispose(fromRemote));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Set<String> getCacheNames() {
        return this.caches.keySet();
    }

    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    public void registryFacPut(AuxiliaryCacheFactory auxFac) {
        this.auxiliaryFactoryRegistry.put(auxFac.getName(), auxFac);
    }

    public AuxiliaryCacheFactory registryFacGet(String name) {
        return (AuxiliaryCacheFactory)this.auxiliaryFactoryRegistry.get(name);
    }

    public void registryAttrPut(AuxiliaryCacheAttributes auxAttr) {
        this.auxiliaryAttributeRegistry.put(auxAttr.getName(), auxAttr);
    }

    public AuxiliaryCacheAttributes registryAttrGet(String name) {
        return (AuxiliaryCacheAttributes)this.auxiliaryAttributeRegistry.get(name);
    }

    public void addCache(String cacheName, ICache<?, ?> cache) {
        this.caches.put(cacheName, cache);
    }

    public void addAuxiliaryCache(String auxName, String cacheName, AuxiliaryCache<?, ?> cache) {
        String key = String.format("aux.%s.region.%s", auxName, cacheName);
        this.auxiliaryCaches.put(key, cache);
    }

    @Override
    public <K, V> AuxiliaryCache<K, V> getAuxiliaryCache(String auxName, String cacheName) {
        String key = String.format("aux.%s.region.%s", auxName, cacheName);
        return (AuxiliaryCache)this.auxiliaryCaches.get(key);
    }

    public void freeAuxiliaryCache(String auxName, String cacheName) throws IOException {
        String key = String.format("aux.%s.region.%s", auxName, cacheName);
        this.freeAuxiliaryCache(key);
    }

    public void freeAuxiliaryCache(String key) throws IOException {
        AuxiliaryCache aux = (AuxiliaryCache)this.auxiliaryCaches.remove(key);
        if (aux != null) {
            aux.dispose();
        }
    }

    @Override
    public String getStats() {
        ICacheStats[] stats = this.getStatistics();
        if (stats == null) {
            return "NONE";
        }
        StringBuilder buf = new StringBuilder();
        Stream.of(stats).forEach(stat -> {
            buf.append("\n---------------------------\n");
            buf.append(stat);
        });
        return buf.toString();
    }

    public ICacheStats[] getStatistics() {
        List<CacheStats> cacheStats = this.caches.values().stream().filter(Objects::nonNull).map(cache -> ((CompositeCache)cache).getStatistics()).collect(Collectors.toList());
        return cacheStats.toArray(new CacheStats[0]);
    }

    @Override
    public void registerShutdownObserver(IShutdownObserver observer) {
        if (!this.shutdownObservers.contains(observer)) {
            this.shutdownObservers.push(observer);
        } else {
            log.warn("Shutdown observer added twice {0}", observer);
        }
    }

    @Override
    public void deregisterShutdownObserver(IShutdownObserver observer) {
        this.shutdownObservers.remove(observer);
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setJmxName(String name) {
        if (this.isJMXRegistered) {
            throw new IllegalStateException("Too late, MBean registration is done");
        }
        this.jmxName = name;
    }
}

