/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CopyUrlAction
extends JosmAction {
    public CopyUrlAction() {
        super(I18n.tr("Copy server URLs", new Object[0]), "copy", I18n.tr("Copy server URLs of selected objects to clipboard.", new Object[0]), Shortcut.registerShortcut("copy:urls", I18n.tr("Edit: {0}", I18n.tr("Copy server URLs", new Object[0])), 65535, 5000), false, "copy/urls", true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String base = Config.getUrls().getBaseBrowseUrl() + '/';
        String string = this.getSelected().stream().filter(p -> !p.isNew()).map(p -> base + OsmPrimitiveType.from(p).getAPIName() + '/' + p.getOsmId()).collect(Collectors.joining("\n"));
        Note note = CopyUrlAction.getNote();
        if (note != null && note.getId() > 0L) {
            string = string + "\n" + base + "/note/" + note.getId();
        }
        ClipboardUtils.copyString(string);
    }

    @Override
    protected void updateEnabledState() {
        Note note = CopyUrlAction.getNote();
        this.setEnabled(note != null && note.getId() > 0L || !this.getSelected().stream().allMatch(AbstractPrimitive::isNew));
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledState();
    }

    private static Note getNote() {
        return MainApplication.isDisplayingMapView() ? MainApplication.getMap().noteDialog.getSelectedNote() : null;
    }

    private Collection<OsmPrimitive> getSelected() {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        if (ds == null) {
            return Collections.emptyList();
        }
        return ds.getAllSelected();
    }
}

