/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.IOException;

class Base64 {
    private static final String BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char BASE64_PADDING = '=';
    private static final int BASE64_BITS_PER_CHAR = 6;
    private static final int BASE64_BYTES_PER_CHUNK = 3;

    Base64() {
    }

    static String encode(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Base64.encodeTo(stringBuilder, bytes, 0, bytes.length);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return stringBuilder.toString();
    }

    static void encodeTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
        for (int i = 0; i < len; i += 3) {
            Base64.encodeChunkTo(target, bytes, off + i, Math.min(3, len - i));
        }
    }

    static void encodeChunkTo(Appendable target, byte[] bytes, int off, int len) throws IOException {
        int bitsProcessed;
        long bitBuffer = 0L;
        for (int i = 0; i < len; ++i) {
            bitBuffer |= (long)(bytes[off + i] & 0xFF);
            bitBuffer <<= 8;
        }
        int bitOffset = (len + 1) * 8 - 6;
        for (bitsProcessed = 0; bitsProcessed < len * 8; bitsProcessed += 6) {
            int charIndex = (int)(bitBuffer >>> bitOffset - bitsProcessed) & BASE64.length() - 1;
            target.append(BASE64.charAt(charIndex));
        }
        while (bitsProcessed < 24) {
            target.append('=');
            bitsProcessed += 6;
        }
    }
}

