/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class TagEditorModel
extends AbstractTableModel {
    public static final String PROP_DIRTY = TagEditorModel.class.getName() + ".dirty";
    protected final transient List<TagModel> tags = new ArrayList<TagModel>();
    private boolean dirty;
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private final DefaultListSelectionModel rowSelectionModel;
    private final DefaultListSelectionModel colSelectionModel;
    private transient OsmPrimitive primitive;
    private transient EndEditListener endEditListener;

    public TagEditorModel() {
        this(new DefaultListSelectionModel(), new DefaultListSelectionModel());
    }

    public TagEditorModel(DefaultListSelectionModel rowSelectionModel, DefaultListSelectionModel colSelectionModel) {
        CheckParameterUtil.ensureParameterNotNull(rowSelectionModel, "rowSelectionModel");
        CheckParameterUtil.ensureParameterNotNull(colSelectionModel, "colSelectionModel");
        this.rowSelectionModel = rowSelectionModel;
        this.colSelectionModel = colSelectionModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public DefaultListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    public DefaultListSelectionModel getColumnSelectionModel() {
        return this.colSelectionModel;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    protected void fireDirtyStateChanged(boolean oldValue, boolean newValue) {
        this.propChangeSupport.firePropertyChange(PROP_DIRTY, oldValue, newValue);
    }

    protected void setDirty(boolean newValue) {
        boolean oldValue = this.dirty;
        this.dirty = newValue;
        if (oldValue != newValue) {
            this.fireDirtyStateChanged(oldValue, newValue);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("unexpected rowIndex: rowIndex=" + rowIndex);
        }
        return this.tags.get(rowIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TagModel tag = this.get(row);
        if (tag != null) {
            switch (col) {
                case 0: {
                    this.updateTagName(tag, (String)value);
                    break;
                }
                case 1: {
                    String v = (String)value;
                    if ((tag.getValueCount() <= 1 || v.isEmpty()) && tag.getValueCount() > 1) break;
                    this.updateTagValue(tag, v);
                    break;
                }
            }
        }
    }

    public void clear() {
        this.commitPendingEdit();
        boolean wasEmpty = this.tags.isEmpty();
        this.tags.clear();
        if (!wasEmpty) {
            this.setDirty(true);
            this.fireTableDataChanged();
        }
    }

    public void add(TagModel tag) {
        this.commitPendingEdit();
        CheckParameterUtil.ensureParameterNotNull(tag, "tag");
        this.tags.add(tag);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void prepend(TagModel tag) {
        this.commitPendingEdit();
        CheckParameterUtil.ensureParameterNotNull(tag, "tag");
        this.tags.add(0, tag);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(String name, String value) {
        this.commitPendingEdit();
        String key = name == null ? "" : name;
        String val = value == null ? "" : value;
        TagModel tag = this.get(key);
        if (tag == null) {
            int index;
            tag = new TagModel(key, val);
            for (index = this.tags.size(); index >= 1 && this.tags.get(index - 1).getName().isEmpty() && this.tags.get(index - 1).getValue().isEmpty(); --index) {
            }
            this.tags.add(index, tag);
        } else {
            tag.addValue(val);
        }
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public TagModel get(String name) {
        String key = name == null ? "" : name;
        return this.tags.stream().filter(tag -> tag.getName().equals(key)).findFirst().orElse(null);
    }

    public TagModel get(int idx) {
        return idx >= this.tags.size() ? null : this.tags.get(idx);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void deleteTagNames(int ... tagIndices) {
        this.commitPendingEdit();
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            tag.setName("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTagValues(int ... tagIndices) {
        this.commitPendingEdit();
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            tag.setValue("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void delete(String name) {
        this.commitPendingEdit();
        if (name == null) {
            return;
        }
        boolean changed = this.tags.removeIf(tm -> tm.getName().equals(name));
        if (changed) {
            this.fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void deleteTags(int ... tagIndices) {
        this.commitPendingEdit();
        List<TagModel> toDelete = Arrays.stream(tagIndices).mapToObj(this.tags::get).filter(Objects::nonNull).collect(Collectors.toList());
        toDelete.forEach(this.tags::remove);
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void appendNewTag() {
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.fireTableDataChanged();
    }

    public void ensureOneTag() {
        if (this.tags.isEmpty()) {
            this.appendNewTag();
        }
    }

    public void initFromPrimitive(Tagged primitive) {
        this.commitPendingEdit();
        this.tags.clear();
        primitive.visitKeys((p, key, value) -> this.tags.add(new TagModel(key, value)));
        this.sort();
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.setDirty(false);
        this.fireTableDataChanged();
    }

    public void initFromTags(Map<String, String> tags) {
        this.commitPendingEdit();
        this.tags.clear();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.tags.add(new TagModel(entry.getKey(), entry.getValue()));
        }
        this.sort();
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.setDirty(false);
    }

    public void initFromTags(TagCollection tags) {
        this.commitPendingEdit();
        this.tags.clear();
        if (tags == null) {
            this.setDirty(false);
            return;
        }
        for (String key : tags.getKeys()) {
            String value = tags.getJoinedValues(key);
            this.tags.add(new TagModel(key, value));
        }
        this.sort();
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.setDirty(false);
    }

    public void applyToPrimitive(Tagged primitive) {
        primitive.setKeys(this.applyToTags(false));
    }

    private Map<String, String> applyToTags(boolean keepEmpty) {
        TagMap result = new TagMap();
        for (TagModel tag : this.tags) {
            if (tag.getValueCount() > 1) continue;
            boolean isKeyEmpty = Utils.isStripEmpty(tag.getName());
            boolean isValueEmpty = Utils.isStripEmpty(tag.getValue());
            if (isKeyEmpty && isValueEmpty || !keepEmpty && (isKeyEmpty || isValueEmpty)) continue;
            result.put(Utils.strip(tag.getName()), Utils.strip(tag.getValue()));
        }
        return result;
    }

    public Map<String, String> getTags() {
        return this.getTags(false);
    }

    public Map<String, String> getTags(boolean keepEmpty) {
        return this.applyToTags(keepEmpty);
    }

    public TagCollection getTagCollection() {
        return TagCollection.from(this.getTags());
    }

    public boolean includesTag(String key) {
        return key != null && this.tags.stream().anyMatch(tag -> tag.getName().equals(key));
    }

    protected Command createUpdateTagCommand(Collection<OsmPrimitive> primitives, TagModel tag) {
        if (tag.getValueCount() > 1) {
            return null;
        }
        if (Utils.isStripEmpty(tag.getName())) {
            return null;
        }
        return new ChangePropertyCommand(primitives, tag.getName(), tag.getValue());
    }

    protected Command createDeleteTagsCommand(Collection<OsmPrimitive> primitives) {
        List<String> currentkeys = this.getKeys();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (OsmPrimitive prim : primitives) {
            prim.visitKeys((p, oldkey, value) -> {
                if (!currentkeys.contains(oldkey)) {
                    commands.add(new ChangePropertyCommand(prim, oldkey, null));
                }
            });
        }
        return commands.isEmpty() ? null : new SequenceCommand(I18n.trn("Remove old keys from up to {0} object", "Remove old keys from up to {0} objects", primitives.size(), primitives.size()), commands);
    }

    public List<String> getKeys() {
        return this.tags.stream().map(TagModel::getName).filter(name -> !Utils.isStripEmpty(name)).collect(Collectors.toList());
    }

    protected void sort() {
        this.tags.sort(Comparator.comparing(TagModel::getName));
    }

    public void updateTagName(TagModel tag, String newName) {
        String oldName = tag.getName();
        tag.setName(newName);
        if (!newName.equals(oldName)) {
            this.setDirty(true);
        }
        SelectionStateMemento memento = new SelectionStateMemento();
        this.fireTableDataChanged();
        memento.apply();
    }

    public void updateTagValue(TagModel tag, String newValue) {
        String oldValue = tag.getValue();
        tag.setValue(newValue);
        if (!newValue.equals(oldValue)) {
            this.setDirty(true);
        }
        SelectionStateMemento memento = new SelectionStateMemento();
        this.fireTableDataChanged();
        memento.apply();
    }

    public void updateTags(List<Tag> tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.commitPendingEdit();
        Map<String, TagModel> modelTags = IntStream.range(0, this.getRowCount()).mapToObj(this::get).collect(Collectors.toMap(TagModel::getName, tagModel -> tagModel, (a, b) -> b));
        for (Tag tag : tags) {
            TagModel existing = modelTags.get(tag.getKey());
            if (tag.getValue().isEmpty()) {
                if (existing == null) continue;
                this.delete(tag.getKey());
                continue;
            }
            if (existing != null) {
                this.updateTagValue(existing, tag.getValue());
                continue;
            }
            this.add(tag.getKey(), tag.getValue());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Collection<TaggingPresetType> getTaggingPresetTypes() {
        return this.primitive == null ? EnumSet.noneOf(TaggingPresetType.class) : EnumSet.of(TaggingPresetType.forPrimitive(this.primitive));
    }

    public TagEditorModel forPrimitive(OsmPrimitive primitive) {
        this.primitive = primitive;
        return this;
    }

    public void setEndEditListener(EndEditListener endEditListener) {
        this.endEditListener = endEditListener;
    }

    protected void commitPendingEdit() {
        if (this.endEditListener != null) {
            this.endEditListener.endCellEditing();
        }
    }

    class SelectionStateMemento {
        private final int rowMin;
        private final int rowMax;
        private final int colMin;
        private final int colMax;

        SelectionStateMemento() {
            this.rowMin = TagEditorModel.this.rowSelectionModel.getMinSelectionIndex();
            this.rowMax = TagEditorModel.this.rowSelectionModel.getMaxSelectionIndex();
            this.colMin = TagEditorModel.this.colSelectionModel.getMinSelectionIndex();
            this.colMax = TagEditorModel.this.colSelectionModel.getMaxSelectionIndex();
        }

        void apply() {
            TagEditorModel.this.rowSelectionModel.setValueIsAdjusting(true);
            TagEditorModel.this.colSelectionModel.setValueIsAdjusting(true);
            if (this.rowMin >= 0 && this.rowMax >= 0) {
                TagEditorModel.this.rowSelectionModel.setSelectionInterval(this.rowMin, this.rowMax);
            }
            if (this.colMin >= 0 && this.colMax >= 0) {
                TagEditorModel.this.colSelectionModel.setSelectionInterval(this.colMin, this.colMax);
            }
            TagEditorModel.this.rowSelectionModel.setValueIsAdjusting(false);
            TagEditorModel.this.colSelectionModel.setValueIsAdjusting(false);
        }
    }

    @FunctionalInterface
    public static interface EndEditListener {
        public void endCellEditing();
    }
}

