/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.instance;

import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import java.util.List;

public class Instance {
    public int[][] featureMatrix;
    public int[] tagArray;

    protected Instance() {
    }

    protected static int[] toFeatureArray(List<Integer> featureVector) {
        int[] featureArray = new int[featureVector.size() + 1];
        int index = -1;
        for (Integer feature : featureVector) {
            featureArray[++index] = feature;
        }
        return featureArray;
    }

    public int[] getFeatureAt(int position) {
        return this.featureMatrix[position];
    }

    public int length() {
        return this.tagArray.length;
    }

    protected static void addFeature(CharSequence rawFeature, List<Integer> featureVector, FeatureMap featureMap) {
        int id = featureMap.idOf(rawFeature.toString());
        if (id != -1) {
            featureVector.add(id);
        }
    }

    protected static void addFeatureThenClear(StringBuilder rawFeature, List<Integer> featureVector, FeatureMap featureMap) {
        int id = featureMap.idOf(rawFeature.toString());
        if (id != -1) {
            featureVector.add(id);
        }
        rawFeature.setLength(0);
    }

    public String[] tags(TagSet tagSet) {
        assert (this.tagArray != null);
        String[] tags = new String[this.tagArray.length];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tagSet.stringOf(this.tagArray[i]);
        }
        return tags;
    }

    public int size() {
        return this.featureMatrix.length;
    }
}

