/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.languagetool.JLanguageTool;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.DatabaseAccessLimitLogEntry;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.LimitEnforcementMode;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TooManyRequestsException;
import org.languagetool.server.UserLimits;

class RequestLimiter {
    static final int REQUEST_QUEUE_SIZE = 1000;
    final List<RequestEvent> requestEvents = new CopyOnWriteArrayList<RequestEvent>();
    private final int ipFingerprintFactor;
    private final List<String> whitelistUsers;
    private final int whitelistLimit;
    private final int requestLimit;
    private final int ipRequestLimit;
    private final int requestLimitInBytes;
    private final int ipRequestLimitInBytes;
    private final int requestLimitPeriodInSeconds;
    private final Long server;
    private final DatabaseLogger logger;

    RequestLimiter(int requestLimit, int requestLimitInBytes, int requestLimitPeriodInSeconds, int ipFingerprintFactor, List<String> whitelistUsers, int whitelistLimit) {
        this.requestLimit = requestLimit;
        this.requestLimitInBytes = requestLimitInBytes;
        this.requestLimitPeriodInSeconds = requestLimitPeriodInSeconds;
        this.ipFingerprintFactor = ipFingerprintFactor;
        this.whitelistUsers = whitelistUsers != null ? whitelistUsers : Collections.emptyList();
        this.whitelistLimit = whitelistLimit;
        if (ipFingerprintFactor > 0) {
            this.ipRequestLimit = requestLimit * ipFingerprintFactor;
            this.ipRequestLimitInBytes = requestLimitInBytes * ipFingerprintFactor;
        } else {
            this.ipRequestLimit = requestLimit;
            this.ipRequestLimitInBytes = requestLimitInBytes;
        }
        this.logger = DatabaseLogger.getInstance();
        if (this.logger.isLogging()) {
            DatabaseAccess db = DatabaseAccess.getInstance();
            this.server = db.getOrCreateServerId();
        } else {
            this.server = null;
        }
    }

    RequestLimiter(int requestLimit, int requestLimitInBytes, int requestLimitPeriodInSeconds, int ipFingerprintFactor) {
        this(requestLimit, requestLimitInBytes, requestLimitPeriodInSeconds, ipFingerprintFactor, null, 0);
    }

    RequestLimiter(int requestLimit, int requestLimitInBytes, int requestLimitPeriodInSeconds) {
        this(requestLimit, requestLimitInBytes, requestLimitPeriodInSeconds, 1);
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getRequestLimitInBytes() {
        return this.requestLimitInBytes;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    String computeFingerprint(Map<String, List<String>> httpHeader, Map<String, String> parameters) {
        List<String> empty = Collections.singletonList("");
        String separator = "|";
        LinkedList<String> fields = new LinkedList<String>();
        fields.add(String.join((CharSequence)separator, (Iterable<? extends CharSequence>)httpHeader.getOrDefault("User-Agent", empty)));
        fields.add(String.join((CharSequence)separator, (Iterable<? extends CharSequence>)httpHeader.getOrDefault("Accept-Language", empty)));
        fields.add(String.join((CharSequence)separator, (Iterable<? extends CharSequence>)httpHeader.getOrDefault("Referer", empty)));
        fields.add(String.join((CharSequence)separator, parameters.getOrDefault("textSessionId", "")));
        return String.join((CharSequence)separator, fields);
    }

    void checkAccess(String ipAddress, Map<String, String> params, Map<String, List<String>> httpHeader, UserLimits userLimits) {
        if (userLimits.getSkipLimits()) {
            return;
        }
        int reqSize = this.getRequestSize(params);
        while (this.requestEvents.size() > 1000) {
            this.requestEvents.remove(0);
        }
        this.requestEvents.add(new RequestEvent(ipAddress, new Date(), reqSize, this.computeFingerprint(httpHeader, params), ServerTools.getMode(params)));
        this.checkLimit(ipAddress, params, httpHeader);
    }

    private int getRequestSize(Map<String, String> params) {
        String text = params.get("text");
        if (text != null) {
            return text.length();
        }
        String data = params.get("data");
        if (data != null) {
            return data.length();
        }
        return 0;
    }

    private Long getClientId(Map<String, String> parameters) {
        if (this.logger.isLogging()) {
            DatabaseAccess db = DatabaseAccess.getInstance();
            String paramValue = parameters.get("useragent");
            if (paramValue == null) {
                return null;
            }
            return db.getOrCreateClientId(paramValue);
        }
        return null;
    }

    private String getReferer(Map<String, List<String>> httpHeader) {
        List<String> values = httpHeader.get("Referer");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    private String getUserAgent(Map<String, List<String>> httpHeader) {
        List<String> values = httpHeader.get("User-Agent");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    static void checkUserLimit(String referer, String userAgent, Long clientId, Long server, UserLimits user) {
        Long requestCount;
        Long maxRequests = user.getRequestsPerDay();
        if (user.getPremiumUid() != null && maxRequests != null && user.getLimitEnforcementMode() != LimitEnforcementMode.DISABLED && user.getLimitEnforcementMode() == LimitEnforcementMode.PER_DAY && (requestCount = DatabaseAccess.getInstance().getUserRequestCount(user.getPremiumUid())) > maxRequests) {
            String message = "limit: " + maxRequests + ", requests: " + requestCount + ", enforcement: " + user.getLimitEnforcementMode().name();
            DatabaseLogger.getInstance().log(new DatabaseAccessLimitLogEntry("MaxUserRequests", server, clientId, user.getPremiumUid(), message, referer, userAgent));
            throw new TooManyRequestsException("User request limit of " + maxRequests + " per day exceeded. Try again after midnight UTC.");
        }
    }

    void checkLimit(String ipAddress, Map<String, String> parameters, Map<String, List<String>> httpHeader) {
        int requestsByIp = 0;
        int requestSizeByIp = 0;
        int requestsByFingerprint = 0;
        int requestSizeByFingerprint = 0;
        Date thresholdDate = new Date(System.currentTimeMillis() - (long)this.requestLimitPeriodInSeconds * 1000L);
        String fingerprint = this.computeFingerprint(httpHeader, parameters);
        String referer = this.getReferer(httpHeader);
        String userAgent = this.getUserAgent(httpHeader);
        Long clientId = this.getClientId(parameters);
        String user = parameters.get("username");
        boolean whitelistedUser = user != null && this.whitelistUsers.contains(user);
        for (RequestEvent event : this.requestEvents) {
            if (!event.ip.equals(ipAddress) || !event.date.after(thresholdDate)) continue;
            float modeFactor = event.mode == JLanguageTool.Mode.TEXTLEVEL_ONLY ? 0.1f : 1.0f;
            ++requestsByIp;
            requestSizeByIp = (int)((float)requestSizeByIp + (float)event.getSizeInBytes() * modeFactor);
            if (whitelistedUser) {
                if (this.whitelistLimit <= 0 || requestsByIp < this.whitelistLimit) continue;
                String msg = "limit: " + this.ipRequestLimit + " / " + this.requestLimitPeriodInSeconds + ", requests: " + requestsByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
                this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestPerPeriodIp", this.server, clientId, null, msg, referer, userAgent));
                throw new TooManyRequestsException("Whitelist request limit of " + this.whitelistLimit + " requests per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
            }
            if (event.fingerprint.equals(fingerprint)) {
                ++requestsByFingerprint;
                requestSizeByFingerprint = (int)((float)requestSizeByFingerprint + (float)event.getSizeInBytes() * modeFactor);
            }
            if (this.ipFingerprintFactor > 0 && this.requestLimit > 0 && requestsByFingerprint > this.requestLimit) {
                String msg = "limit: " + this.requestLimit + " / " + this.requestLimitPeriodInSeconds + ", requests: " + requestsByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
                this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestPerPeriodFingerprint", this.server, clientId, null, msg, referer, userAgent));
                throw new TooManyRequestsException("Client request limit of " + this.requestLimit + " requests per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
            }
            if (this.requestLimit > 0 && requestsByIp > this.ipRequestLimit) {
                String msg = "limit: " + this.ipRequestLimit + " / " + this.requestLimitPeriodInSeconds + ", requests: " + requestsByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
                this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestPerPeriodIp", this.server, clientId, null, msg, referer, userAgent));
                throw new TooManyRequestsException("IP request limit of " + this.ipRequestLimit + " requests per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
            }
            if (event.mode == JLanguageTool.Mode.TEXTLEVEL_ONLY) {
                if (this.ipFingerprintFactor > 0 && this.requestLimitInBytes > 0 && requestSizeByFingerprint > this.requestLimitInBytes) {
                    String msg = "limit in Mode.TEXTLEVEL_ONLY: " + this.requestLimitInBytes + " / " + this.requestLimitPeriodInSeconds + ", request size: " + requestSizeByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
                    this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestSizePerPeriodFingerprint", this.server, clientId, null, msg, referer, userAgent));
                    throw new TooManyRequestsException("Client request size limit of " + this.requestLimitInBytes + " bytes per " + this.requestLimitPeriodInSeconds + " seconds exceeded in text-level checks");
                }
                if (this.requestLimitInBytes <= 0 || requestSizeByIp <= this.ipRequestLimitInBytes) continue;
                String msg = "limit in Mode.TEXTLEVEL_ONLY: " + this.ipRequestLimitInBytes + " / " + this.requestLimitPeriodInSeconds + ", request size: " + requestSizeByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
                this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestSizePerPeriodIp", this.server, clientId, null, msg, referer, userAgent));
                throw new TooManyRequestsException("IP request size limit of " + this.ipRequestLimitInBytes + " bytes per " + this.requestLimitPeriodInSeconds + " seconds exceeded in text-level checks");
            }
            if (this.ipFingerprintFactor > 0 && this.requestLimitInBytes > 0 && requestSizeByFingerprint > this.requestLimitInBytes) {
                String msg = "limit: " + this.requestLimitInBytes + " / " + this.requestLimitPeriodInSeconds + ", request size: " + requestSizeByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
                this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestSizePerPeriodFingerprint", this.server, clientId, null, msg, referer, userAgent));
                throw new TooManyRequestsException("Client request size limit of " + this.requestLimitInBytes + " bytes per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
            }
            if (this.requestLimitInBytes <= 0 || requestSizeByIp <= this.ipRequestLimitInBytes) continue;
            String msg = "limit: " + this.ipRequestLimitInBytes + " / " + this.requestLimitPeriodInSeconds + ", request size: " + requestSizeByIp + ", ip: " + ipAddress + ", fingerprint: " + fingerprint;
            this.logger.log(new DatabaseAccessLimitLogEntry("MaxRequestSizePerPeriodIp", this.server, clientId, null, msg, referer, userAgent));
            throw new TooManyRequestsException("IP request size limit of " + this.ipRequestLimitInBytes + " bytes per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
        }
    }

    protected static class RequestEvent {
        private final String ip;
        private final Date date;
        private final int sizeInBytes;
        private final String fingerprint;
        private final JLanguageTool.Mode mode;

        RequestEvent(String ip, Date date, int sizeInBytes, String fingerprint, JLanguageTool.Mode mode) {
            this.ip = ip;
            this.date = new Date(date.getTime());
            this.sizeInBytes = sizeInBytes;
            this.fingerprint = fingerprint;
            this.mode = mode;
        }

        protected Date getDate() {
            return this.date;
        }

        int getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

