/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.RuleMatch;

public class DoublePunctuationRuleTest {
    @Test
    public void testRule() throws IOException {
        DoublePunctuationRule rule = new DoublePunctuationRule(TestTools.getEnglishMessages());
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(lt.getAnalyzedSentence("This is a test sentence..."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(lt.getAnalyzedSentence("\u042d\u0442\u043e \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435?.."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(lt.getAnalyzedSentence("\u042d\u0442\u043e \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435!.. "));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(lt.getAnalyzedSentence("This is a test sentence... More stuff...."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(lt.getAnalyzedSentence("This is a test sentence..... More stuff...."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(lt.getAnalyzedSentence("This, is, a test sentence."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(lt.getAnalyzedSentence("This,, is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)4L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)6L, (long)matches[0].getToPos());
        matches = rule.match(lt.getAnalyzedSentence("This is a test sentence.. Another sentence"));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)23L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)25L, (long)matches[0].getToPos());
    }
}

