/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.ant;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.tools.ant.types.Resource;

final class IconResource
extends Resource {
    private Resource r;
    private BufferedImage badgeIcon;

    public IconResource(Resource r, BufferedImage badgeIcon) {
        super(r.getName(), r.isExists(), r.getLastModified(), r.isDirectory(), r.getSize());
        this.r = r;
        this.badgeIcon = badgeIcon;
    }

    public InputStream getInputStream() throws IOException {
        if (this.getName().endsWith(".html")) {
            return this.r.getInputStream();
        }
        try {
            InputStream is = this.r.getInputStream();
            BufferedImage img = ImageIO.read(is);
            if (img == null) {
                return this.r.getInputStream();
            }
            BufferedImage merge = IconResource.merge(img, this.badgeIcon);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)merge, "png", os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException ex) {
            return this.r.getInputStream();
        }
    }

    private static BufferedImage merge(BufferedImage main, BufferedImage badge) {
        int w = Math.max(main.getWidth(), badge.getWidth());
        int h = Math.max(main.getHeight(), badge.getHeight());
        BufferedImage result = new BufferedImage(w, h, 2);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int badgeColor = x < badge.getWidth() && y < badge.getHeight() ? badge.getRGB(x, y) : 0;
                int mainColor = x < main.getWidth() && y < main.getHeight() ? main.getRGB(x, y) : 0;
                int mergedColor = IconResource.packARGB(IconResource.overARGB(IconResource.unpackARGB(badgeColor), IconResource.unpackAGray(mainColor)));
                result.setRGB(x, y, mergedColor);
            }
        }
        return result;
    }

    private static int[] unpackAGray(int c) {
        int[] res = IconResource.unpackARGB(c);
        int gray = (res[1] * 30 + res[2] * 59 + res[3] * 11) / 100;
        return new int[]{res[0], gray, gray, gray};
    }

    private static int[] unpackARGB(int c) {
        return new int[]{c >> 24 & 0xFF, c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF};
    }

    private static int packARGB(int[] c) {
        return c[0] << 24 | c[1] << 16 | c[2] << 8 | c[3];
    }

    private static int[] overARGB(int[] a, int[] b) {
        int c;
        int[] r = new int[4];
        for (int c2 = 0; c2 < 4; ++c2) {
            assert (a[c2] >= 0 && a[c2] <= 255) : a[c2];
            assert (b[c2] >= 0 && b[c2] <= 255) : b[c2];
        }
        float alphaA = (float)a[0] / 255.0f;
        float alphaB = (float)b[0] / 255.0f;
        float alphaANeg = 1.0f - alphaA;
        float alphaO = alphaA + alphaB * alphaANeg;
        r[0] = (int)(alphaO * 255.0f + 0.5f);
        for (c = 1; c <= 3; ++c) {
            float cA = (float)a[c] / 255.0f;
            float cB = (float)b[c] / 255.0f;
            float cR = (cA * alphaA + cB * alphaB * alphaANeg) / alphaO;
            r[c] = (int)(cR * 255.0f + 0.5f);
        }
        for (c = 0; c < 4; ++c) {
            assert (r[c] >= 0 && r[c] <= 255) : r[c];
        }
        return r;
    }

    private static String show(int[] argb) {
        return String.format("%08X", IconResource.packARGB(argb));
    }

    static {
        int[] argb = new int[]{171, 18, 205, 52};
        int p = IconResource.packARGB(argb);
        assert (p == -1424831180) : p;
        assert (Arrays.equals(argb, IconResource.unpackARGB(p)));
        String s = IconResource.show(argb);
        assert (s.equals("AB12CD34")) : s;
        int[] a = IconResource.unpackARGB(9869466);
        int[] b = IconResource.unpackARGB(-11512451);
        int[] r = IconResource.overARGB(a, b);
        assert (IconResource.packARGB(r) == -11512451) : IconResource.show(r);
    }
}

