/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.result.condition.AbstractMediaTypeExpression;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.reactive.result.condition.HeadersRequestCondition;
import org.springframework.web.reactive.result.condition.MediaTypeExpression;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

public final class ConsumesRequestCondition
extends AbstractRequestCondition<ConsumesRequestCondition> {
    private static final ConsumesRequestCondition EMPTY_CONDITION = new ConsumesRequestCondition(new String[0]);
    private final List<ConsumeMediaTypeExpression> expressions;
    private boolean bodyRequired = true;

    public ConsumesRequestCondition(String ... consumes) {
        this(consumes, (String[])null);
    }

    public ConsumesRequestCondition(String[] consumes, String[] headers2) {
        this.expressions = new ArrayList<ConsumeMediaTypeExpression>(ConsumesRequestCondition.parseExpressions(consumes, headers2));
        Collections.sort(this.expressions);
    }

    private ConsumesRequestCondition(List<ConsumeMediaTypeExpression> expressions) {
        this.expressions = expressions;
    }

    private static Set<ConsumeMediaTypeExpression> parseExpressions(String[] consumes, String[] headers2) {
        LinkedHashSet<ConsumeMediaTypeExpression> result = new LinkedHashSet<ConsumeMediaTypeExpression>();
        if (headers2 != null) {
            for (String header : headers2) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Content-Type".equalsIgnoreCase(expr.name)) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)((String)expr.value))) {
                    result.add(new ConsumeMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        if (consumes != null) {
            for (String consume : consumes) {
                result.add(new ConsumeMediaTypeExpression(consume));
            }
        }
        return result;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getConsumableMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ConsumeMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected Collection<ConsumeMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    public void setBodyRequired(boolean bodyRequired) {
        this.bodyRequired = bodyRequired;
    }

    public boolean isBodyRequired() {
        return this.bodyRequired;
    }

    @Override
    public ConsumesRequestCondition combine(ConsumesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    public ConsumesRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)request)) {
            return EMPTY_CONDITION;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (!this.hasBody(request) && !this.bodyRequired) {
            return EMPTY_CONDITION;
        }
        List<ConsumeMediaTypeExpression> result = this.getMatchingExpressions(exchange);
        return !CollectionUtils.isEmpty(result) ? new ConsumesRequestCondition(result) : null;
    }

    private boolean hasBody(ServerHttpRequest request) {
        String contentLength = request.getHeaders().getFirst("Content-Length");
        String transferEncoding = request.getHeaders().getFirst("Transfer-Encoding");
        return StringUtils.hasText((String)transferEncoding) || StringUtils.hasText((String)contentLength) && !contentLength.trim().equals("0");
    }

    @Nullable
    private List<ConsumeMediaTypeExpression> getMatchingExpressions(ServerWebExchange exchange) {
        ArrayList<ConsumeMediaTypeExpression> result = null;
        for (ConsumeMediaTypeExpression expression : this.expressions) {
            if (!expression.match(exchange)) continue;
            result = result != null ? result : new ArrayList<ConsumeMediaTypeExpression>();
            result.add(expression);
        }
        return result;
    }

    @Override
    public int compareTo(ConsumesRequestCondition other, ServerWebExchange exchange) {
        if (this.expressions.isEmpty() && other.expressions.isEmpty()) {
            return 0;
        }
        if (this.expressions.isEmpty()) {
            return 1;
        }
        if (other.expressions.isEmpty()) {
            return -1;
        }
        return this.expressions.get(0).compareTo(other.expressions.get(0));
    }

    static class ConsumeMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ConsumeMediaTypeExpression(String expression) {
            super(expression);
        }

        ConsumeMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        @Override
        protected boolean matchMediaType(ServerWebExchange exchange) throws UnsupportedMediaTypeStatusException {
            try {
                MediaType contentType2 = exchange.getRequest().getHeaders().getContentType();
                contentType2 = contentType2 != null ? contentType2 : MediaType.APPLICATION_OCTET_STREAM;
                return this.getMediaType().includes(contentType2);
            }
            catch (InvalidMediaTypeException ex) {
                throw new UnsupportedMediaTypeStatusException("Can't parse Content-Type [" + exchange.getRequest().getHeaders().getFirst("Content-Type") + "]: " + ex.getMessage());
            }
        }
    }
}

