/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.Timer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ImportProblemsPanel;
import org.netbeans.modules.projectimport.eclipse.core.Importer;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProgressPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class ImportProjectAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        ProjectImporterWizard wizard = new ProjectImporterWizard();
        wizard.start();
        List<EclipseProject> eclProjects = wizard.getProjects();
        String destination = wizard.getDestination();
        if (wizard.isCancelled() || eclProjects == null) {
            return;
        }
        ImportProjectAction.performImport(eclProjects, destination, wizard.getExtraPanels(), wizard.getNumberOfImportedProject(), true, true, null, null);
    }

    public static void performImport(List<EclipseProject> eclProjects, String destination, List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels, int numberOfImportedProject, final boolean showReport, final boolean openProjects, final List<String> importProblems, final List<Project> createdProjects) {
        final Importer importer = new Importer(eclProjects, destination, extraPanels);
        final ProgressPanel progressPanel = new ProgressPanel();
        DialogDescriptor desc = new DialogDescriptor((Object)progressPanel, NbBundle.getMessage(ImportProjectAction.class, (String)"CTL_ProgressDialogTitle"), true, new Object[0], null, 0, null, null);
        desc.setClosingOptions(new Object[0]);
        final Dialog progressDialog = DialogDisplayer.getDefault().createDialog(desc);
        ((JDialog)progressDialog).setDefaultCloseOperation(2);
        progressPanel.start(numberOfImportedProject);
        final Timer progressTimer = new Timer(250, null);
        progressTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                progressPanel.setProgress(importer.getNOfProcessed(), importer.getProgressInfo());
                if (importer.isDone()) {
                    progressTimer.stop();
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                    if (importProblems != null) {
                        importProblems.addAll(importer.getWarnings());
                    }
                    if (showReport) {
                        ImportProblemsPanel.showReport(NbBundle.getMessage(ImportProjectAction.class, (String)"MSG_ImportIssues"), importer.getWarnings());
                    }
                    if (importer.getProjects().length > 0) {
                        if (createdProjects != null) {
                            createdProjects.addAll(Arrays.asList(importer.getProjects()));
                        }
                        if (openProjects) {
                            OpenProjects.getDefault().open(importer.getProjects(), true);
                        }
                    }
                }
            }
        });
        importer.startImporting();
        progressTimer.start();
        progressDialog.setVisible(true);
    }
}

