/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.packets.ContextGetCommand;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.w3c.dom.Node;

public class ContextGetResponse
extends DbgpResponse {
    public ContextGetResponse(Node node) {
        super(node);
    }

    public int getContextId() {
        String id = ContextGetResponse.getAttribute(this.getNode(), "context");
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public List<Property> getProperties() {
        List<Node> nodes = ContextGetResponse.getChildren(this.getNode(), "property");
        ArrayList<Property> result = new ArrayList<Property>(nodes.size());
        for (Node node : nodes) {
            result.add(new Property(node));
        }
        return result;
    }

    @Override
    public void process(DebugSession session, DbgpCommand command) {
        if (!(command instanceof ContextGetCommand)) {
            return;
        }
        ContextGetCommand getCommand = (ContextGetCommand)command;
        ContextNamesResponse.Context ctx = getCommand.getContext();
        VariablesModel.ContextNode node = new VariablesModel.ContextNode(ctx, this.getProperties());
        DebugSession currentSession = SessionManager.getInstance().getSession(session.getSessionId());
        if (currentSession == session) {
            session.getBridge().getVariablesModel().updateContext(node);
        }
    }
}

