/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.breakpoints;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpointImpl;

public abstract class BaseComponentBreakpointImpl
extends ComponentBreakpointImpl
implements PropertyChangeListener {
    protected ComponentBreakpoint cb;
    protected JPDADebugger debugger;

    public BaseComponentBreakpointImpl(ComponentBreakpoint cb, JPDADebugger debugger) {
        this.cb = cb;
        this.debugger = debugger;
        this.initServiceBreakpoints();
        cb.addPropertyChangeListener(this);
    }

    protected abstract void initServiceBreakpoints();

    protected final void addMethodBreakpoint(MethodBreakpoint mb, ObjectVariable variableComponent) {
        mb.setHidden(true);
        mb.setInstanceFilters(this.debugger, new ObjectVariable[]{variableComponent});
        mb.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent event) {
                BaseComponentBreakpointImpl.this.navigateToCustomCode(event.getThread());
            }
        });
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        this.serviceBreakpoints.add(mb);
    }

    protected final void navigateToCustomCode(JPDAThread thread) {
        CallStackFrame callStackFrame = null;
        try {
            CallStackFrame[] callStack;
            for (CallStackFrame csf : callStack = thread.getCallStack()) {
                String cn = csf.getClassName();
                if (!JavaComponentInfo.isCustomType(cn)) continue;
                callStackFrame = csf;
                break;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        if (callStackFrame != null) {
            ((JPDAThreadImpl)thread).getDebugger().setPreferredTopFrame(callStackFrame);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("enabled".equals(propertyName)) {
            if (this.cb.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        } else if ("suspend".equals(propertyName)) {
            this.setSuspend(this.cb.getSuspend());
        } else if ("type".equals(propertyName)) {
            this.notifyRemoved();
            this.initServiceBreakpoints();
        }
    }
}

