/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ObjectFunctionBuiltins.class)
public final class ObjectFunctionBuiltinsFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectFromEntriesNode.class)
    public static final class ObjectFromEntriesNodeGen
    extends ObjectFunctionBuiltins.ObjectFromEntriesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectFromEntriesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.entries(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "entries";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectFromEntriesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectFromEntriesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectValuesOrEntriesNode.class)
    public static final class ObjectValuesOrEntriesNodeGen
    extends ObjectFunctionBuiltins.ObjectValuesOrEntriesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile valuesOrEntriesJSObject_lengthZero_;
        @Node.Child
        private EnumerableOwnPropertyNamesForeign0Data enumerableOwnPropertyNamesForeign0_cache;
        @Node.Child
        private EnumerableOwnPropertyNamesForeign1Data enumerableOwnPropertyNamesForeign1_cache;
        @Node.Child
        private ObjectFunctionBuiltins.ObjectValuesOrEntriesNode valuesOrEntriesGeneric_recursive_;

        private ObjectValuesOrEntriesNodeGen(JSContext context, JSBuiltin builtin, boolean entries, JavaScriptNode[] arguments) {
            super(context, builtin, entries);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected DynamicObject executeEvaluated(Object arguments0Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                return this.valuesOrEntriesJSObject(arguments0Value_, this.valuesOrEntriesJSObject_lengthZero_);
            }
            if ((state & 0xE) != 0) {
                EnumerableOwnPropertyNamesForeign1Data s3_;
                if ((state & 2) != 0) {
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value)) {
                            return this.enumerableOwnPropertyNamesForeign(arguments0Value, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0 && (s3_ = this.enumerableOwnPropertyNamesForeign1_cache) != null && JSGuards.isForeignObject(arguments0Value)) {
                    return this.enumerableOwnPropertyNamesForeign1Boundary(state, s3_, arguments0Value);
                }
                if ((state & 8) != 0 && !JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    return this.valuesOrEntriesGeneric(arguments0Value, this.valuesOrEntriesGeneric_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private DynamicObject enumerableOwnPropertyNamesForeign1Boundary(int state, EnumerableOwnPropertyNamesForeign1Data s3_, Object arguments0Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value), s3_.members_, s3_.importValue_, s3_.growProfile_);
                return dynamicObject;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.valuesOrEntriesJSObject(arguments0Value__, this.valuesOrEntriesJSObject_lengthZero_);
            }
            if ((state & 0xE) != 0) {
                EnumerableOwnPropertyNamesForeign1Data s3_;
                if ((state & 2) != 0) {
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            return this.enumerableOwnPropertyNamesForeign(arguments0Value_, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0 && (s3_ = this.enumerableOwnPropertyNamesForeign1_cache) != null && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.enumerableOwnPropertyNamesForeign1Boundary0(state, s3_, arguments0Value_);
                }
                if ((state & 8) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                    return this.valuesOrEntriesGeneric(arguments0Value_, this.valuesOrEntriesGeneric_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object enumerableOwnPropertyNamesForeign1Boundary0(int state, EnumerableOwnPropertyNamesForeign1Data s3_, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_), s3_.members_, s3_.importValue_, s3_.growProfile_);
                return dynamicObject;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.valuesOrEntriesJSObject_lengthZero_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valuesOrEntriesJSObject(arguments0Value_, this.valuesOrEntriesJSObject_lengthZero_);
                    return dynamicObject;
                }
                if (exclude == 0) {
                    int count2_ = 0;
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    if ((state & 2) != 0) {
                        while (!(s2_ == null || s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && JSGuards.isForeignObject(arguments0Value) && count2_ < 3) {
                        s2_ = (EnumerableOwnPropertyNamesForeign0Data)super.insert((Node)new EnumerableOwnPropertyNamesForeign0Data(this.enumerableOwnPropertyNamesForeign0_cache));
                        s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s2_.members_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                        s2_.importValue_ = s2_.insertAccessor(JSForeignToJSTypeNode.create());
                        s2_.growProfile_ = BranchProfile.create();
                        this.enumerableOwnPropertyNamesForeign0_cache = s2_;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_);
                        return dynamicObject;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        EnumerableOwnPropertyNamesForeign1Data s3_ = (EnumerableOwnPropertyNamesForeign1Data)super.insert((Node)new EnumerableOwnPropertyNamesForeign1Data());
                        s3_.members_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                        s3_.importValue_ = s3_.insertAccessor(JSForeignToJSTypeNode.create());
                        s3_.growProfile_ = BranchProfile.create();
                        this.enumerableOwnPropertyNamesForeign1_cache = s3_;
                        this.exclude_ = exclude |= 1;
                        this.enumerableOwnPropertyNamesForeign0_cache = null;
                        state &= 0xFFFFFFFD;
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value), s3_.members_, s3_.importValue_, s3_.growProfile_);
                        return dynamicObject;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    this.valuesOrEntriesGeneric_recursive_ = (ObjectFunctionBuiltins.ObjectValuesOrEntriesNode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valuesOrEntriesGeneric(arguments0Value, this.valuesOrEntriesGeneric_recursive_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            EnumerableOwnPropertyNamesForeign0Data s2_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s2_ = this.enumerableOwnPropertyNamesForeign0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "valuesOrEntriesJSObject";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.valuesOrEntriesJSObject_lengthZero_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "enumerableOwnPropertyNamesForeign";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_}));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "enumerableOwnPropertyNamesForeign";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                EnumerableOwnPropertyNamesForeign1Data s3_ = this.enumerableOwnPropertyNamesForeign1_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{INTEROP_LIBRARY_.getUncached(), s3_.members_, s3_.importValue_, s3_.growProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "valuesOrEntriesGeneric";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.valuesOrEntriesGeneric_recursive_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectValuesOrEntriesNode create(JSContext context, JSBuiltin builtin, boolean entries, JavaScriptNode[] arguments) {
            return new ObjectValuesOrEntriesNodeGen(context, builtin, entries, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectValuesOrEntriesNode.class)
        private static final class EnumerableOwnPropertyNamesForeign1Data
        extends Node {
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            JSForeignToJSTypeNode importValue_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;

            EnumerableOwnPropertyNamesForeign1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectValuesOrEntriesNode.class)
        private static final class EnumerableOwnPropertyNamesForeign0Data
        extends Node {
            @Node.Child
            EnumerableOwnPropertyNamesForeign0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            JSForeignToJSTypeNode importValue_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;

            EnumerableOwnPropertyNamesForeign0Data(EnumerableOwnPropertyNamesForeign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectAssignNode.class)
    public static final class ObjectAssignNodeGen
    extends ObjectFunctionBuiltins.ObjectAssignNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private AssignData assign_cache;

        private ObjectAssignNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                AssignData s1_ = this.assign_cache;
                if (s1_ != null) {
                    return this.assign(arguments0Value_, arguments1Value__, s1_.read_, s1_.write_, s1_.getOwnProperty_, s1_.listProfile_, s1_.elementProfile_, s1_.classProfile_, s1_.notAJSObjectBranch_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    AssignData s1_ = (AssignData)super.insert((Node)new AssignData());
                    s1_.read_ = s1_.insertAccessor(ReadElementNode.create(this.getContext()));
                    s1_.write_ = s1_.insertAccessor(WriteElementNode.create(this.getContext(), true));
                    s1_.getOwnProperty_ = s1_.insertAccessor(JSGetOwnPropertyNode.create());
                    s1_.listProfile_ = BranchProfile.create();
                    s1_.elementProfile_ = BranchProfile.create();
                    s1_.classProfile_ = JSClassProfile.create();
                    s1_.notAJSObjectBranch_ = BranchProfile.create();
                    this.assign_cache = s1_;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.assign(arguments0Value, arguments1Value_, s1_.read_, s1_.write_, s1_.getOwnProperty_, s1_.listProfile_, s1_.elementProfile_, s1_.classProfile_, s1_.notAJSObjectBranch_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "assign";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                AssignData s1_ = this.assign_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.read_, s1_.write_, s1_.getOwnProperty_, s1_.listProfile_, s1_.elementProfile_, s1_.classProfile_, s1_.notAJSObjectBranch_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectAssignNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectAssignNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectAssignNode.class)
        private static final class AssignData
        extends Node {
            @Node.Child
            ReadElementNode read_;
            @Node.Child
            WriteElementNode write_;
            @Node.Child
            JSGetOwnPropertyNode getOwnProperty_;
            @CompilerDirectives.CompilationFinal
            BranchProfile listProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile elementProfile_;
            @CompilerDirectives.CompilationFinal
            JSClassProfile classProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile notAJSObjectBranch_;

            AssignData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectIsNode.class)
    public static final class ObjectIsNodeGen
    extends ObjectFunctionBuiltins.ObjectIsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSIdenticalNode isNumberNumber_doIdenticalNode_;
        @Node.Child
        private JSIdenticalNode isObject_doIdenticalNode_;

        private ObjectIsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xE) == 0 && (state & 0xF) != 0) {
                return this.execute_int_int0(frameValue, state);
            }
            if ((state & 0xD) == 0 && (state & 0xF) != 0) {
                return this.execute_double_double1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isInt(arguments0Value_, arguments1Value_);
        }

        private Object execute_double_double1(VirtualFrame frameValue, int state) {
            double arguments1Value_;
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0xE0) == 0 && (state & 0xF) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0xD0) == 0 && (state & 0xF) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0xB0) == 0 && (state & 0xF) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0xF0) >>> 4, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_int = 0;
            long arguments1Value_long = 0L;
            try {
                if ((state & 0xE00) == 0 && (state & 0xF) != 0) {
                    arguments1Value_long = this.arguments1_.executeLong(frameValue);
                    arguments1Value_ = JSTypes.longToDouble(arguments1Value_long);
                } else if ((state & 0xD00) == 0 && (state & 0xF) != 0) {
                    arguments1Value_int = this.arguments1_.executeInt(frameValue);
                    arguments1Value_ = JSTypes.intToDouble(arguments1Value_int);
                } else if ((state & 0xB00) == 0 && (state & 0xF) != 0) {
                    arguments1Value_ = this.arguments1_.executeDouble(frameValue);
                } else {
                    Object arguments1Value__ = this.arguments1_.execute(frameValue);
                    arguments1Value_ = JSTypesGen.expectImplicitDouble((state & 0xF00) >>> 8, arguments1Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize((state & 0xE0) == 0 && (state & 0xF) != 0 ? (Number)arguments0Value_long : (Number)((state & 0xD0) == 0 && (state & 0xF) != 0 ? (Number)arguments0Value_int : (Number)arguments0Value_), ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isDouble(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.isInt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitDouble((state & 0xF00) >>> 8, arguments1Value_)) {
                    double arguments1Value__ = JSTypesGen.asImplicitDouble((state & 0xF00) >>> 8, arguments1Value_);
                    return this.isDouble(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 4) != 0 && arguments0Value_ instanceof Number) {
                Number arguments1Value__;
                Number arguments0Value__ = (Number)arguments0Value_;
                if (arguments1Value_ instanceof Number && this.isNumberNumber(arguments0Value__, arguments1Value__ = (Number)arguments1Value_)) {
                    return this.isNumberNumber(arguments0Value__, arguments1Value__, this.isNumberNumber_doIdenticalNode_);
                }
            }
            if ((state & 8) != 0 && !this.isNumberNumber(arguments0Value_, arguments1Value_)) {
                return this.isObject(arguments0Value_, arguments1Value_, this.isObject_doIdenticalNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xE) == 0 && (state & 0xF) != 0) {
                return this.executeBoolean_int_int3(frameValue, state);
            }
            if ((state & 0xD) == 0 && (state & 0xF) != 0) {
                return this.executeBoolean_double_double4(frameValue, state);
            }
            return this.executeBoolean_generic5(frameValue, state);
        }

        private boolean executeBoolean_int_int3(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.isInt(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_double_double4(VirtualFrame frameValue, int state) {
            double arguments1Value_;
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state & 0xE0) == 0 && (state & 0xF) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state & 0xD0) == 0 && (state & 0xF) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state & 0xB0) == 0 && (state & 0xF) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0xF0) >>> 4, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_int = 0;
            long arguments1Value_long = 0L;
            try {
                if ((state & 0xE00) == 0 && (state & 0xF) != 0) {
                    arguments1Value_long = this.arguments1_.executeLong(frameValue);
                    arguments1Value_ = JSTypes.longToDouble(arguments1Value_long);
                } else if ((state & 0xD00) == 0 && (state & 0xF) != 0) {
                    arguments1Value_int = this.arguments1_.executeInt(frameValue);
                    arguments1Value_ = JSTypes.intToDouble(arguments1Value_int);
                } else if ((state & 0xB00) == 0 && (state & 0xF) != 0) {
                    arguments1Value_ = this.arguments1_.executeDouble(frameValue);
                } else {
                    Object arguments1Value__ = this.arguments1_.execute(frameValue);
                    arguments1Value_ = JSTypesGen.expectImplicitDouble((state & 0xF00) >>> 8, arguments1Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize((state & 0xE0) == 0 && (state & 0xF) != 0 ? (Number)arguments0Value_long : (Number)((state & 0xD0) == 0 && (state & 0xF) != 0 ? (Number)arguments0Value_int : (Number)arguments0Value_), ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.isDouble(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.isInt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitDouble((state & 0xF00) >>> 8, arguments1Value_)) {
                    double arguments1Value__ = JSTypesGen.asImplicitDouble((state & 0xF00) >>> 8, arguments1Value_);
                    return this.isDouble(arguments0Value__, arguments1Value__);
                }
            }
            if ((state & 4) != 0 && arguments0Value_ instanceof Number) {
                Number arguments1Value__;
                Number arguments0Value__ = (Number)arguments0Value_;
                if (arguments1Value_ instanceof Number && this.isNumberNumber(arguments0Value__, arguments1Value__ = (Number)arguments1Value_)) {
                    return this.isNumberNumber(arguments0Value__, arguments1Value__, this.isNumberNumber_doIdenticalNode_);
                }
            }
            if ((state & 8) != 0 && !this.isNumberNumber(arguments0Value_, arguments1Value_)) {
                return this.isObject(arguments0Value_, arguments1Value_, this.isObject_doIdenticalNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                int doubleCast0;
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (Integer)arguments0Value;
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.isInt(arguments0Value_, arguments1Value_);
                        return bl;
                    }
                }
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                    double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                    int doubleCast1 = JSTypesGen.specializeImplicitDouble(arguments1Value);
                    if (doubleCast1 != 0) {
                        double arguments1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arguments1Value);
                        state |= doubleCast0 << 4;
                        state |= doubleCast1 << 8;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.isDouble(arguments0Value_, arguments1Value_);
                        return bl;
                    }
                }
                if (arguments0Value instanceof Number) {
                    Number arguments1Value_;
                    Number arguments0Value_ = (Number)arguments0Value;
                    if (arguments1Value instanceof Number && this.isNumberNumber(arguments0Value_, arguments1Value_ = (Number)arguments1Value)) {
                        this.isNumberNumber_doIdenticalNode_ = (JSIdenticalNode)super.insert((Node)JSIdenticalNode.createSameValue());
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.isNumberNumber(arguments0Value_, arguments1Value_, this.isNumberNumber_doIdenticalNode_);
                        return bl;
                    }
                }
                if (!this.isNumberNumber(arguments0Value, arguments1Value)) {
                    this.isObject_doIdenticalNode_ = (JSIdenticalNode)super.insert((Node)JSIdenticalNode.createSameValue());
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.isObject(arguments0Value, arguments1Value, this.isObject_doIdenticalNode_);
                    return bl;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 0xF & (state & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSIdenticalNode>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "isInt";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isDouble";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "isNumberNumber";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSIdenticalNode>>();
                cached.add(Arrays.asList(this.isNumberNumber_doIdenticalNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isObject";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isObject_doIdenticalNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectIsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectIsNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectSetPrototypeOfNode.class)
    public static final class ObjectSetPrototypeOfNodeGen
    extends ObjectFunctionBuiltins.ObjectSetPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ObjectSetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if ((state & 1) != 0 && JSGuards.isJSObject(arguments1Value__)) {
                        return this.setPrototypeOf(arguments0Value_, arguments1Value__);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSNull(arguments1Value__)) {
                        return this.setPrototypeOfNull(arguments0Value_, arguments1Value__);
                    }
                }
                if ((state & 4) != 0 && !JSGuards.isJSObject(arguments1Value_) && !JSGuards.isJSNull(arguments1Value_)) {
                    return this.setPrototypeOfInvalidNewProto(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments1Value)) {
                DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                if (JSGuards.isJSObject(arguments1Value_)) {
                    this.state_ = state |= 1;
                    return this.setPrototypeOf(arguments0Value, arguments1Value_);
                }
                if (JSGuards.isJSNull(arguments1Value_)) {
                    this.state_ = state |= 2;
                    return this.setPrototypeOfNull(arguments0Value, arguments1Value_);
                }
            }
            if (!JSGuards.isJSObject(arguments1Value) && !JSGuards.isJSNull(arguments1Value)) {
                this.state_ = state |= 4;
                return this.setPrototypeOfInvalidNewProto(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "setPrototypeOf";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfNull";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfInvalidNewProto";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectSetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectSetPrototypeOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectKeysNode.class)
    public static final class ObjectKeysNodeGen
    extends ObjectFunctionBuiltins.ObjectKeysNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private Keys5Data keys5_cache;
        @Node.Child
        private InteropLibrary keys6_members_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile keys6_growProfile_;

        private ObjectKeysNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSType(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.keysDynamicObject((DynamicObject)arguments0Value__);
            }
            if ((state & 2) != 0 && arguments0Value_ instanceof Symbol) {
                arguments0Value__ = (Symbol)arguments0Value_;
                return this.keys((Symbol)arguments0Value__);
            }
            if ((state & 4) != 0 && arguments0Value_ instanceof JSLazyString) {
                arguments0Value__ = (JSLazyString)arguments0Value_;
                return this.keys((JSLazyString)arguments0Value__);
            }
            if ((state & 8) != 0 && arguments0Value_ instanceof LargeInteger) {
                arguments0Value__ = (LargeInteger)arguments0Value_;
                return this.keys((LargeInteger)arguments0Value__);
            }
            if ((state & 0x10) != 0 && arguments0Value_ instanceof BigInt) {
                arguments0Value__ = (BigInt)arguments0Value_;
                return this.keys((BigInt)arguments0Value__);
            }
            if ((state & 0xE0) != 0) {
                if ((state & 0x20) != 0 && !JSGuards.isTruffleObject(arguments0Value_)) {
                    return this.keys(arguments0Value_);
                }
                if ((state & 0x40) != 0) {
                    Keys5Data s7_ = this.keys5_cache;
                    while (s7_ != null) {
                        if (s7_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            return this.keys(arguments0Value_, s7_.interop_, s7_.members_, s7_.growProfile_);
                        }
                        s7_ = s7_.next_;
                    }
                }
                if ((state & 0x80) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.keys6Boundary(state, arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object keys6Boundary(int state, Object arguments0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                DynamicObject dynamicObject = this.keys(arguments0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_), this.keys6_members_, this.keys6_growProfile_);
                return dynamicObject;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                Object arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSType(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keysDynamicObject((DynamicObject)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof Symbol) {
                    arguments0Value_ = (Symbol)arguments0Value;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keys((Symbol)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof JSLazyString) {
                    arguments0Value_ = (JSLazyString)arguments0Value;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keys((JSLazyString)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof LargeInteger) {
                    arguments0Value_ = (LargeInteger)arguments0Value;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keys((LargeInteger)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof BigInt) {
                    arguments0Value_ = (BigInt)arguments0Value;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keys((BigInt)arguments0Value_);
                    return dynamicObject;
                }
                if (!JSGuards.isTruffleObject(arguments0Value)) {
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.keys(arguments0Value);
                    return arguments0Value_;
                }
                if (exclude == 0) {
                    int count7_ = 0;
                    Keys5Data s7_ = this.keys5_cache;
                    if ((state & 0x40) != 0) {
                        while (!(s7_ == null || s7_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s7_ = s7_.next_;
                            ++count7_;
                        }
                    }
                    if (s7_ == null && JSGuards.isForeignObject(arguments0Value) && count7_ < 3) {
                        s7_ = (Keys5Data)super.insert((Node)new Keys5Data(this.keys5_cache));
                        s7_.interop_ = (InteropLibrary)s7_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s7_.members_ = (InteropLibrary)s7_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                        s7_.growProfile_ = BranchProfile.create();
                        this.keys5_cache = s7_;
                        this.state_ = state |= 0x40;
                    }
                    if (s7_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.keys(arguments0Value, s7_.interop_, s7_.members_, s7_.growProfile_);
                        return dynamicObject;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        this.keys6_members_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3));
                        this.keys6_growProfile_ = BranchProfile.create();
                        this.exclude_ = exclude |= 1;
                        this.keys5_cache = null;
                        state &= 0xFFFFFFBF;
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.keys(arguments0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value), this.keys6_members_, this.keys6_growProfile_);
                        return dynamicObject;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Keys5Data s7_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s7_ = this.keys5_cache) == null || s7_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[9];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "keysDynamicObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "keys";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "keys";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "keys";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "keys";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "keys";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0x40) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                Keys5Data s7_ = this.keys5_cache;
                while (s7_ != null) {
                    cached.add(Arrays.asList(s7_.interop_, s7_.members_, s7_.growProfile_));
                    s7_ = s7_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "keys";
            if ((state & 0x80) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), this.keys6_members_, this.keys6_growProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[8] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectKeysNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectKeysNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectKeysNode.class)
        private static final class Keys5Data
        extends Node {
            @Node.Child
            Keys5Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;

            Keys5Data(Keys5Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode.class)
    public static final class ObjectSetIntegrityLevelNodeGen
    extends ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectSetIntegrityLevelNodeGen(JSContext context, JSBuiltin builtin, boolean freeze, JavaScriptNode[] arguments) {
            super(context, builtin, freeze);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.setIntegrityLevel(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "setIntegrityLevel";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode create(JSContext context, JSBuiltin builtin, boolean freeze, JavaScriptNode[] arguments) {
            return new ObjectSetIntegrityLevelNodeGen(context, builtin, freeze, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode.class)
    public static final class ObjectTestIntegrityLevelNodeGen
    extends ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectTestIntegrityLevelNodeGen(JSContext context, JSBuiltin builtin, boolean frozen, JavaScriptNode[] arguments) {
            super(context, builtin, frozen);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.testIntegrityLevel(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.testIntegrityLevel(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "testIntegrityLevel";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode create(JSContext context, JSBuiltin builtin, boolean frozen, JavaScriptNode[] arguments) {
            return new ObjectTestIntegrityLevelNodeGen(context, builtin, frozen, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectPreventExtensionsNode.class)
    public static final class ObjectPreventExtensionsNodeGen
    extends ObjectFunctionBuiltins.ObjectPreventExtensionsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ObjectPreventExtensionsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.preventExtensions(arguments0Value__);
            }
            if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.preventExtensions(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.preventExtensions(arguments0Value_);
            }
            if (!JSGuards.isJSObject(arguments0Value)) {
                this.state_ = state |= 2;
                return this.preventExtensions(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "preventExtensions";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "preventExtensions";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectPreventExtensionsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPreventExtensionsNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectIsExtensibleNode.class)
    public static final class ObjectIsExtensibleNodeGen
    extends ObjectFunctionBuiltins.ObjectIsExtensibleNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private IsExtensibleNode isExtensible0_isExtensibleNode_;

        private ObjectIsExtensibleNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.isExtensible(arguments0Value__, this.isExtensible0_isExtensibleNode_);
            }
            if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.isExtensible(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.isExtensible(arguments0Value__, this.isExtensible0_isExtensibleNode_);
            }
            if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.isExtensible(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.isExtensible0_isExtensibleNode_ = (IsExtensibleNode)super.insert((Node)IsExtensibleNode.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.isExtensible(arguments0Value_, this.isExtensible0_isExtensibleNode_);
                    return bl;
                }
                if (!JSGuards.isJSObject(arguments0Value)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.isExtensible(arguments0Value);
                    return bl;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "isExtensible";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<IsExtensibleNode>> cached = new ArrayList<List<IsExtensibleNode>>();
                cached.add(Arrays.asList(this.isExtensible0_isExtensibleNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isExtensible";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectIsExtensibleNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectIsExtensibleNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectDefinePropertiesNode.class)
    public static final class ObjectDefinePropertiesNodeGen
    extends ObjectFunctionBuiltins.ObjectDefinePropertiesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private ObjectDefinePropertiesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.defineProperties(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "defineProperties";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectDefinePropertiesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectDefinePropertiesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectDefinePropertyNode.class)
    public static final class ObjectDefinePropertyNodeGen
    extends ObjectFunctionBuiltins.ObjectDefinePropertyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;

        private ObjectDefinePropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return this.defineProperty(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "defineProperty";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectDefinePropertyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectDefinePropertyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectCreateNode.class)
    public static final class ObjectCreateNodeGen
    extends ObjectFunctionBuiltins.ObjectCreateNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ObjectCreateNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 3) != 0) {
                if ((state & 1) != 0 && JSGuards.isJSNull(arguments0Value_)) {
                    return this.createPrototypeNull(arguments0Value_, arguments1Value_);
                }
                if ((state & 2) != 0 && !JSGuards.isJSNull(arguments0Value_) && !JSGuards.isJSObject(arguments0Value_)) {
                    return this.createInvalidPrototype(arguments0Value_, arguments1Value_);
                }
            }
            if ((state & 0x1C) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 4) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return this.create(frameValue, arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 0x18) != 0) {
                    if ((state & 8) != 0 && JSGuards.isJSObject(arguments0Value__) && !JSGuards.isJSNull(arguments1Value_)) {
                        return this.create(frameValue, arguments0Value__, arguments1Value_);
                    }
                    if ((state & 0x10) != 0 && JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSNull(arguments1Value_)) {
                        return this.createNull(arguments0Value__, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSGuards.isJSNull(arguments0Value)) {
                this.state_ = state |= 1;
                return this.createPrototypeNull(arguments0Value, arguments1Value);
            }
            if (!JSGuards.isJSNull(arguments0Value) && !JSGuards.isJSObject(arguments0Value)) {
                this.state_ = state |= 2;
                return this.createInvalidPrototype(arguments0Value, arguments1Value);
            }
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (JSTypes.isDynamicObject(arguments1Value)) {
                    DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                    if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                        this.state_ = state |= 4;
                        return this.create(frameValue, arguments0Value_, arguments1Value_);
                    }
                }
                if (JSGuards.isJSObject(arguments0Value_) && !JSGuards.isJSNull(arguments1Value)) {
                    this.state_ = state |= 8;
                    return this.create(frameValue, arguments0Value_, arguments1Value);
                }
                if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSNull(arguments1Value)) {
                    this.state_ = state |= 0x10;
                    return this.createNull(arguments0Value_, arguments1Value);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "createPrototypeNull";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "createInvalidPrototype";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "create";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "create";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "createNull";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectCreateNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectCreateNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode.class)
    public static final class ObjectGetOwnPropertyNamesOrSymbolsNodeGen
    extends ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private JSClassProfile jsclassProfile;
        @Node.Child
        private GetForeignObjectNames0Data getForeignObjectNames0_cache;
        @Node.Child
        private InteropLibrary getForeignObjectNames1_members_;

        private ObjectGetOwnPropertyNamesOrSymbolsNodeGen(JSContext context, JSBuiltin builtin, boolean symbols, JavaScriptNode[] arguments) {
            super(context, builtin, symbols);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.getJSObject(arguments0Value__, this.jsclassProfile);
            }
            if ((state & 2) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                return this.getDefault(arguments0Value_, this.jsclassProfile);
            }
            if ((state & 0x1C) != 0 && arguments0Value_ instanceof TruffleObject) {
                arguments0Value__ = (TruffleObject)arguments0Value_;
                if ((state & 4) != 0 && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                    assert (this.symbols);
                    return this.getForeignObjectSymbols((TruffleObject)arguments0Value__);
                }
                if ((state & 8) != 0) {
                    GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                    while (s4_ != null) {
                        if (s4_.interop_.accepts((Object)arguments0Value__) && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                            assert (!this.symbols);
                            return this.getForeignObjectNames((TruffleObject)arguments0Value__, s4_.interop_, s4_.members_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0x10) != 0 && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                    assert (!this.symbols);
                    return this.getForeignObjectNames1Boundary(state, (TruffleObject)arguments0Value__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getForeignObjectNames1Boundary(int state, TruffleObject arguments0Value__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                DynamicObject dynamicObject = this.getForeignObjectNames(arguments0Value__, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arguments0Value__), this.getForeignObjectNames1_members_);
                return dynamicObject;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    if (this.jsclassProfile == null) {
                        this.jsclassProfile = JSClassProfile.create();
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getJSObject(arguments0Value_, this.jsclassProfile);
                    return dynamicObject;
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    if (this.jsclassProfile == null) {
                        this.jsclassProfile = JSClassProfile.create();
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.getDefault(arguments0Value, this.jsclassProfile);
                    return arguments0Value_;
                }
                if (arguments0Value instanceof TruffleObject) {
                    arguments0Value_ = (TruffleObject)arguments0Value;
                    if (JSGuards.isForeignObject((TruffleObject)arguments0Value_) && this.symbols) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObjectSymbols((TruffleObject)arguments0Value_);
                        return dynamicObject;
                    }
                    if (exclude == 0) {
                        int count4_ = 0;
                        GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                        if ((state & 8) != 0) {
                            while (s4_ != null) {
                                if (s4_.interop_.accepts((Object)arguments0Value_) && JSGuards.isForeignObject((TruffleObject)arguments0Value_)) {
                                    assert (!this.symbols);
                                    break;
                                }
                                s4_ = s4_.next_;
                                ++count4_;
                            }
                        }
                        if (s4_ == null && JSGuards.isForeignObject((TruffleObject)arguments0Value_) && !this.symbols && count4_ < 3) {
                            s4_ = (GetForeignObjectNames0Data)super.insert((Node)new GetForeignObjectNames0Data(this.getForeignObjectNames0_cache));
                            s4_.interop_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.create((Object)arguments0Value_));
                            s4_.members_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                            this.getForeignObjectNames0_cache = s4_;
                            this.state_ = state |= 8;
                        }
                        if (s4_ != null) {
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.getForeignObjectNames((TruffleObject)arguments0Value_, s4_.interop_, s4_.members_);
                            return dynamicObject;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (JSGuards.isForeignObject((TruffleObject)arguments0Value_) && !this.symbols) {
                            this.getForeignObjectNames1_members_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3));
                            this.exclude_ = exclude |= 1;
                            this.getForeignObjectNames0_cache = null;
                            state &= 0xFFFFFFF7;
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.getForeignObjectNames((TruffleObject)arguments0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arguments0Value_), this.getForeignObjectNames1_members_);
                            return dynamicObject;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetForeignObjectNames0Data s4_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s4_ = this.getForeignObjectNames0_cache) == null || s4_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSClassProfile>> cached;
            Object[] data = new Object[6];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "getJSObject";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSClassProfile>>();
                cached.add(Arrays.asList(this.jsclassProfile));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getDefault";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.jsclassProfile));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObjectSymbols";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "getForeignObjectNames";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                while (s4_ != null) {
                    cached.add(Arrays.asList(s4_.interop_, s4_.members_));
                    s4_ = s4_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "getForeignObjectNames";
            if ((state & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList((InteropLibrary)INTEROP_LIBRARY_.getUncached(), this.getForeignObjectNames1_members_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode create(JSContext context, JSBuiltin builtin, boolean symbols, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyNamesOrSymbolsNodeGen(context, builtin, symbols, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode.class)
        private static final class GetForeignObjectNames0Data
        extends Node {
            @Node.Child
            GetForeignObjectNames0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;

            GetForeignObjectNames0Data(GetForeignObjectNames0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode.class)
    public static final class ObjectGetOwnPropertyDescriptorsNodeGen
    extends ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private GetForeignObject0Data getForeignObject0_cache;
        @Node.Child
        private InteropLibrary getForeignObject1_members_;
        @Node.Child
        private JSForeignToJSTypeNode getForeignObject1_toJSType_;

        private ObjectGetOwnPropertyDescriptorsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.getJSObject(arguments0Value__);
            }
            if ((state & 6) != 0 && arguments0Value_ instanceof TruffleObject) {
                arguments0Value__ = (TruffleObject)arguments0Value_;
                if ((state & 2) != 0) {
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts((Object)arguments0Value__) && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                            return this.getForeignObject((TruffleObject)arguments0Value__, s2_.interop_, s2_.members_, s2_.toJSType_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0 && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                    return this.getForeignObject1Boundary(state, (TruffleObject)arguments0Value__);
                }
            }
            if ((state & 8) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                return this.getDefault(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getForeignObject1Boundary(int state, TruffleObject arguments0Value__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                DynamicObject dynamicObject = this.getForeignObject(arguments0Value__, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arguments0Value__), this.getForeignObject1_members_, this.getForeignObject1_toJSType_);
                return dynamicObject;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getJSObject(arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof TruffleObject) {
                    arguments0Value_ = (TruffleObject)arguments0Value;
                    if (exclude == 0) {
                        int count2_ = 0;
                        GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                        if ((state & 2) != 0) {
                            while (!(s2_ == null || s2_.interop_.accepts((Object)arguments0Value_) && JSGuards.isForeignObject((TruffleObject)arguments0Value_))) {
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && JSGuards.isForeignObject((TruffleObject)arguments0Value_) && count2_ < 3) {
                            s2_ = (GetForeignObject0Data)super.insert((Node)new GetForeignObject0Data(this.getForeignObject0_cache));
                            s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create((Object)arguments0Value_));
                            s2_.members_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                            s2_.toJSType_ = s2_.insertAccessor(JSForeignToJSTypeNode.create());
                            this.getForeignObject0_cache = s2_;
                            this.state_ = state |= 2;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.getForeignObject((TruffleObject)arguments0Value_, s2_.interop_, s2_.members_, s2_.toJSType_);
                            return dynamicObject;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (JSGuards.isForeignObject((TruffleObject)arguments0Value_)) {
                            this.getForeignObject1_members_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3));
                            this.getForeignObject1_toJSType_ = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
                            this.exclude_ = exclude |= 1;
                            this.getForeignObject0_cache = null;
                            state &= 0xFFFFFFFD;
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.getForeignObject((TruffleObject)arguments0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arguments0Value_), this.getForeignObject1_members_, this.getForeignObject1_toJSType_);
                            return dynamicObject;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getDefault(arguments0Value);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetForeignObject0Data s2_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s2_ = this.getForeignObject0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Node>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "getJSObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Node>>();
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(new Node[]{s2_.interop_, s2_.members_, s2_.toJSType_}));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(new Node[]{INTEROP_LIBRARY_.getUncached(), this.getForeignObject1_members_, this.getForeignObject1_toJSType_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getDefault";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyDescriptorsNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode.class)
        private static final class GetForeignObject0Data
        extends Node {
            @Node.Child
            GetForeignObject0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            JSForeignToJSTypeNode toJSType_;

            GetForeignObject0Data(GetForeignObject0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode.class)
    public static final class ObjectGetOwnPropertyDescriptorNodeGen
    extends ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private GetForeignObject0Data getForeignObject0_cache;
        @Node.Child
        private JSForeignToJSTypeNode getForeignObject1_toJSType_;

        private ObjectGetOwnPropertyDescriptorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.getJSObject(arguments0Value__, arguments1Value_);
                }
                if ((state & 6) != 0 && arguments0Value_ instanceof TruffleObject) {
                    arguments0Value__ = (TruffleObject)arguments0Value_;
                    if ((state & 2) != 0) {
                        GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                        while (s2_ != null) {
                            if (s2_.interop_.accepts((Object)arguments0Value__) && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                                return this.getForeignObject((TruffleObject)arguments0Value__, arguments1Value_, s2_.interop_, s2_.toJSType_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0 && JSGuards.isForeignObject((TruffleObject)arguments0Value__)) {
                        return this.getForeignObject1Boundary(state, (TruffleObject)arguments0Value__, arguments1Value_);
                    }
                }
                if ((state & 8) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                    return this.getDefault(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getForeignObject1Boundary(int state, TruffleObject arguments0Value__, Object arguments1Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                DynamicObject dynamicObject = this.getForeignObject(arguments0Value__, arguments1Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arguments0Value__), this.getForeignObject1_toJSType_);
                return dynamicObject;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getJSObject(arguments0Value_, arguments1Value);
                    return dynamicObject;
                }
                if (arguments0Value instanceof TruffleObject) {
                    arguments0Value_ = (TruffleObject)arguments0Value;
                    if (exclude == 0) {
                        int count2_ = 0;
                        GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                        if ((state & 2) != 0) {
                            while (!(s2_ == null || s2_.interop_.accepts((Object)arguments0Value_) && JSGuards.isForeignObject((TruffleObject)arguments0Value_))) {
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && JSGuards.isForeignObject((TruffleObject)arguments0Value_) && count2_ < 3) {
                            s2_ = (GetForeignObject0Data)super.insert((Node)new GetForeignObject0Data(this.getForeignObject0_cache));
                            s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create((Object)arguments0Value_));
                            s2_.toJSType_ = s2_.insertAccessor(JSForeignToJSTypeNode.create());
                            this.getForeignObject0_cache = s2_;
                            this.state_ = state |= 2;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.getForeignObject((TruffleObject)arguments0Value_, arguments1Value, s2_.interop_, s2_.toJSType_);
                            return dynamicObject;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (JSGuards.isForeignObject((TruffleObject)arguments0Value_)) {
                            this.getForeignObject1_toJSType_ = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
                            this.exclude_ = exclude |= 1;
                            this.getForeignObject0_cache = null;
                            state &= 0xFFFFFFFD;
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.getForeignObject((TruffleObject)arguments0Value_, arguments1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arguments0Value_), this.getForeignObject1_toJSType_);
                            return dynamicObject;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getDefault(arguments0Value, arguments1Value);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetForeignObject0Data s2_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s2_ = this.getForeignObject0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Node>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "getJSObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Node>>();
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(new Node[]{s2_.interop_, s2_.toJSType_}));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(new Node[]{INTEROP_LIBRARY_.getUncached(), this.getForeignObject1_toJSType_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getDefault";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyDescriptorNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode.class)
        private static final class GetForeignObject0Data
        extends Node {
            @Node.Child
            GetForeignObject0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            JSForeignToJSTypeNode toJSType_;

            GetForeignObject0Data(GetForeignObject0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetPrototypeOfNode.class)
    public static final class ObjectGetPrototypeOfNodeGen
    extends ObjectFunctionBuiltins.ObjectGetPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private GetPrototypeNode getPrototypeOf1_getPrototypeNode_;

        private ObjectGetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.getPrototypeOf(arguments0Value_);
            }
            if ((state & 2) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.getPrototypeOf(arguments0Value__, this.getPrototypeOf1_getPrototypeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                DynamicObject arguments0Value_;
                if (!JSGuards.isJSObject(arguments0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getPrototypeOf(arguments0Value);
                    return dynamicObject;
                }
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.getPrototypeOf1_getPrototypeNode_ = (GetPrototypeNode)super.insert((Node)GetPrototypeNode.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getPrototypeOf(arguments0Value_, this.getPrototypeOf1_getPrototypeNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "getPrototypeOf";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "getPrototypeOf";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<GetPrototypeNode>> cached = new ArrayList<List<GetPrototypeNode>>();
                cached.add(Arrays.asList(this.getPrototypeOf1_getPrototypeNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetPrototypeOfNodeGen(context, builtin, arguments);
        }
    }
}

