/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class RegExpBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpBuiltin> {
    RegExpBuiltins() {
        super("RegExp", RegExpBuiltin.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpBuiltin builtinEnum) {
        switch (builtinEnum) {
            case input: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultInputNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case lastMatch: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetGroupNodeGen.create(context, builtin, 0, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case lastParen: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultLastParenNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case leftContext: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultLeftContextNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case rightContext: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultRightContextNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case multiline: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultMultilineNodeGen.create(context, builtin, RegExpBuiltins.args().createArgumentNodes(context));
            }
            case $1: 
            case $2: 
            case $3: 
            case $4: 
            case $5: 
            case $6: 
            case $7: 
            case $8: 
            case $9: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetGroupNodeGen.create(context, builtin, builtinEnum.name().charAt(1) - 48, RegExpBuiltins.args().createArgumentNodes(context));
            }
        }
        return null;
    }

    static abstract class JSRegExpStaticResultRightContextNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultRightContextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        String rightContext() {
            Object result = this.getResultNode.execute();
            if (this.resultAccessor.isMatch(result)) {
                int end = this.resultAccessor.captureGroupEnd(result, 0);
                return Boundaries.substring(this.getInput(), end);
            }
            return "";
        }
    }

    static abstract class JSRegExpStaticResultLeftContextNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultLeftContextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        String leftContext() {
            Object result = this.getResultNode.execute();
            if (this.resultAccessor.isMatch(result)) {
                int start = this.resultAccessor.captureGroupStart(result, 0);
                return Boundaries.substring(this.getInput(), 0, start);
            }
            return "";
        }
    }

    static abstract class JSRegExpStaticResultLastParenNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultLastParenNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        String lastParen() {
            int start;
            int groupNumber;
            Object result = this.getResultNode.execute();
            if (this.resultAccessor.isMatch(result) && (groupNumber = this.compiledRegexAccessor.groupCount(this.getContext().getRealm().getLazyStaticRegexResultCompiledRegex()) - 1) > 0 && (start = this.resultAccessor.captureGroupStart(result, groupNumber)) >= 0) {
                return Boundaries.substring(this.getInput(), start, this.resultAccessor.captureGroupEnd(result, groupNumber));
            }
            return "";
        }
    }

    static abstract class JSRegExpStaticResultGetGroupNode
    extends JSRegExpStaticResultPropertyNode {
        private final int groupNumber;

        JSRegExpStaticResultGetGroupNode(JSContext context, JSBuiltin builtin, int groupNumber) {
            super(context, builtin);
            assert (groupNumber >= 0);
            this.groupNumber = groupNumber;
        }

        @Specialization
        String getGroup() {
            int start;
            Object result = this.getResultNode.execute();
            if (this.resultAccessor.isMatch(result) && this.compiledRegexAccessor.groupCount(this.getContext().getRealm().getLazyStaticRegexResultCompiledRegex()) > this.groupNumber && (start = this.resultAccessor.captureGroupStart(result, this.groupNumber)) >= 0) {
                return Boundaries.substring(this.getInput(), start, this.resultAccessor.captureGroupEnd(result, this.groupNumber));
            }
            return "";
        }
    }

    static abstract class JSRegExpStaticResultPropertyNode
    extends JSBuiltinNode {
        @Node.Child
        GetStaticRegExpResultNode getResultNode;
        @Node.Child
        TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor;
        @Node.Child
        TRegexUtil.TRegexResultAccessor resultAccessor;

        JSRegExpStaticResultPropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getResultNode = GetStaticRegExpResultNode.create(context);
            this.compiledRegexAccessor = TRegexUtil.TRegexCompiledRegexAccessor.create();
            this.resultAccessor = TRegexUtil.TRegexResultAccessor.create();
        }

        String getInput() {
            return this.getContext().getRealm().getLazyStaticRegexResultInputString();
        }
    }

    static abstract class JSRegExpStaticResultMultilineNode
    extends JSBuiltinNode {
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexSingleFlagAccessor multilineAccessor = TRegexUtil.TRegexCompiledRegexSingleFlagAccessor.create("multiline");

        JSRegExpStaticResultMultilineNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(assumptions={"getStaticResultUnusedAssumption()"})
        boolean getMultilineLazy() {
            Object compiledRegex = this.getContext().getRealm().getLazyStaticRegexResultCompiledRegex();
            if (!JSTruffleOptions.NashornCompatibilityMode && compiledRegex != null) {
                return this.multilineAccessor.get(compiledRegex);
            }
            return false;
        }

        @Specialization
        boolean getMultilineEager(@Cached(value="createGetResultNode()") GetStaticRegExpResultNode getResultNode, @Cached(value="create()") TRegexUtil.TRegexResultAccessor resultAccessor) {
            Object compiledRegex = this.getContext().getRealm().getLazyStaticRegexResultCompiledRegex();
            Object result = getResultNode.execute();
            if (!JSTruffleOptions.NashornCompatibilityMode && resultAccessor.isMatch(result)) {
                return this.multilineAccessor.get(compiledRegex);
            }
            return false;
        }

        Assumption getStaticResultUnusedAssumption() {
            return this.getContext().getRegExpStaticResultUnusedAssumption();
        }

        GetStaticRegExpResultNode createGetResultNode() {
            return GetStaticRegExpResultNode.create(this.getContext());
        }
    }

    static abstract class JSRegExpStaticResultInputNode
    extends JSBuiltinNode {
        JSRegExpStaticResultInputNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        String getInputProp() {
            return this.getContext().getRealm().getLazyStaticRegexResultInputString();
        }
    }

    static abstract class GetStaticRegExpResultNode
    extends Node {
        private final JSContext context;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor = TRegexUtil.TRegexCompiledRegexAccessor.create();

        GetStaticRegExpResultNode(JSContext context) {
            this.context = context;
        }

        static GetStaticRegExpResultNode create(JSContext context) {
            return RegExpBuiltinsFactory.GetStaticRegExpResultNodeGen.create(context);
        }

        abstract Object execute();

        @Specialization
        Object get() {
            JSRealm realm = this.context.getRealm();
            Object compiledRegex = realm.getLazyStaticRegexResultCompiledRegex();
            String input = realm.getLazyStaticRegexResultInputString();
            long fromIndex = realm.getLazyStaticRegexResultFromIndex();
            if (compiledRegex != null && this.context.getRegExpStaticResultUnusedAssumption().isValid()) {
                this.context.getRegExpStaticResultUnusedAssumption().invalidate();
                Object result = this.compiledRegexAccessor.exec(compiledRegex, input, fromIndex);
                realm.setRegexResult(compiledRegex, input, result);
            }
            return realm.getRegexResult();
        }
    }

    public static enum RegExpBuiltin implements BuiltinEnum<RegExpBuiltin>
    {
        input,
        lastMatch,
        lastParen,
        leftContext,
        rightContext,
        multiline,
        $1,
        $2,
        $3,
        $4,
        $5,
        $6,
        $7,
        $8,
        $9;

        private final String key;

        private RegExpBuiltin() {
            this.key = "get " + this.name();
        }

        private RegExpBuiltin(String key) {
            this.key = "get " + key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public int getLength() {
            return 0;
        }
    }
}

