/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.lang;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JSFileTypeDetector;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.AbstractJavaScriptLanguage;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSEngine;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSMetaObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSScope;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Context;

@ProvidedTags(value={StandardTags.StatementTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.ExpressionTag.class, StandardTags.CallTag.class, DebuggerTags.AlwaysHalt.class, JSTags.ObjectAllocationTag.class, JSTags.BinaryOperationTag.class, JSTags.UnaryOperationTag.class, JSTags.WriteVariableTag.class, JSTags.ReadElementTag.class, JSTags.WriteElementTag.class, JSTags.ReadPropertyTag.class, JSTags.WritePropertyTag.class, JSTags.ReadVariableTag.class, JSTags.LiteralTag.class, JSTags.FunctionCallTag.class, JSTags.BuiltinRootTag.class, JSTags.EvalCallTag.class, JSTags.ControlFlowRootTag.class, JSTags.ControlFlowBlockTag.class, JSTags.ControlFlowBranchTag.class, JSTags.DeclareTag.class, JSTags.InputNodeTag.class})
@TruffleLanguage.Registration(id="js", name="JavaScript", implementationName="GraalVM JavaScript", characterMimeTypes={"application/javascript", "text/javascript", "application/javascript+module"}, defaultMimeType="application/javascript", contextPolicy=TruffleLanguage.ContextPolicy.SHARED, dependentLanguages={"regex"}, fileTypeDetectors={JSFileTypeDetector.class})
public class JavaScriptLanguage
extends AbstractJavaScriptLanguage {
    public static final String TEXT_MIME_TYPE = "text/javascript";
    public static final String APPLICATION_MIME_TYPE = "application/javascript";
    public static final String MODULE_MIME_TYPE = "application/javascript+module";
    public static final String SCRIPT_SOURCE_NAME_SUFFIX = ".js";
    public static final String MODULE_SOURCE_NAME_SUFFIX = ".mjs";
    public static final String INTERNAL_SOURCE_URL_PREFIX = "internal:";
    public static final String NAME = "JavaScript";
    public static final String IMPLEMENTATION_NAME = "GraalVM JavaScript";
    public static final String ID = "js";
    private volatile JSContext languageContext;
    private volatile boolean multiContext;
    private final Assumption promiseJobsQueueEmptyAssumption = Truffle.getRuntime().createAssumption("PromiseJobsQueueEmpty");
    public static final OptionDescriptors OPTION_DESCRIPTORS;
    private static final OptionKey<?>[] PREINIT_CONTEXT_PATCHABLE_OPTIONS;

    public boolean isObjectOfLanguage(Object o) {
        return JSObject.isJSObject(o) || o instanceof Symbol || o instanceof BigInt || o instanceof JSLazyString || o instanceof LargeInteger || o instanceof InteropFunction || o instanceof JSMetaObject;
    }

    @CompilerDirectives.TruffleBoundary
    public CallTarget parse(TruffleLanguage.ParsingRequest parsingRequest) {
        Source source = parsingRequest.getSource();
        List argumentNames = parsingRequest.getArgumentNames();
        if (argumentNames == null || argumentNames.isEmpty()) {
            final JSContext context = this.getJSContext();
            if (context.isOptionParseOnly()) {
                JavaScriptLanguage.parseInContext(source, context);
                return JavaScriptLanguage.createEmptyScript(context).getCallTarget();
            }
            final ScriptNode program = JavaScriptLanguage.parseInContext(source, context);
            RootNode rootNode = new RootNode(this){
                @Node.Child
                private DirectCallNode directCallNode;
                @Node.Child
                private ExportValueNode exportValueNode;
                @CompilerDirectives.CompilationFinal
                private TruffleLanguage.ContextReference<JSRealm> contextReference;
                {
                    super(x0);
                    this.directCallNode = DirectCallNode.create((CallTarget)program.getCallTarget());
                    this.exportValueNode = ExportValueNode.create();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object execute(VirtualFrame frame) {
                    if (this.contextReference == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.contextReference = this.lookupContextReference(JavaScriptLanguage.class);
                    }
                    JSRealm realm = (JSRealm)this.contextReference.get();
                    assert (realm.getContext() == context) : "unexpected JSContext";
                    try {
                        JavaScriptLanguage.this.interopBoundaryEnter(realm);
                        Object result = this.directCallNode.call(program.argumentsToRun(realm));
                        Object object = this.exportValueNode.execute(result);
                        return object;
                    }
                    finally {
                        JavaScriptLanguage.this.interopBoundaryExit(realm);
                    }
                }

                public boolean isInternal() {
                    return true;
                }
            };
            return Truffle.getRuntime().createCallTarget(rootNode);
        }
        RootNode rootNode = this.parseWithArgumentNames(source, argumentNames);
        return Truffle.getRuntime().createCallTarget(rootNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static ScriptNode createEmptyScript(JSContext context) {
        return ScriptNode.fromFunctionData(context, JSFunction.createEmptyFunctionData(context));
    }

    protected ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) throws Exception {
        final Source source = request.getSource();
        final MaterializedFrame requestFrame = request.getFrame();
        final JSContext context = this.getJSContext();
        final boolean strict = JavaScriptLanguage.isStrictLocation(request.getLocation());
        ExecutableNode executableNode = new ExecutableNode(this){
            @Node.Child
            private JavaScriptNode expression;
            @Node.Child
            private ExportValueNode exportValueNode;
            {
                super(x0);
                this.expression = (JavaScriptNode)this.insert(JavaScriptLanguage.parseInline(source, context, requestFrame, strict));
                this.exportValueNode = ExportValueNode.create();
            }

            public Object execute(VirtualFrame frame) {
                assert (JavaScriptLanguage.getCurrentJSRealm().getContext() == context) : "unexpected JSContext";
                Object result = this.expression.execute(frame);
                return this.exportValueNode.execute(result);
            }
        };
        return executableNode;
    }

    private static boolean isStrictLocation(Node location) {
        RootNode rootNode;
        if (location != null && (rootNode = location.getRootNode()) instanceof FunctionRootNode) {
            return ((FunctionRootNode)rootNode).getFunctionData().isStrict();
        }
        return true;
    }

    private RootNode parseWithArgumentNames(final Source source, final List<String> argumentNames) {
        return new RootNode(this){
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> contextReference;

            public Object execute(VirtualFrame frame) {
                if (this.contextReference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.contextReference = this.lookupContextReference(JavaScriptLanguage.class);
                }
                JSRealm realm = (JSRealm)this.contextReference.get();
                return this.executeImpl(realm, frame.getArguments());
            }

            @CompilerDirectives.TruffleBoundary
            private Object executeImpl(JSRealm realm, Object[] arguments) {
                StringBuilder code = new StringBuilder();
                code.append("'use strict';");
                code.append("(function");
                code.append(" (");
                assert (!argumentNames.isEmpty());
                code.append((String)argumentNames.get(0));
                for (int i = 1; i < argumentNames.size(); ++i) {
                    code.append(", ");
                    code.append((String)argumentNames.get(i));
                }
                code.append(") {\n");
                code.append("return eval(").append(JSRuntime.quote(source.getCharacters().toString())).append(");\n");
                code.append("})");
                Source wrappedSource = Source.newBuilder((String)JavaScriptLanguage.ID, (CharSequence)code.toString(), (String)"<function>").build();
                Object function = JavaScriptLanguage.parseInContext(wrappedSource, realm.getContext()).run(realm);
                return JSRuntime.jsObjectToJavaObject(JSFunction.call(JSArguments.create(Undefined.instance, function, arguments)));
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    protected String toString(JSRealm realm, Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof JSMetaObject) {
            JSMetaObject metaObject = (JSMetaObject)value;
            String type = metaObject.getClassName();
            if (type == null) {
                String subType = metaObject.getSubtype();
                type = "null".equals(subType) ? "null" : metaObject.getType();
            }
            return type;
        }
        return JSRuntime.safeToString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected static ScriptNode parseInContext(Source code, JSContext context) {
        long startTime = JSTruffleOptions.ProfileTime ? System.nanoTime() : 0L;
        try {
            ScriptNode scriptNode = context.getEvaluator().parseScriptNode(context, code);
            return scriptNode;
        }
        finally {
            if (JSTruffleOptions.ProfileTime) {
                context.getTimeProfiler().printElapsed(startTime, "parsing " + code.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected static JavaScriptNode parseInline(Source code, JSContext context, MaterializedFrame lexicalContextFrame, boolean strict) {
        long startTime = JSTruffleOptions.ProfileTime ? System.nanoTime() : 0L;
        try {
            JavaScriptNode javaScriptNode = context.getEvaluator().parseInlineScript(context, code, lexicalContextFrame, strict);
            return javaScriptNode;
        }
        finally {
            if (JSTruffleOptions.ProfileTime) {
                context.getTimeProfiler().printElapsed(startTime, "parsing " + code.getName());
            }
        }
    }

    protected JSRealm createContext(TruffleLanguage.Env env) {
        JSContext context = this.languageContext;
        if (context == null) {
            context = this.initLanguageContext(env);
        }
        JSRealm realm = context.createRealm(env);
        if (env.out() != realm.getOutputStream()) {
            realm.setOutputWriter(null, env.out());
        }
        if (env.err() != realm.getErrorStream()) {
            realm.setErrorWriter(null, env.err());
        }
        return realm;
    }

    private synchronized JSContext initLanguageContext(TruffleLanguage.Env env) {
        JSContext newContext;
        JSContext curContext = this.languageContext;
        if (curContext != null) {
            assert (curContext.getContextOptions().equals(JSContextOptions.fromOptionValues(env.getOptions())));
            return curContext;
        }
        this.languageContext = newContext = this.newJSContext(env);
        return newContext;
    }

    private JSContext newJSContext(TruffleLanguage.Env env) {
        return JSEngine.createJSContext(this, env);
    }

    protected void initializeContext(JSRealm realm) {
        realm.initialize();
    }

    protected boolean patchContext(JSRealm realm, TruffleLanguage.Env newEnv) {
        assert (realm.getContext().getLanguage() == this);
        if (JavaScriptLanguage.optionsAllowPreInitializedContext(realm.getEnv(), newEnv) && realm.patchContext(newEnv)) {
            return true;
        }
        this.languageContext = null;
        return false;
    }

    private static boolean optionsAllowPreInitializedContext(TruffleLanguage.Env preinitEnv, TruffleLanguage.Env env) {
        OptionValues preinitOptions = preinitEnv.getOptions();
        OptionValues options = env.getOptions();
        if (!preinitOptions.hasSetOptions() && !options.hasSetOptions()) {
            return true;
        }
        if (preinitOptions.equals(options)) {
            return true;
        }
        assert (preinitOptions.getDescriptors().equals(options.getDescriptors()));
        List<OptionKey<?>> ignoredOptions = Arrays.asList(PREINIT_CONTEXT_PATCHABLE_OPTIONS);
        for (OptionDescriptor descriptor : options.getDescriptors()) {
            OptionKey key = descriptor.getKey();
            if (!preinitOptions.hasBeenSet(key) && !options.hasBeenSet(key) || ignoredOptions.contains(key) || preinitOptions.get(key).equals(options.get(key))) continue;
            return false;
        }
        return true;
    }

    protected void disposeContext(JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        realm.setGlobalObject(Undefined.instance);
    }

    protected void initializeMultipleContexts() {
        this.multiContext = true;
    }

    @Override
    public boolean isMultiContext() {
        return this.multiContext;
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return firstOptions.equals(newOptions);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OPTION_DESCRIPTORS;
    }

    @CompilerDirectives.TruffleBoundary
    protected Object findMetaObject(JSRealm realm, Object value) {
        String type;
        String subtype = null;
        String className = null;
        if (value instanceof JSMetaObject) {
            return "metaobject";
        }
        if (value == Undefined.instance) {
            type = "undefined";
        } else if (value == Null.instance) {
            type = "object";
            subtype = "null";
        } else if (JSRuntime.isObject(value)) {
            DynamicObject obj = (DynamicObject)value;
            type = "object";
            className = JSRuntime.getConstructorName(obj);
            if (JSRuntime.isCallable(obj)) {
                type = "function";
            } else if (JSArray.isJSArray(obj)) {
                subtype = "array";
            } else if (JSDate.isJSDate(obj)) {
                subtype = "date";
            } else if (JSSymbol.isJSSymbol(obj)) {
                type = "symbol";
            }
        } else {
            if (value instanceof InteropFunction) {
                return this.findMetaObject(realm, (Object)((InteropFunction)value).getFunction());
            }
            if (JSRuntime.isForeignObject(value)) {
                assert (!JSObject.isJSObject(value));
                InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
                if (interop.isNull(value) || interop.isBoolean(value) || interop.isString(value) || interop.isNumber(value)) {
                    Object unboxed = JSInteropUtil.toPrimitiveOrDefault(value, Null.instance, interop, null);
                    assert (!JSRuntime.isForeignObject(unboxed));
                    return this.findMetaObject(realm, unboxed);
                }
                type = "object";
                className = "Foreign";
            } else {
                type = value == null ? "null" : JSRuntime.typeof(value);
            }
        }
        return new JSMetaObject(type, subtype, className, realm.getEnv());
    }

    protected SourceSection findSourceLocation(JSRealm realm, Object value) {
        if (JSFunction.isJSFunction(value)) {
            DynamicObject func = (DynamicObject)value;
            CallTarget ct = JSFunction.getCallTarget(func);
            if (JSFunction.isBoundFunction(func)) {
                func = JSFunction.getBoundTargetFunction(func);
                ct = JSFunction.getCallTarget(func);
            }
            if (ct instanceof RootCallTarget) {
                return ((RootCallTarget)ct).getRootNode().getSourceSection();
            }
        }
        return null;
    }

    protected boolean isVisible(JSRealm realm, Object value) {
        return value != Undefined.instance;
    }

    protected Iterable<Scope> findLocalScopes(JSRealm realm, Node node, Frame frame) {
        return JSScope.createLocalScopes(node, frame == null ? null : frame.materialize());
    }

    protected Iterable<Scope> findTopScopes(JSRealm realm) {
        return JSScope.createGlobalScopes(realm);
    }

    public static JSContext getJSContext(Context context) {
        return JavaScriptLanguage.getJSRealm(context).getContext();
    }

    public static JSRealm getJSRealm(Context context) {
        context.enter();
        try {
            context.initialize(ID);
            JSRealm jSRealm = (JSRealm)JavaScriptLanguage.getCurrentContext(JavaScriptLanguage.class);
            return jSRealm;
        }
        finally {
            context.leave();
        }
    }

    public void interopBoundaryEnter(JSRealm realm) {
        realm.getAgent().interopBoundaryEnter();
    }

    public void interopBoundaryExit(JSRealm realm) {
        JSAgent agent = realm.getAgent();
        if (agent.interopBoundaryExit() && !this.promiseJobsQueueEmptyAssumption.isValid()) {
            agent.processAllPromises();
        }
    }

    public Assumption getPromiseJobsQueueEmptyAssumption() {
        return this.promiseJobsQueueEmptyAssumption;
    }

    public JSContext getJSContext() {
        return this.languageContext;
    }

    private static void ensureErrorClassesInitialized() {
        if (JSTruffleOptions.SubstrateVM) {
            return;
        }
        TruffleStackTrace.getStackTrace((Throwable)Errors.createRangeError(""));
    }

    static {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        JSContextOptions.describeOptions(options);
        OPTION_DESCRIPTORS = OptionDescriptors.create(options);
        JavaScriptLanguage.ensureErrorClassesInitialized();
        PREINIT_CONTEXT_PATCHABLE_OPTIONS = new OptionKey[]{JSContextOptions.ARRAY_SORT_INHERITED, JSContextOptions.TIMER_RESOLUTION, JSContextOptions.SHELL, JSContextOptions.V8_COMPATIBILITY_MODE, JSContextOptions.GLOBAL_PROPERTY, JSContextOptions.SCRIPTING, JSContextOptions.DIRECT_BYTE_BUFFER, JSContextOptions.INTL_402, JSContextOptions.LOAD, JSContextOptions.PRINT, JSContextOptions.CONSOLE, JSContextOptions.PERFORMANCE};
    }
}

