/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.runtime.util.DebugCounter;

public final class JSNodeUtil {
    static final DebugCounter NODE_CREATE_COUNT = DebugCounter.create("NodeCreateCount");
    static final DebugCounter NODE_REPLACE_COUNT = DebugCounter.create("NodeReplaceCount");
    private static final SlowPathException SLOW_PATH_EXCEPTION = new SlowPathException();

    private JSNodeUtil() {
    }

    public static SlowPathException slowPathException() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLOW_PATH_EXCEPTION;
    }

    static String formatTags(JavaScriptNode node) {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder sb = new StringBuilder(4);
        if (node.hasTag(StandardTags.StatementTag.class)) {
            sb.append('S');
        }
        if (node.hasTag(StandardTags.CallTag.class)) {
            sb.append('C');
        }
        if (node.hasTag(StandardTags.RootTag.class)) {
            sb.append('R');
        }
        if (node.hasTag(StandardTags.RootBodyTag.class)) {
            sb.append('B');
        }
        if (node.hasTag(StandardTags.ExpressionTag.class)) {
            sb.append('E');
        }
        return sb.toString();
    }

    public static String resolveName(RootNode root) {
        if (root instanceof FunctionRootNode) {
            return ((FunctionRootNode)root).getName();
        }
        return "unknown";
    }

    public static String formatSourceSection(Node node) {
        CompilerAsserts.neverPartOfCompilation();
        if (node == null) {
            return "<unknown>";
        }
        SourceSection section = node.getSourceSection();
        boolean estimated = false;
        if (section == null) {
            section = node.getEncapsulatingSourceSection();
            estimated = true;
        }
        if (section == null || !section.isAvailable()) {
            return "<unknown source>";
        }
        String sourceName = section.getSource().getName();
        int startLine = section.getStartLine();
        return String.format("%s:%d%s", sourceName, startLine, estimated ? "~" : "");
    }

    public static boolean hasExactlyOneRootBodyTag(JavaScriptNode body) {
        CompilerAsserts.neverPartOfCompilation();
        return NodeUtil.countNodes((Node)body, node -> node instanceof JavaScriptNode && ((JavaScriptNode)node).hasTag(StandardTags.RootBodyTag.class)) == 1;
    }
}

