/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CopyDataPropertiesNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import java.util.List;

public abstract class CopyDataPropertiesNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode sourceNode;
    @Node.Child
    protected JavaScriptNode excludedNode;
    protected final JSContext context;

    protected CopyDataPropertiesNode(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode, JavaScriptNode excludedNode) {
        this.context = context;
        this.targetNode = targetNode;
        this.sourceNode = sourceNode;
        this.excludedNode = excludedNode;
    }

    public static CopyDataPropertiesNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode, JavaScriptNode excludedNode) {
        return CopyDataPropertiesNodeGen.create(context, targetNode, sourceNode, excludedNode);
    }

    @Specialization(guards={"isNullOrUndefined(value)"})
    protected static DynamicObject doNullOrUndefined(DynamicObject restObj, Object value) {
        return restObj;
    }

    @Specialization(guards={"isJSObject(value)", "excludedNode == null"})
    protected static DynamicObject doObject(DynamicObject restObj, DynamicObject value) {
        CopyDataPropertiesNode.copyDataProperties(restObj, value, null);
        return restObj;
    }

    @Specialization(guards={"isJSObject(value)", "excludedNode != null"})
    protected final DynamicObject doObjectWithExcluded(VirtualFrame frame, DynamicObject restObj, DynamicObject value) {
        Object[] excludedItems = this.excludedItems(frame);
        CopyDataPropertiesNode.copyDataProperties(restObj, value, excludedItems);
        return restObj;
    }

    @Specialization(guards={"!isJSType(value)", "excludedNode == null"})
    protected final Object doOther(DynamicObject restObj, Object value, @Cached.Shared(value="toObject") @Cached(value="createToObjectNoCheck(context)") JSToObjectNode toObjectNode, @Cached.Shared(value="isJSObject") @Cached(value="createBinaryProfile()") ConditionProfile isJSObjectProfile) {
        TruffleObject from = toObjectNode.executeTruffleObject(value);
        if (isJSObjectProfile.profile(JSGuards.isJSType(from))) {
            CopyDataPropertiesNode.doObject(restObj, (DynamicObject)from);
        } else {
            this.copyDataPropertiesForeign(restObj, from, null);
        }
        return restObj;
    }

    @Specialization(guards={"!isJSType(value)", "excludedNode != null"})
    protected final Object doOtherWithExcluded(VirtualFrame frame, DynamicObject restObj, Object value, @Cached.Shared(value="toObject") @Cached(value="createToObjectNoCheck(context)") JSToObjectNode toObjectNode, @Cached.Shared(value="isJSObject") @Cached(value="createBinaryProfile()") ConditionProfile isJSObjectProfile) {
        TruffleObject from = toObjectNode.executeTruffleObject(value);
        if (isJSObjectProfile.profile(JSGuards.isJSType(from))) {
            this.doObjectWithExcluded(frame, restObj, (DynamicObject)from);
        } else {
            this.copyDataPropertiesForeign(restObj, from, this.excludedItems(frame));
        }
        return restObj;
    }

    private Object[] excludedItems(VirtualFrame frame) {
        try {
            return JSArray.toArray(this.excludedNode.executeDynamicObject(frame));
        }
        catch (UnexpectedResultException e) {
            throw Errors.shouldNotReachHere(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void copyDataProperties(DynamicObject target, DynamicObject from, Object[] excludedItems) {
        JSClass fromClass = JSObject.getJSClass(from);
        List<Object> ownPropertyKeys = fromClass.ownPropertyKeys(from);
        for (Object t : ownPropertyKeys) {
            PropertyDescriptor desc;
            if (CopyDataPropertiesNode.isExcluded(excludedItems, t) || (desc = fromClass.getOwnProperty(from, t)) == null || !desc.getEnumerable()) continue;
            Object propValue = fromClass.get(from, t);
            JSRuntime.createDataProperty(target, t, propValue);
        }
    }

    private static boolean isExcluded(Object[] excludedKeys, Object key) {
        if (excludedKeys != null) {
            for (Object e : excludedKeys) {
                assert (JSRuntime.isPropertyKey(e));
                if (!e.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private void copyDataPropertiesForeign(DynamicObject target, Object from, Object[] excludedItems) {
        InteropLibrary objInterop = (InteropLibrary)InteropLibrary.getFactory().getUncached(from);
        try {
            Object members = objInterop.getMembers(from);
            InteropLibrary keysInterop = (InteropLibrary)InteropLibrary.getFactory().getUncached(members);
            long length = JSInteropUtil.getArraySize(members, keysInterop, this);
            for (long i = 0L; i < length; ++i) {
                String stringKey;
                Object key = keysInterop.readArrayElement(members, i);
                assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                String string = stringKey = key instanceof String ? (String)key : ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asString(key);
                if (CopyDataPropertiesNode.isExcluded(excludedItems, stringKey)) continue;
                Object value = objInterop.readMember(from, stringKey);
                JSRuntime.createDataProperty(target, stringKey, JSRuntime.importValue(value));
            }
        }
        catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(from, (InteropException)e, "CopyDataProperties", this);
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return CopyDataPropertiesNode.create(this.context, CopyDataPropertiesNode.cloneUninitialized(this.targetNode), CopyDataPropertiesNode.cloneUninitialized(this.sourceNode), CopyDataPropertiesNode.cloneUninitialized(this.excludedNode));
    }
}

