/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.LargeInteger;

@NodeInfo(shortName="|")
public abstract class JSBitwiseOrNode
extends JSBinaryNode {
    protected JSBitwiseOrNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
            if (rightValue == 0) {
                return JSToInt32Node.create(left);
            }
            if (JSTruffleOptions.UseSuperOperations) {
                return JSBitwiseOrConstantNode.create(left, rightValue);
            }
        }
        Truncatable.truncate(right);
        return JSBitwiseOrNodeGen.create(left, right);
    }

    public abstract Object executeObject(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a, int b) {
        return a | b;
    }

    @Specialization
    protected int doLargeIntegerInt(LargeInteger a, int b) {
        return this.doInteger(a.intValue(), b);
    }

    @Specialization
    protected int doIntLargeInteger(int a, LargeInteger b) {
        return this.doInteger(a, b.intValue());
    }

    @Specialization
    protected int doDouble(double a, double b, @Cached(value="create()") JSToInt32Node leftInt32, @Cached(value="create()") JSToInt32Node rightInt32) {
        return this.doInteger(leftInt32.executeInt(a), rightInt32.executeInt(b));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a, BigInt b) {
        return a.or(b);
    }

    @Specialization(replaces={"doInteger", "doIntLargeInteger", "doLargeIntegerInt", "doDouble", "doBigInt"})
    protected Object doGeneric(Object a, Object b, @Cached(value="create()") JSToNumericNode leftNumeric, @Cached(value="create()") JSToNumericNode rightNumeric, @Cached(value="createInner()") JSBitwiseOrNode or, @Cached(value="create()") BranchProfile mixedNumericTypes) {
        Object left = leftNumeric.execute(a);
        Object right = rightNumeric.execute(b);
        this.ensureBothSameNumericType(left, right, mixedNumericTypes);
        return or.executeObject(left, right);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSBitwiseOrNodeGen.create(JSBitwiseOrNode.cloneUninitialized(this.getLeft()), JSBitwiseOrNode.cloneUninitialized(this.getRight()));
    }

    public static final JSBitwiseOrNode createInner() {
        return JSBitwiseOrNodeGen.create(null, null);
    }
}

