/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToUInt32Node.class)
public final class JSToUInt32NodeGen
extends JSToUInt32Node
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private JSStringToNumberNode string_stringToNumberNode_;
    @Node.Child
    private JSToNumberNode jSObject_toNumberNode_;
    @Node.Child
    private JSToPrimitiveNode foreignObject_toPrimitiveNode_;
    @Node.Child
    private JSToUInt32Node foreignObject_toUInt32Node_;

    private JSToUInt32NodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        DynamicObject arg0Value_;
        int arg0Value_2;
        int state = this.state_;
        if ((state & 3) != 0 && arg0Value instanceof Integer) {
            arg0Value_2 = (Integer)arg0Value;
            if ((state & 1) != 0 && arg0Value_2 >= 0) {
                return this.doInteger(arg0Value_2);
            }
            if ((state & 2) != 0 && arg0Value_2 < 0) {
                return this.doIntegerNegative(arg0Value_2);
            }
        }
        if ((state & 4) != 0 && arg0Value instanceof LargeInteger) {
            LargeInteger arg0Value_3 = (LargeInteger)arg0Value;
            return this.doLargeInteger(arg0Value_3);
        }
        if ((state & 8) != 0 && arg0Value instanceof Boolean) {
            arg0Value_2 = ((Boolean)arg0Value).booleanValue() ? 1 : 0;
            return this.doBoolean(arg0Value_2 != 0);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Long) {
            long arg0Value_4 = (Long)arg0Value;
            return this.doLong(arg0Value_4);
        }
        if ((state & 0xE0) != 0 && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15, arg0Value)) {
            double arg0Value_5 = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15, arg0Value);
            if ((state & 0x20) != 0 && !JSGuards.isDoubleLargerThan2e32(arg0Value_5)) {
                return this.doDoubleFitsInt32Negative(arg0Value_5);
            }
            if ((state & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(arg0Value_5) && JSGuards.isDoubleRepresentableAsLong(arg0Value_5)) {
                return this.doDoubleRepresentableAsLong(arg0Value_5);
            }
            if ((state & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(arg0Value_5) && !JSGuards.isDoubleRepresentableAsLong(arg0Value_5)) {
                return this.doDouble(arg0Value_5);
            }
        }
        if ((state & 0x300) != 0) {
            if ((state & 0x100) != 0 && JSGuards.isJSNull(arg0Value)) {
                return this.doNull(arg0Value);
            }
            if ((state & 0x200) != 0 && JSGuards.isUndefined(arg0Value)) {
                return this.doUndefined(arg0Value);
            }
        }
        if ((state & 0x400) != 0 && JSTypesGen.isImplicitString((state & 0x780000) >>> 19, arg0Value)) {
            String arg0Value_6 = JSTypesGen.asImplicitString((state & 0x780000) >>> 19, arg0Value);
            return this.doString(arg0Value_6, this.string_stringToNumberNode_);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_7 = (Symbol)arg0Value;
            return this.doSymbol(arg0Value_7);
        }
        if ((state & 0x1000) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_8 = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_8);
        }
        if ((state & 0x2000) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject(arg0Value_, this.jSObject_toNumberNode_);
        }
        if ((state & 0x4000) != 0 && arg0Value instanceof TruffleObject && JSGuards.isForeignObject(arg0Value_ = (TruffleObject)arg0Value)) {
            return JSToUInt32Node.doForeignObject(arg0Value_, this.foreignObject_toPrimitiveNode_, this.foreignObject_toUInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            DynamicObject arg0Value_;
            int arg0Value_2;
            if (arg0Value instanceof Integer) {
                arg0Value_2 = (Integer)arg0Value;
                if (arg0Value_2 >= 0) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(arg0Value_2);
                    return n;
                }
                if (arg0Value_2 < 0) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LargeInteger largeInteger = this.doIntegerNegative(arg0Value_2);
                    return largeInteger;
                }
            }
            if (arg0Value instanceof LargeInteger) {
                LargeInteger arg0Value_3 = (LargeInteger)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.doLargeInteger(arg0Value_3);
                return object;
            }
            if (arg0Value instanceof Boolean) {
                arg0Value_2 = ((Boolean)arg0Value).booleanValue() ? 1 : 0;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Integer n = this.doBoolean(arg0Value_2 != 0);
                return n;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_4 = (Long)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Double d = this.doLong(arg0Value_4);
                return d;
            }
            int doubleCast02 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast02 != 0) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast02, arg0Value);
                if (!JSGuards.isDoubleLargerThan2e32(arg0Value_5)) {
                    state |= doubleCast02 << 15;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.doDoubleFitsInt32Negative(arg0Value_5);
                    return d;
                }
                if (JSGuards.isDoubleLargerThan2e32(arg0Value_5) && JSGuards.isDoubleRepresentableAsLong(arg0Value_5)) {
                    state |= doubleCast02 << 15;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.doDoubleRepresentableAsLong(arg0Value_5);
                    return d;
                }
                if (JSGuards.isDoubleLargerThan2e32(arg0Value_5) && !JSGuards.isDoubleRepresentableAsLong(arg0Value_5)) {
                    state |= doubleCast02 << 15;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.doDouble(arg0Value_5);
                    return d;
                }
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Integer doubleCast02 = this.doNull(arg0Value);
                return doubleCast02;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Integer doubleCast02 = this.doUndefined(arg0Value);
                return doubleCast02;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_6 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                this.string_stringToNumberNode_ = (JSStringToNumberNode)super.insert((Node)JSStringToNumberNode.create());
                state |= stringCast0 << 19;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                Double d = this.doString(arg0Value_6, this.string_stringToNumberNode_);
                return d;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_7 = (Symbol)arg0Value;
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                Number number = this.doSymbol(arg0Value_7);
                return number;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_8 = (BigInt)arg0Value;
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                Integer n = this.doBigInt(arg0Value_8);
                return n;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
                this.jSObject_toNumberNode_ = (JSToNumberNode)super.insert((Node)JSToNumberNode.create());
                this.state_ = state |= 0x2000;
                lock.unlock();
                hasLock = false;
                Double d = this.doJSObject(arg0Value_, this.jSObject_toNumberNode_);
                return d;
            }
            if (arg0Value instanceof TruffleObject && JSGuards.isForeignObject(arg0Value_ = (TruffleObject)arg0Value)) {
                this.foreignObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintNumber());
                this.foreignObject_toUInt32Node_ = (JSToUInt32Node)super.insert((Node)JSToUInt32Node.create());
                this.state_ = state |= 0x4000;
                lock.unlock();
                hasLock = false;
                Double d = JSToUInt32Node.doForeignObject(arg0Value_, this.foreignObject_toPrimitiveNode_, this.foreignObject_toUInt32Node_);
                return d;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & Short.MAX_VALUE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & Short.MAX_VALUE & (state & Short.MAX_VALUE) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[16];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doIntegerNegative";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleFitsInt32Negative";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doDoubleRepresentableAsLong";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.string_stringToNumberNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x2000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.jSObject_toNumberNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x4000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.foreignObject_toPrimitiveNode_, this.foreignObject_toUInt32Node_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[15] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToUInt32Node create() {
        return new JSToUInt32NodeGen();
    }

    @GeneratedBy(value=JSToUInt32Node.JSToUInt32WrapperNode.class)
    public static final class JSToUInt32WrapperNodeGen
    extends JSToUInt32Node.JSToUInt32WrapperNode
    implements Introspection.Provider {
        private JSToUInt32WrapperNodeGen(JavaScriptNode operand) {
            super(operand);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static JSToUInt32Node.JSToUInt32WrapperNode create(JavaScriptNode operand) {
            return new JSToUInt32WrapperNodeGen(operand);
        }
    }
}

