/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;

public final class JSArrayBuffer
extends JSAbstractBuffer
implements JSConstructorFactory.Default.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "ArrayBuffer";
    public static final String PROTOTYPE_NAME = "ArrayBuffer.prototype";
    public static final JSArrayBuffer HEAP_INSTANCE = new JSArrayBuffer();
    public static final JSArrayBuffer DIRECT_INSTANCE = new JSArrayBuffer();

    private JSArrayBuffer() {
    }

    public static DynamicObject createArrayBuffer(JSContext context, int length) {
        return JSArrayBuffer.createArrayBuffer(context, new byte[length]);
    }

    public static DynamicObject createArrayBuffer(JSContext context, byte[] byteArray) {
        DynamicObject obj = JSObject.create(context, context.getArrayBufferFactory(), new Object[]{byteArray});
        assert (JSArrayBuffer.isJSHeapArrayBuffer(obj));
        return obj;
    }

    public static int getDirectByteLength(DynamicObject thisObj) {
        return JSArrayBuffer.getDirectByteBuffer(thisObj).capacity();
    }

    public static ByteBuffer getDirectByteBuffer(DynamicObject thisObj) {
        return JSArrayBuffer.getDirectByteBuffer(thisObj, JSArrayBuffer.isJSDirectArrayBuffer(thisObj));
    }

    public static ByteBuffer getDirectByteBuffer(DynamicObject thisObj, boolean condition) {
        assert (JSArrayBuffer.isJSDirectArrayBuffer(thisObj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return DirectByteBufferHelper.cast((ByteBuffer)BYTE_BUFFER_PROPERTY.get(thisObj, condition));
    }

    public static void setDirectByteBuffer(DynamicObject arrayBuffer, ByteBuffer buffer) {
        assert (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer));
        assert (buffer != null);
        BYTE_BUFFER_PROPERTY.setSafe(arrayBuffer, (Object)buffer, null);
    }

    public static DynamicObject createDirectArrayBuffer(JSContext context, int length) {
        return JSArrayBuffer.createDirectArrayBuffer(context, DirectByteBufferHelper.allocateDirect(length));
    }

    public static DynamicObject createDirectArrayBuffer(JSContext context, ByteBuffer buffer) {
        DynamicObject obj = JSObject.create(context, context.getDirectArrayBufferFactory(), buffer);
        assert (JSArrayBuffer.isJSDirectArrayBuffer(obj));
        return obj;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject arrayBufferPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)(context.getEcmaScriptVersion() < 6 ? HEAP_INSTANCE : JSUserObject.INSTANCE));
        if (context.getEcmaScriptVersion() < 6) {
            JSObjectUtil.putHiddenProperty(arrayBufferPrototype, BYTE_ARRAY_PROPERTY, new byte[0]);
        }
        JSObjectUtil.putConstructorProperty(context, arrayBufferPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayBufferPrototype, PROTOTYPE_NAME);
        JSFunctionData byteLengthGetterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayBufferByteLength, c -> JSFunctionData.createCallOnly(context, JSArrayBuffer.createByteLengthGetterCallTarget(c), 0, "get byteLength"));
        DynamicObject byteLengthGetter = JSFunction.create(realm, byteLengthGetterData);
        JSObjectUtil.putConstantAccessorProperty(context, arrayBufferPrototype, "byteLength", byteLengthGetter, Undefined.instance);
        JSObjectUtil.putDataProperty(context, arrayBufferPrototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return arrayBufferPrototype;
    }

    private static CallTarget createByteLengthGetterCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            private final ConditionProfile isArrayBuffer;
            private final ConditionProfile isDirectByteBuffer;
            private final BranchProfile errorBranch;
            {
                super(lang, sourceSection, frameDescriptor);
                this.isArrayBuffer = ConditionProfile.createBinaryProfile();
                this.isDirectByteBuffer = ConditionProfile.createBinaryProfile();
                this.errorBranch = BranchProfile.create();
            }

            public Object execute(VirtualFrame frame) {
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSObject.isDynamicObject(obj)) {
                    DynamicObject buffer = (DynamicObject)obj;
                    if (this.isArrayBuffer.profile(JSArrayBuffer.isJSHeapArrayBuffer(buffer))) {
                        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                            throw Errors.createTypeErrorDetachedBuffer();
                        }
                        return JSAbstractBuffer.getByteLength(buffer);
                    }
                    if (this.isDirectByteBuffer.profile(JSArrayBuffer.isJSDirectArrayBuffer(buffer))) {
                        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                            throw Errors.createTypeErrorDetachedBuffer();
                        }
                        return JSArrayBuffer.getDirectByteLength(buffer);
                    }
                }
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferExpected();
            }
        });
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        if (this == HEAP_INSTANCE) {
            Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, HEAP_INSTANCE, context);
            initialShape = initialShape.addProperty(BYTE_ARRAY_PROPERTY);
            return initialShape;
        }
        assert (this == DIRECT_INSTANCE);
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, DIRECT_INSTANCE, context);
        initialShape = initialShape.addProperty(BYTE_BUFFER_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return HEAP_INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSHeapArrayBuffer(Object obj) {
        return JSObject.isDynamicObject(obj) && JSArrayBuffer.isJSHeapArrayBuffer((DynamicObject)obj);
    }

    public static boolean isJSHeapArrayBuffer(DynamicObject obj) {
        return JSArrayBuffer.isInstance(obj, (JSClass)HEAP_INSTANCE);
    }

    public static boolean isJSDirectArrayBuffer(Object obj) {
        return JSObject.isDynamicObject(obj) && JSArrayBuffer.isJSDirectArrayBuffer((DynamicObject)obj);
    }

    public static boolean isJSDirectArrayBuffer(DynamicObject obj) {
        return JSArrayBuffer.isInstance(obj, (JSClass)DIRECT_INSTANCE);
    }

    public static boolean isJSDirectOrSharedArrayBuffer(Object obj) {
        return JSArrayBuffer.isJSDirectArrayBuffer(obj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(obj);
    }

    public static boolean isJSDirectOrSharedArrayBuffer(DynamicObject obj) {
        return JSArrayBuffer.isJSDirectArrayBuffer(obj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isDetachedBuffer(DynamicObject arrayBuffer) {
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        if (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer)) {
            return BYTE_BUFFER_PROPERTY.get(arrayBuffer, JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer)) == null;
        }
        return BYTE_ARRAY_PROPERTY.get(arrayBuffer, JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer)) == null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void detachArrayBuffer(DynamicObject arrayBuffer) {
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        JSObject.getJSContext(arrayBuffer).getTypedArrayNotDetachedAssumption().invalidate("no detached array buffer");
        if (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer)) {
            BYTE_BUFFER_PROPERTY.setSafe(arrayBuffer, null, null);
        } else {
            BYTE_ARRAY_PROPERTY.setSafe(arrayBuffer, null, null);
        }
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayBufferPrototype();
    }
}

