/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.requirejs.ConfigOption;
import org.netbeans.modules.javascript2.requirejs.RequireJsDataProvider;
import org.netbeans.modules.javascript2.requirejs.editor.Bundle;
import org.netbeans.modules.javascript2.requirejs.editor.EditorUtils;
import org.netbeans.modules.javascript2.requirejs.editor.SimpleHandle;

public class RequireJsCompletionItem
implements CompletionProposal {
    private final int anchor;
    private final ElementHandle element;

    public RequireJsCompletionItem(ElementHandle element, String name, int anchor) {
        this.element = element;
        this.anchor = anchor;
    }

    protected String getText() {
        return this.getName();
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RequireJsCompletionItem)) {
            return false;
        }
        RequireJsCompletionItem remote = (RequireJsCompletionItem)o;
        return this.getText().equals(remote.getText());
    }

    public ImageIcon getIcon() {
        return EditorUtils.getRequireJsIcon();
    }

    public int getAnchorOffset() {
        return this.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        return this.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return "";
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return -1000;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public static class PropertyNameCompletionItem
    extends RequireJsCompletionItem {
        private final ConfigOption.OptionType type;

        public PropertyNameCompletionItem(String name, ConfigOption.OptionType type, int anchor) {
            super(new PropertyHandle(name), name, anchor);
            this.type = type;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName() + ": ";
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append(": ");
            switch (this.type) {
                case STRING: {
                    sb.append("'${cursor}'");
                    break;
                }
                case OBJECT: {
                    sb.append("{\n${cursor}\n}");
                    break;
                }
                case ARRAY: {
                    sb.append("[\n${cursor}\n]");
                    break;
                }
                case BOOLEAN: {
                    sb.append("${false}${cursor}");
                    break;
                }
                default: {
                    sb.append("${cursor}");
                }
            }
            return sb.toString();
        }

        private static class PropertyHandle
        extends SimpleHandle.DocumentationHandle {
            public PropertyHandle(String name) {
                super(name, ElementKind.PROPERTY);
            }

            @Override
            public String getDocumentation() {
                return RequireJsDataProvider.getDefault().getDocFocOption(this.getName());
            }
        }
    }

    public static class PluginNameCompletionItem
    extends RequireJsCompletionItem {
        public PluginNameCompletionItem(String name, int anchor) {
            super(new PluginNameHandle(name), name, anchor);
        }

        @Override
        public String getInsertPrefix() {
            return this.getName() + '!';
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            return this.getName() + '!';
        }

        private static class PluginNameHandle
        extends SimpleHandle.DocumentationHandle {
            public PluginNameHandle(String name) {
                super(name, ElementKind.OTHER);
            }

            @Override
            public String getDocumentation() {
                return Bundle.pluginNameDoc();
            }
        }
    }
}

