/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import org.netbeans.insane.impl.InsaneEngine;
import org.netbeans.insane.impl.ObjectFoundException;
import org.netbeans.insane.impl.Root;
import org.netbeans.insane.impl.Utils;
import org.netbeans.insane.live.CancelException;
import org.netbeans.insane.live.Path;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public class LiveEngine
implements ObjectMap,
Visitor {
    private IdentityHashMap<Object, Object> objects = new IdentityHashMap();
    private Map<Object, String> rest = new IdentityHashMap<Object, String>();
    private BoundedRangeModel progress;
    private int objCount;
    private int objExpected;
    private int objStep;
    private Filter filter = ScannerUtils.skipNonStrongReferencesFilter();

    public LiveEngine() {
    }

    public LiveEngine(BoundedRangeModel progress) {
        this.progress = progress;
    }

    public LiveEngine(BoundedRangeModel progress, Filter filter) {
        this.progress = progress;
        if (filter != null) {
            this.filter = ScannerUtils.compoundFilter(new Filter[]{filter, this.filter});
        }
    }

    @Override
    public boolean isKnown(Object o) {
        return this.objects.containsKey(o);
    }

    @Override
    public String getID(Object o) {
        this.objects.put(o, null);
        return null;
    }

    public void visitClass(Class cls) {
    }

    @Override
    public void visitObject(ObjectMap map, Object object) {
        if (this.progress != null) {
            ++this.objCount;
            if (this.objCount % this.objStep == 0 && this.objCount < this.objExpected) {
                this.progress.setValue(this.objCount);
            }
        }
    }

    @Override
    public void visitArrayReference(ObjectMap map, Object from, Object to, int index) {
        this.visitRef(from, to, null);
    }

    @Override
    public void visitObjectReference(ObjectMap map, Object from, Object to, Field ref) {
        this.visitRef(from, to, ref);
    }

    @Override
    public void visitStaticReference(ObjectMap map, Object to, Field ref) {
        this.visitRef(null, to, ref);
    }

    private void visitRef(Object from, Object to, Field field) {
        this.addIncommingRef(to, from, field);
        if (this.rest.containsKey(to)) {
            this.rest.remove(to);
            if (this.rest.size() == 0) {
                throw new ObjectFoundException();
            }
        }
    }

    private void addIncommingRef(Object to, Object from, Field f) {
        Object save = from != null ? from : Root.createStatic(f, to);
        Object entry = this.objects.get(to);
        if (entry == null) {
            entry = save instanceof Object[] ? new Object[]{save} : save;
        } else if (!(entry instanceof Object[])) {
            entry = new Object[]{entry, save};
        } else {
            int origLen = ((Object[])entry).length;
            Object[] ret = new Object[origLen + 1];
            System.arraycopy(entry, 0, ret, 0, origLen);
            ret[origLen] = save;
            entry = ret;
        }
        this.objects.put(to, entry);
    }

    private Iterator getIncomingRefs(Object to) {
        Object oo = this.objects.get(to);
        if (oo instanceof Object[]) {
            return Arrays.asList((Object[])oo).iterator();
        }
        if (oo == null) {
            return Collections.emptyIterator();
        }
        return Collections.singleton(oo).iterator();
    }

    public Map<Object, Path> trace(Collection<Object> objs, Set<Object> roots) {
        try {
            return this.traceImpl(objs, roots);
        }
        catch (CancelException ex) {
            return null;
        }
    }

    private Map<Object, Path> traceImpl(Collection<Object> objs, Set<Object> roots) {
        if (this.progress != null) {
            long usedMemory = Utils.getUsedMemory();
            this.objExpected = (int)(usedMemory / 50L);
            this.objStep = this.objExpected / 200;
            this.progress.setRangeProperties(0, 0, 0, 10 * this.objExpected / 9, false);
        }
        for (Object object : objs) {
            this.rest.put(object, "");
        }
        IdentityHashMap<Object, Boolean> s = new IdentityHashMap<Object, Boolean>();
        for (Object o : ScannerUtils.interestingRoots()) {
            s.put(o, true);
        }
        if (roots != null) {
            for (Object o : roots) {
                s.put(roots, true);
            }
        }
        try {
            InsaneEngine insaneEngine = new InsaneEngine(this, this.filter, this, true);
            insaneEngine.traverse(s.keySet());
        }
        catch (CancelException cancelException) {
            throw cancelException;
        }
        catch (ObjectFoundException objectFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.progress != null) {
            this.progress.setValue(this.objExpected);
        }
        IdentityHashMap<Object, Path> identityHashMap = new IdentityHashMap<Object, Path>();
        int found = objs.size() - this.rest.size();
        int base = this.objExpected;
        int step = found > 0 ? this.objExpected / 9 / found : 0;
        for (Object obj : objs) {
            if (this.rest.containsKey(obj)) continue;
            Path toObj = this.findRoots(obj, s.keySet());
            if (toObj != null) {
                identityHashMap.put(obj, toObj);
            }
            if (this.progress == null) continue;
            this.progress.setValue(base += step);
        }
        return identityHashMap;
    }

    private Path findRoots(Object obj, Set roots) {
        HashSet<Path> visited = new HashSet<Path>();
        Path last = Utils.createPath(obj, null);
        LinkedList<Path> queue = new LinkedList<Path>();
        queue.add(last);
        visited.add(last);
        while (!queue.isEmpty()) {
            Path act = (Path)queue.remove(0);
            Object item = act.getObject();
            if (roots.contains(item)) {
                return act;
            }
            Iterator it = this.getIncomingRefs(item);
            while (it.hasNext()) {
                Object o = it.next();
                Path prev = Utils.createPath(o, act);
                if (o instanceof Root) {
                    return prev;
                }
                if (visited.contains(prev)) continue;
                visited.add(prev);
                queue.add(prev);
            }
        }
        return null;
    }
}

