/*
 * Decompiled with CFR 0.152.
 */
package org.testng.asserts;

import java.util.Map;
import org.testng.asserts.Assertion;
import org.testng.asserts.IAssert;
import org.testng.collections.Maps;

public class SoftAssert
extends Assertion {
    private Map<AssertionError, IAssert> m_errors = Maps.newLinkedHashMap();

    @Override
    public void executeAssert(IAssert a) {
        try {
            a.doAssert();
        }
        catch (AssertionError ex) {
            this.onAssertFailure(a, ex);
            this.m_errors.put(ex, a);
        }
    }

    public void assertAll() {
        if (!this.m_errors.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following asserts failed:\n");
            boolean first = true;
            for (Map.Entry<AssertionError, IAssert> ae : this.m_errors.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(ae.getValue().getMessage());
            }
            throw new AssertionError((Object)sb.toString());
        }
    }
}

