/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.Widget;

public final class CardLayout
implements Layout {
    private static final Point POINT_EMPTY = new Point();
    private static final Rectangle RECTANGLE_EMPTY = new Rectangle();
    private Widget cardLayoutWidget;
    private Widget activeChildWidget;

    public CardLayout(Widget cardLayoutWidget) {
        assert (cardLayoutWidget != null);
        this.cardLayoutWidget = cardLayoutWidget;
        cardLayoutWidget.setCheckClipping(true);
    }

    public Widget getActiveChildWidget() {
        return this.activeChildWidget;
    }

    public void setActiveChildWidget(Widget activeChildWidget) {
        this.activeChildWidget = activeChildWidget;
        this.cardLayoutWidget.revalidate();
    }

    @Override
    public void layout(Widget widget) {
        assert (widget == this.cardLayoutWidget);
        Point preferredLocation = null;
        Rectangle preferredBounds = null;
        if (this.activeChildWidget != null && this.activeChildWidget.isVisible()) {
            for (Widget child : this.cardLayoutWidget.getChildren()) {
                if (child != this.activeChildWidget) continue;
                preferredLocation = child.getPreferredLocation();
                preferredBounds = child.getPreferredBounds();
                break;
            }
        }
        if (preferredLocation == null) {
            preferredLocation = POINT_EMPTY;
        }
        if (preferredBounds == null) {
            preferredBounds = RECTANGLE_EMPTY;
        }
        Rectangle otherBounds = new Rectangle(preferredBounds.x, preferredBounds.y, 0, 0);
        for (Widget child : this.cardLayoutWidget.getChildren()) {
            child.resolveBounds(preferredLocation, child == this.activeChildWidget ? preferredBounds : otherBounds);
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return true;
    }

    @Override
    public void justify(Widget widget) {
        assert (widget == this.cardLayoutWidget);
        if (this.activeChildWidget != null && this.activeChildWidget.isVisible()) {
            for (Widget child : this.cardLayoutWidget.getChildren()) {
                if (child != this.activeChildWidget) continue;
                Rectangle bounds = widget.getClientArea();
                Point location = child.getLocation();
                Rectangle childBounds = child.getBounds();
                bounds.translate(-location.x, -location.y);
                childBounds.add(bounds);
                child.resolveBounds(location, bounds);
                return;
            }
        }
    }
}

