/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.buffer;

import com.oracle.truffle.regex.tregex.buffer.AbstractArrayBuffer;
import java.util.Arrays;

public class ShortArrayBuffer
extends AbstractArrayBuffer {
    private short[] buf;

    public ShortArrayBuffer() {
        this(16);
    }

    public ShortArrayBuffer(int initialSize) {
        this.buf = new short[initialSize];
    }

    @Override
    int getBufferLength() {
        return this.buf.length;
    }

    @Override
    void grow(int newSize) {
        this.buf = Arrays.copyOf(this.buf, newSize);
    }

    public short get(int i) {
        return this.buf[i];
    }

    public void add(short s) {
        if (this.length == this.buf.length) {
            this.grow(this.length * 2);
        }
        this.buf[this.length] = s;
        ++this.length;
    }

    public void addAll(short[] values, int valuesLength) {
        this.ensureCapacity(this.length + valuesLength);
        System.arraycopy(values, 0, this.buf, this.length, valuesLength);
        this.length += valuesLength;
    }

    public short[] toArray() {
        return Arrays.copyOf(this.buf, this.length);
    }
}

