/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Arrays;
import java.util.Collection;

public final class NFA
implements StateIndex<NFAState>,
JsonConvertible {
    private final RegexAST ast;
    private final NFAState dummyInitialState;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final NFAStateTransition[] anchoredEntry;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final NFAStateTransition[] unAnchoredEntry;
    private final NFAStateTransition reverseAnchoredEntry;
    private final NFAStateTransition reverseUnAnchoredEntry;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final NFAState[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final NFAStateTransition[] transitions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PreCalculatedResultFactory[] preCalculatedResults;
    private final NFAStateTransition initialLoopBack;

    public NFA(RegexAST ast, NFAState dummyInitialState, NFAStateTransition[] anchoredEntry, NFAStateTransition[] unAnchoredEntry, NFAStateTransition reverseAnchoredEntry, NFAStateTransition reverseUnAnchoredEntry, Collection<NFAState> states, Counter.ThresholdCounter stateIDCounter, Counter.ThresholdCounter transitionIDCounter, PreCalculatedResultFactory[] preCalculatedResults) {
        this.ast = ast;
        this.dummyInitialState = dummyInitialState;
        this.anchoredEntry = anchoredEntry;
        this.unAnchoredEntry = unAnchoredEntry;
        this.reverseAnchoredEntry = reverseAnchoredEntry;
        this.reverseUnAnchoredEntry = reverseUnAnchoredEntry;
        this.preCalculatedResults = preCalculatedResults;
        this.states = new NFAState[stateIDCounter.getCount()];
        this.transitions = new NFAStateTransition[transitionIDCounter.getCount() + 1];
        if (this.isTraceFinderNFA()) {
            this.initialLoopBack = null;
        } else {
            this.transitions[this.initialLoopBack.getId()] = this.initialLoopBack = new NFAStateTransition((short)transitionIDCounter.inc(), this.getUnAnchoredInitialState(), this.getUnAnchoredInitialState(), GroupBoundaries.getEmptyInstance());
        }
        for (NFAState s : states) {
            assert (this.states[s.getId()] == null);
            this.states[s.getId()] = s;
            if (s.getNext() == null) continue;
            for (NFAStateTransition t : s.getNext()) {
                assert (this.transitions[t.getId()] == null || s == dummyInitialState && this.transitions[t.getId()] == t);
                this.transitions[t.getId()] = t;
            }
            if (s != dummyInitialState) continue;
            for (NFAStateTransition t : s.getPrev()) {
                assert (this.transitions[t.getId()] == null);
                this.transitions[t.getId()] = t;
            }
        }
    }

    public NFAState getUnAnchoredInitialState() {
        return this.unAnchoredEntry[0].getTarget();
    }

    public NFAState getAnchoredInitialState() {
        return this.anchoredEntry[0].getTarget();
    }

    public boolean hasReverseUnAnchoredEntry() {
        return this.reverseUnAnchoredEntry != null && this.reverseUnAnchoredEntry.getSource().getPrev().length > 0;
    }

    public RegexAST getAst() {
        return this.ast;
    }

    public NFAState getDummyInitialState() {
        return this.dummyInitialState;
    }

    public boolean isEntry(NFAState state, boolean forward) {
        return this.isAnchoredEntry(state, forward) || this.isUnAnchoredEntry(state, forward);
    }

    public boolean isAnchoredEntry(NFAState state, boolean forward) {
        return forward ? NFA.transitionListContainsTarget(this.anchoredEntry, state) : this.reverseAnchoredEntry.getSource() == state;
    }

    public boolean isUnAnchoredEntry(NFAState state, boolean forward) {
        return forward ? NFA.transitionListContainsTarget(this.unAnchoredEntry, state) : this.reverseUnAnchoredEntry.getSource() == state;
    }

    public int getAnchoredEntryOffset(NFAState state, boolean forward) {
        assert (this.isAnchoredEntry(state, forward));
        return forward ? NFA.transitionListIndexOfTarget(this.anchoredEntry, state) : 0;
    }

    public int getUnAnchoredEntryOffset(NFAState state, boolean forward) {
        assert (this.isUnAnchoredEntry(state, forward));
        return forward ? NFA.transitionListIndexOfTarget(this.unAnchoredEntry, state) : 0;
    }

    private static int transitionListIndexOfTarget(NFAStateTransition[] transitions, NFAState target) {
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i].getTarget() != target) continue;
            return i;
        }
        return -1;
    }

    private static boolean transitionListContainsTarget(NFAStateTransition[] transitions, NFAState target) {
        for (NFAStateTransition t : transitions) {
            if (t.getTarget() != target) continue;
            return true;
        }
        return false;
    }

    public NFAStateTransition[] getAnchoredEntry() {
        return this.anchoredEntry;
    }

    public NFAStateTransition[] getUnAnchoredEntry() {
        return this.unAnchoredEntry;
    }

    public NFAStateTransition getReverseAnchoredEntry() {
        return this.reverseAnchoredEntry;
    }

    public NFAStateTransition getReverseUnAnchoredEntry() {
        return this.reverseUnAnchoredEntry;
    }

    public NFAState[] getStates() {
        return this.states;
    }

    public NFAStateTransition[] getTransitions() {
        return this.transitions;
    }

    public PreCalculatedResultFactory[] getPreCalculatedResults() {
        return this.preCalculatedResults;
    }

    public NFAStateTransition getInitialLoopBackTransition() {
        return this.initialLoopBack;
    }

    public boolean isTraceFinderNFA() {
        return this.preCalculatedResults != null;
    }

    @Override
    public int getNumberOfStates() {
        return this.states.length;
    }

    @Override
    public NFAState getState(int id) {
        return this.states[id];
    }

    public int getNumberOfTransitions() {
        return this.transitions.length;
    }

    public boolean isDead() {
        return this.anchoredEntry != null ? this.getAnchoredInitialState().isDead(true) : this.reverseAnchoredEntry.getSource().isDead(false) && this.reverseUnAnchoredEntry.getSource().isDead(false);
    }

    public void setInitialLoopBack(boolean enable) {
        if (this.getUnAnchoredInitialState().getNext().length == 0) {
            return;
        }
        NFAStateTransition lastInitTransition = this.getUnAnchoredInitialState().getNext()[this.getUnAnchoredInitialState().getNext().length - 1];
        if (enable) {
            if (lastInitTransition != this.initialLoopBack) {
                this.getUnAnchoredInitialState().addLoopBackNext(this.initialLoopBack);
            }
        } else if (lastInitTransition == this.initialLoopBack) {
            this.getUnAnchoredInitialState().removeLoopBackNext();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("states", Json.array(this.states)), Json.prop("transitions", Json.array(this.transitions)), Json.prop("anchoredEntry", this.anchoredEntry == null ? null : NFA.fwdEntryToJson(this.anchoredEntry)), Json.prop("unAnchoredEntry", this.unAnchoredEntry == null ? null : NFA.fwdEntryToJson(this.unAnchoredEntry)), Json.prop("reverseAnchoredEntry", NFA.revEntryToJson(this.reverseAnchoredEntry)), Json.prop("reverseUnAnchoredEntry", NFA.revEntryToJson(this.reverseUnAnchoredEntry)), Json.prop("preCalculatedResults", Json.array(this.preCalculatedResults)));
    }

    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson(boolean forward) {
        boolean anchoredFinalStateReachable = false;
        CompilationFinalBitSet bitSet = new CompilationFinalBitSet(this.transitions.length);
        for (NFAState s : this.states) {
            if (s == null || s == this.dummyInitialState) continue;
            for (NFAStateTransition t : s.getNext(forward)) {
                bitSet.set(t.getId());
                if (!t.getTarget(forward).isAnchoredFinalState(forward)) continue;
                anchoredFinalStateReachable = true;
            }
        }
        boolean afsReachable = anchoredFinalStateReachable;
        return Json.obj(Json.prop("states", Arrays.stream(this.states).map(x -> x == null || x == this.dummyInitialState || x.isAnchoredFinalState(forward) && !afsReachable ? Json.nullValue() : x.toJson(forward))), Json.prop("transitions", Arrays.stream(this.transitions).map(x -> x == null || !bitSet.get(x.getId()) ? Json.nullValue() : x.toJson(forward))), Json.prop("anchoredEntry", forward ? NFA.fwdEntryToJson(this.anchoredEntry) : NFA.revEntryToJson(this.reverseAnchoredEntry)), Json.prop("unAnchoredEntry", forward ? NFA.fwdEntryToJson(this.unAnchoredEntry) : NFA.revEntryToJson(this.reverseUnAnchoredEntry)), Json.prop("preCalculatedResults", Json.array(this.preCalculatedResults)));
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray fwdEntryToJson(NFAStateTransition[] entryArray) {
        return Json.array(Arrays.stream(entryArray).map(x -> Json.val(x.getTarget().getId())));
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray revEntryToJson(NFAStateTransition revEntry) {
        return Json.array(Json.val(revEntry.getSource().getId()));
    }
}

