/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.BackwardDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;

public class TraceFinderDFAStateNode
extends BackwardDFAStateNode {
    public static final byte NO_PRE_CALC_RESULT = -1;
    private final byte preCalculatedUnAnchoredResult;
    private final byte preCalculatedAnchoredResult;

    public TraceFinderDFAStateNode(short id, byte flags, DFAStateNode.LoopOptimizationNode loopOptimizationNode, short[] successors, CharMatcher[] matchers, AllTransitionsInOneTreeMatcher allTransitionsInOneTreeMatcher, byte preCalculatedUnAnchoredResult, byte preCalculatedAnchoredResult) {
        super(id, flags, loopOptimizationNode, successors, matchers, null, allTransitionsInOneTreeMatcher);
        this.preCalculatedUnAnchoredResult = preCalculatedUnAnchoredResult;
        this.preCalculatedAnchoredResult = preCalculatedAnchoredResult;
    }

    private TraceFinderDFAStateNode(TraceFinderDFAStateNode copy, short copyID) {
        super(copy, copyID);
        this.preCalculatedUnAnchoredResult = copy.preCalculatedUnAnchoredResult;
        this.preCalculatedAnchoredResult = copy.preCalculatedAnchoredResult;
    }

    @Override
    public DFAStateNode createNodeSplitCopy(short copyID) {
        return new TraceFinderDFAStateNode(this, copyID);
    }

    private boolean hasPreCalculatedUnAnchoredResult() {
        return this.preCalculatedUnAnchoredResult != -1;
    }

    private int getPreCalculatedUnAnchoredResult() {
        return Byte.toUnsignedInt(this.preCalculatedUnAnchoredResult);
    }

    private boolean hasPreCalculatedAnchoredResult() {
        return this.preCalculatedAnchoredResult != -1;
    }

    private int getPreCalculatedAnchoredResult() {
        return Byte.toUnsignedInt(this.preCalculatedAnchoredResult);
    }

    @Override
    void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int index, boolean anchored) {
        if (anchored) {
            assert (this.hasPreCalculatedAnchoredResult());
            if (this.hasPreCalculatedUnAnchoredResult() && this.getPreCalculatedUnAnchoredResult() < this.getPreCalculatedAnchoredResult()) {
                locals.setResultInt(this.getPreCalculatedUnAnchoredResult());
            } else {
                locals.setResultInt(this.getPreCalculatedAnchoredResult());
            }
        } else {
            assert (this.hasPreCalculatedUnAnchoredResult());
            locals.setResultInt(this.getPreCalculatedUnAnchoredResult());
        }
    }
}

