/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.runtime.nodes.ToCharNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNodeGen;

@GenerateUncached
public abstract class InputCharAtNode
extends Node {
    public static InputCharAtNode create() {
        return InputCharAtNodeGen.create();
    }

    public abstract char execute(Object var1, int var2);

    @Specialization
    static char doString(String input, int index) {
        return input.charAt(index);
    }

    @Specialization(guards={"inputs.hasArrayElements(input)"}, limit="2")
    static char doBoxedCharArray(Object input, int index, @CachedLibrary(value="input") InteropLibrary inputs, @Cached ToCharNode toCharNode) {
        try {
            return toCharNode.execute(inputs.readArrayElement(input, (long)index));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw new RuntimeException(e);
        }
    }

    public static char charAtWithMask(TruffleObject input, int indexInput, String mask, int indexMask, InputCharAtNode charAtNode) {
        CompilerAsserts.partialEvaluationConstant((mask == null ? 1 : 0) != 0);
        char c = charAtNode.execute(input, indexInput);
        return mask == null ? c : (char)(c | mask.charAt(indexMask));
    }
}

