/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Logo;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.ShowNextTime;
import org.netbeans.modules.welcome.ui.TabContentPane;
import org.openide.util.ImageUtilities;

class TabbedPane
extends JPanel
implements Constants {
    private final JComponent[] tabs;
    private final TabButton[] buttons;
    private final JComponent tabHeader;
    private final JPanel tabContent;
    private boolean[] tabAdded;
    private int selTabIndex = -1;
    private static final Color colBackground = Utils.getTopBarColor();
    private static final Image imgSelected;
    private static final Image imgRollover;
    private static final Color COL__BORDER1;
    private static final Color COL__BORDER2;

    public TabbedPane(JComponent ... tabs) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.tabs = tabs;
        this.tabAdded = new boolean[tabs.length];
        Arrays.fill(this.tabAdded, false);
        for (JComponent c : tabs) {
            c.putClientProperty("print.printable", Boolean.TRUE);
            c.putClientProperty("print.name", c.getName());
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabButton btn = (TabButton)e.getSource();
                TabbedPane.this.switchTab(btn.getTabIndex());
                WelcomeOptions.getDefault().setLastActiveTab(btn.getTabIndex());
            }
        };
        this.buttons = new TabButton[tabs.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new TabButton(tabs[i].getName(), i);
            this.buttons[i].addActionListener(al);
        }
        this.tabHeader = new TabHeader(this.buttons);
        this.add((Component)this.tabHeader, "North");
        this.tabContent = new TabContentPane();
        this.add((Component)this.tabContent, "Center");
        int activeTabIndex = WelcomeOptions.getDefault().getLastActiveTab();
        if (WelcomeOptions.getDefault().isSecondStart() && activeTabIndex < 0) {
            activeTabIndex = 1;
            WelcomeOptions.getDefault().setLastActiveTab(1);
        }
        activeTabIndex = Math.max(0, activeTabIndex);
        activeTabIndex = Math.min(activeTabIndex, tabs.length - 1);
        this.switchTab(activeTabIndex);
    }

    private void switchTab(int tabIndex) {
        if (!this.tabAdded[tabIndex]) {
            this.tabContent.add((Component)this.tabs[tabIndex], new GridBagConstraints(tabIndex, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tabAdded[tabIndex] = true;
        }
        if (this.selTabIndex >= 0) {
            this.buttons[this.selTabIndex].setSelected(false);
        }
        JComponent compToShow = this.tabs[tabIndex];
        JComponent compToHide = this.selTabIndex >= 0 ? this.tabs[this.selTabIndex] : null;
        this.selTabIndex = tabIndex;
        this.buttons[this.selTabIndex].setSelected(true);
        if (null != compToHide) {
            compToHide.setVisible(false);
        }
        compToShow.setVisible(true);
        compToShow.requestFocusInWindow();
    }

    @Override
    public Dimension getPreferredSize() {
        Container scroll;
        Dimension d = super.getPreferredSize();
        if (null != this.getParent() && null != this.getParent().getParent() && (scroll = this.getParent().getParent()).getWidth() > 0) {
            if (d.width > scroll.getWidth()) {
                d.width = Math.max(scroll.getWidth(), 700 + (int)((double)(FONT_SIZE - 11) / 11.0 * 700.0));
            } else if (d.width < scroll.getWidth()) {
                d.width = scroll.getWidth();
            }
        }
        d.width = Math.min(d.width, 1000);
        return d;
    }

    static {
        String imgName = UIManager.getString("nb.startpage.tab.imagename.selected");
        if (null == imgName) {
            imgName = "org/netbeans/modules/welcome/resources/tab_selected.png";
        }
        imgSelected = ImageUtilities.loadImage((String)imgName, (boolean)true);
        imgName = UIManager.getString("nb.startpage.tab.imagename.rollover");
        if (null == imgName) {
            imgName = "org/netbeans/modules/welcome/resources/tab_rollover.png";
        }
        imgRollover = ImageUtilities.loadImage((String)imgName, (boolean)true);
        COL__BORDER1 = Utils.getTabBorder1Color();
        COL__BORDER2 = Utils.getTabBorder2Color();
    }

    private static final class TabBorder
    implements Border {
        private final boolean isLastButton;

        public TabBorder(boolean isLastButton) {
            this.isLastButton = isLastButton;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(COL__BORDER2);
            g.drawRect(x, y, width - 1, height - 1);
            g.setColor(COL__BORDER1);
            g.drawLine(x, y, x, height);
            if (this.isLastButton) {
                g.drawLine(width - 1, y, width - 1, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(16, 16, 12, 16);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class TabHeader
    extends JPanel {
        private final ShowNextTime showNextTime;

        public TabHeader(TabButton ... buttons) {
            super(new GridBagLayout());
            this.showNextTime = new ShowNextTime();
            this.setOpaque(false);
            JPanel panelButtons = new JPanel(new GridLayout(1, 0));
            panelButtons.setOpaque(false);
            for (int i = 0; i < buttons.length; ++i) {
                TabButton btn = buttons[i];
                btn.setBorder(new TabBorder(i == buttons.length - 1));
                panelButtons.add(btn);
            }
            this.add((Component)Logo.createNetBeansLogo(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 5, 12), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)panelButtons, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.showNextTime, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 12, 15, 12), 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(colBackground);
            g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabHeader.this.showNextTime.requestFocusInWindow();
                }
            });
        }
    }

    private static class TabButton
    extends JPanel {
        private boolean isSelected = false;
        private ActionListener actionListener;
        private final int tabIndex;
        private final JLabel lblTitle = new JLabel();
        private boolean isMouseOver = false;

        public TabButton(String title, int tabIndex) {
            super(new BorderLayout());
            this.lblTitle.setText(title);
            this.add((Component)this.lblTitle, "Center");
            this.tabIndex = tabIndex;
            this.setOpaque(true);
            this.lblTitle.setFont(Constants.TAB_FONT);
            this.lblTitle.setForeground(Utils.getTopBarForeground());
            this.lblTitle.setHorizontalAlignment(0);
            this.setFocusable(true);
            this.setBackground(colBackground);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && null != TabButton.this.actionListener) {
                        TabButton.this.actionListener.actionPerformed(new ActionEvent(TabButton.this, 0, "clicked"));
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (null != TabButton.this.actionListener) {
                        TabButton.this.actionListener.actionPerformed(new ActionEvent(TabButton.this, 0, "clicked"));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!TabButton.this.isSelected) {
                        TabButton.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        TabButton.this.setCursor(Cursor.getDefaultCursor());
                    }
                    TabButton.this.isMouseOver = true;
                    TabButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TabButton.this.setCursor(Cursor.getDefaultCursor());
                    TabButton.this.isMouseOver = false;
                    TabButton.this.repaint();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    TabButton.this.isMouseOver = true;
                    TabButton.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TabButton.this.isMouseOver = false;
                    TabButton.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.isSelected) {
                g2d.drawImage(imgSelected, 0, 0, this.getWidth(), this.getHeight(), this);
            } else if (this.isMouseOver || this.isFocusOwner() || this.lblTitle.isFocusOwner()) {
                g2d.drawImage(imgRollover, 0, 0, this.getWidth(), this.getHeight(), this);
            } else {
                super.paintComponent(g);
            }
        }

        public void addActionListener(ActionListener l) {
            assert (null == this.actionListener);
            this.actionListener = l;
        }

        public void setSelected(boolean sel) {
            this.isSelected = sel;
            this.setFocusable(!sel);
            this.repaint();
        }

        public int getTabIndex() {
            return this.tabIndex;
        }
    }
}

