/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class JsxAttributeNode
extends Expression {
    private final String name;
    private final Expression value;

    public JsxAttributeNode(String string, Expression expression, long l, int n) {
        super(l, n);
        this.name = string;
        this.value = expression;
    }

    public JsxAttributeNode(JsxAttributeNode jsxAttributeNode, String string, Expression expression) {
        super(jsxAttributeNode);
        this.name = string;
        this.value = expression;
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    public JsxAttributeNode setValue(Expression expression) {
        if (this.value == expression) {
            return this;
        }
        return new JsxAttributeNode(this, this.name, expression);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterJsxAttributeNode(this)) {
            Expression expression = this.value == null ? null : (Expression)this.value.accept(nodeVisitor);
            return nodeVisitor.leaveJsxAttributeNode(this.setValue(expression));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterJsxAttributeNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.name);
        if (this.value != null) {
            stringBuilder.append('=');
            this.value.toString(stringBuilder, bl);
        }
    }
}

