/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ant.utils;

import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.java.testrunner.ant.utils.AntProject;
import org.netbeans.modules.java.testrunner.ant.utils.BatchTest;

public final class TestCounter {
    private final AntEvent event;

    public static int getTestClassCount(AntEvent event) {
        TestCounter counter = new TestCounter(event);
        return counter.countTestClasses();
    }

    private TestCounter(AntEvent event) {
        this.event = event;
    }

    private int countTestClasses() {
        String taskName = this.event.getTaskName();
        if (taskName.equals("junit")) {
            return this.countTestClassesInJUnitTask();
        }
        if (taskName.equals("java")) {
            return this.countTestClassesInJavaTask();
        }
        assert (false) : "Unhandled task name";
        return -1;
    }

    private int countTestClassesInJUnitTask() {
        int count = 0;
        TaskStructure taskStruct = this.event.getTaskStructure();
        for (TaskStructure child : taskStruct.getChildren()) {
            String childName = child.getName();
            if (childName.equals("test")) {
                if (!this.conditionsMet(child)) continue;
                ++count;
                continue;
            }
            if (!childName.equals("batchtest") || !this.conditionsMet(child)) continue;
            AntProject project = new AntProject(this.event);
            BatchTest batchTest = new BatchTest(project);
            batchTest.handleChildrenAndAttrs(child);
            int n = batchTest.countTestClasses();
            if (n <= 0) continue;
            count += n;
        }
        return count;
    }

    private boolean conditionsMet(TaskStructure struct) {
        String ifPropName = struct.getAttribute("if");
        String unlessPropName = struct.getAttribute("unless");
        if (ifPropName != null && this.event.getProperty(ifPropName) == null) {
            return false;
        }
        return unlessPropName == null || this.event.getProperty(unlessPropName) == null;
    }

    private int countTestClassesInJavaTask() {
        return 1;
    }
}

