/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class EnablePreviewSingleSourceFile
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.preview.feature.disabled", "compiler.err.preview.feature.disabled.plural"));
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private static final String SOURCE_FLAG = "--source";
    private static final String FILE_VM_OPTIONS = "single_file_vm_options";

    public Set<String> getCodes() {
        return Collections.unmodifiableSet(ERROR_CODES);
    }

    @NonNull
    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (SourceVersion.latest() != compilationInfo.getSourceVersion()) {
            return Collections.emptyList();
        }
        FileObject file = compilationInfo.getFileObject();
        ResolveFix fix = null;
        if (file != null) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            fix = prj == null ? new ResolveFix(file) : null;
        }
        return fix != null ? Collections.singletonList(fix) : Collections.emptyList();
    }

    public String getId() {
        return EnablePreviewSingleSourceFile.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(EnablePreviewSingleSourceFile.class, (String)"FIX_EnablePreviewFeature");
    }

    public String getDescription() {
        return NbBundle.getMessage(EnablePreviewSingleSourceFile.class, (String)"FIX_EnablePreviewFeature");
    }

    public void cancel() {
    }

    private static EditableProperties getEditableProperties(final FileObject file) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = file;
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        ep = new EditableProperties(false);
                        try (InputStream is = null;){
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    private static void storeEditableProperties(final EditableProperties ep, final FileObject file) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject propertiesFo = null;
                    if (file != null) {
                        propertiesFo = file;
                    }
                    if (propertiesFo != null) {
                        OutputStream os = null;
                        try {
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                        finally {
                            if (os != null) {
                                os.flush();
                                os.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    private static String getJdkRunVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        return javaVersion;
    }

    private static final class ResolveFix
    implements Fix {
        private FileObject file;

        ResolveFix(@NonNull FileObject file) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            this.file = file;
        }

        public String getText() {
            return NbBundle.getMessage(EnablePreviewSingleSourceFile.class, (String)"FIX_EnablePreviewFeature");
        }

        public ChangeInfo implement() throws Exception {
            EditableProperties ep = EnablePreviewSingleSourceFile.getEditableProperties(this.file);
            String compilerArgs = (String)this.file.getAttribute(EnablePreviewSingleSourceFile.FILE_VM_OPTIONS);
            compilerArgs = compilerArgs != null && !compilerArgs.isEmpty() ? (compilerArgs.contains(EnablePreviewSingleSourceFile.SOURCE_FLAG) ? compilerArgs + " " + EnablePreviewSingleSourceFile.ENABLE_PREVIEW_FLAG : compilerArgs + " " + EnablePreviewSingleSourceFile.ENABLE_PREVIEW_FLAG + " " + EnablePreviewSingleSourceFile.SOURCE_FLAG + " " + EnablePreviewSingleSourceFile.getJdkRunVersion()) : "--enable-preview --source " + EnablePreviewSingleSourceFile.getJdkRunVersion();
            this.file.setAttribute(EnablePreviewSingleSourceFile.FILE_VM_OPTIONS, (Object)compilerArgs);
            EnablePreviewSingleSourceFile.storeEditableProperties(ep, this.file);
            return null;
        }
    }
}

